/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageManager {
    private static final String DEFAULT_PREFIX = "{#ffde59>}&lMrUltimateFishing{#ffbd59<} &8|";
    private final JavaPlugin plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
    }

    public void reloadMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
    }

    public void reloadConfig() {
        this.reloadMessages();
    }

    public String getMessage(String path) {
        String message = this.fetchRawMessage(path);
        if (message == null) {
            return "&cMessage not found: " + path;
        }
        message = this.replacePrefixPlaceholder(message);
        message = this.removeMessageTag(message);
        return MrLibColors.colorize((String)message);
    }

    public String getMessage(String key, String ... placeholders) {
        String message = this.fetchRawMessage(key);
        if (message == null) {
            return "&cMessage not found: " + key;
        }
        message = this.replacePrefixPlaceholder(message);
        message = this.removeMessageTag(message);
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            String placeholder = placeholders[i];
            String value = placeholders[i + 1];
            message = message.replace(placeholder, value);
            if (placeholder.startsWith("{") || placeholder.startsWith("[")) continue;
            message = message.replace("{" + placeholder + "}", value);
            message = message.replace("[" + placeholder + "]", value);
        }
        return MrLibColors.colorize((String)message);
    }

    public void sendMessage(CommandSender sender, String key) {
        String message = this.getMessage(key);
        if (sender instanceof Player) {
            ((MrUltimateFishing)this.plugin).sendMessage((Player)sender, message);
        } else {
            sender.sendMessage(((MrUltimateFishing)this.plugin).prepareMessage(message, true));
        }
    }

    public void sendMessage(CommandSender sender, String key, String ... placeholders) {
        String message = this.getMessage(key, placeholders);
        if (sender instanceof Player) {
            ((MrUltimateFishing)this.plugin).sendMessage((Player)sender, message);
        } else {
            sender.sendMessage(((MrUltimateFishing)this.plugin).prepareMessage(message, true));
        }
    }

    public void broadcastMessage(String key, String ... placeholders) {
        String message = this.getMessage(key, placeholders);
        this.plugin.getServer().broadcastMessage(((MrUltimateFishing)this.plugin).prepareMessage(message, true));
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public String getPrefixValue() {
        String prefix = this.fetchRawMessage("Prefix");
        if (prefix == null || prefix.isEmpty()) {
            return MrLibColors.colorize((String)DEFAULT_PREFIX);
        }
        prefix = this.removeMessageTag(prefix);
        return MrLibColors.colorize((String)prefix);
    }

    public String getConfigString(String path, String defaultValue) {
        String newPath = "MrUltimateFishing." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getString(newPath, defaultValue);
        }
        return this.messagesConfig.getString(path, defaultValue);
    }

    public List<String> getConfigStringList(String path) {
        String newPath = "MrUltimateFishing." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getStringList(newPath);
        }
        return this.messagesConfig.getStringList(path);
    }

    public boolean getConfigBoolean(String path, boolean defaultValue) {
        String newPath = "MrUltimateFishing." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getBoolean(newPath, defaultValue);
        }
        return this.messagesConfig.getBoolean(path, defaultValue);
    }

    public int getConfigInt(String path, int defaultValue) {
        String newPath = "MrUltimateFishing." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getInt(newPath, defaultValue);
        }
        return this.messagesConfig.getInt(path, defaultValue);
    }

    public String getItemString(String path, String defaultValue) {
        String newPath = "MrUltimateFishing.Items." + path;
        String oldPath = "Items." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getString(newPath, defaultValue);
        }
        return this.messagesConfig.getString(oldPath, defaultValue);
    }

    public List<String> getItemStringList(String path) {
        String newPath = "MrUltimateFishing.Items." + path;
        String oldPath = "Items." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getStringList(newPath);
        }
        return this.messagesConfig.getStringList(oldPath);
    }

    public boolean getItemBoolean(String path, boolean defaultValue) {
        String newPath = "MrUltimateFishing.Items." + path;
        String oldPath = "Items." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getBoolean(newPath, defaultValue);
        }
        return this.messagesConfig.getBoolean(oldPath, defaultValue);
    }

    public int getItemInt(String path, int defaultValue) {
        String newPath = "MrUltimateFishing.Items." + path;
        String oldPath = "Items." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getInt(newPath, defaultValue);
        }
        return this.messagesConfig.getInt(oldPath, defaultValue);
    }

    public String getMenuKeyString(String path, String defaultValue) {
        String newPath = "MrUltimateFishing.menu-keys." + path;
        String oldPath = "menu-keys." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getString(newPath, defaultValue);
        }
        return this.messagesConfig.getString(oldPath, defaultValue);
    }

    public List<String> getMenuKeyStringList(String path) {
        String newPath = "MrUltimateFishing.menu-keys." + path;
        String oldPath = "menu-keys." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getStringList(newPath);
        }
        return this.messagesConfig.getStringList(oldPath);
    }

    public boolean getMenuKeyBoolean(String path, boolean defaultValue) {
        String newPath = "MrUltimateFishing.menu-keys." + path;
        String oldPath = "menu-keys." + path;
        if (this.messagesConfig.contains(newPath)) {
            return this.messagesConfig.getBoolean(newPath, defaultValue);
        }
        return this.messagesConfig.getBoolean(oldPath, defaultValue);
    }

    public ConfigurationSection getConfigSection(String path) {
        String newPath = "MrUltimateFishing." + path;
        ConfigurationSection section = this.messagesConfig.getConfigurationSection(newPath);
        if (section != null) {
            return section;
        }
        return this.messagesConfig.getConfigurationSection(path);
    }

    public String translateColors(String message) {
        return MrLibColors.colorize((String)message);
    }

    private String stripMessageTags(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.replaceAll("\\(!message!\\)", "").replaceAll("\\(!title!\\)", "").replaceAll("\\(!subtitle!\\)", "").replaceAll("\\(!actionbar!\\)", "").replaceAll("\\(!noprefix!\\)", "").replaceAll("\\(!NOPREFIX!\\)", "").replaceAll("\\(!hover:[^!]*!\\)", "").replaceAll("\\(!click:[^!]*!\\)", "").replaceAll("\\(!sound:[^!]*!\\)", "").replaceAll("\\(!close!\\)", "").trim();
    }

    private String fetchRawMessage(String path) {
        String message = this.messagesConfig.getString("MrUltimateFishing." + path);
        if (message == null) {
            message = this.messagesConfig.getString(path);
        }
        return message;
    }

    private String removeMessageTag(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        return message.replace("(!message!)", "");
    }

    private String replacePrefixPlaceholder(String message) {
        if (message == null || !message.contains("{prefix}")) {
            return message;
        }
        return message.replace("{prefix}", this.getPrefixValue());
    }
}

