/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing;

import eu.mrneznamy.mrlibcore.economy.MrLibVaultManager;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.ConfigManager;
import eu.mrneznamy.mrultimatefishing.FishItem;
import eu.mrneznamy.mrultimatefishing.MessageManager;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.managers.TournamentManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerDataManager {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;
    private final MrLibVaultManager vaultManager;
    private final Map<UUID, PlayerData> playerDataCache;
    private File playerDataFolder;
    private File firstCatchFile;
    private FileConfiguration firstCatchConfig;
    private File fishStatsFile;
    private FileConfiguration fishStatsConfig;
    private BukkitRunnable expiredDeliveryCheckTask;

    public PlayerDataManager(JavaPlugin plugin, ConfigManager configManager, MessageManager messageManager, MrLibVaultManager vaultManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.messageManager = messageManager;
        this.vaultManager = vaultManager;
        this.playerDataCache = new HashMap<UUID, PlayerData>();
        this.initializeFiles();
        this.startAutoSaveTask();
        this.startExpiredDeliveryCheckTask();
    }

    private void initializeFiles() {
        this.playerDataFolder = new File(this.plugin.getDataFolder(), "playerdata");
        if (!this.playerDataFolder.exists()) {
            this.playerDataFolder.mkdirs();
        }
        this.firstCatchFile = new File(this.plugin.getDataFolder(), "first-catches.yml");
        if (!this.firstCatchFile.exists()) {
            try {
                this.firstCatchFile.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getConsoleSender().sendMessage(MrLibColors.colorize((String)("&8[&aMrUltimateFishing&8] &cCould not create first-catches.yml: " + e.getMessage())));
            }
        }
        this.firstCatchConfig = YamlConfiguration.loadConfiguration((File)this.firstCatchFile);
        this.fishStatsFile = new File(this.plugin.getDataFolder(), "fish-stats.yml");
        if (!this.fishStatsFile.exists()) {
            try {
                this.fishStatsFile.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getConsoleSender().sendMessage(MrLibColors.colorize((String)("&8[&aMrUltimateFishing&8] &cCould not create fish-stats.yml: " + e.getMessage())));
            }
        }
        this.fishStatsConfig = YamlConfiguration.loadConfiguration((File)this.fishStatsFile);
    }

    public PlayerData getPlayerData(Player player) {
        return this.getPlayerData(player.getUniqueId());
    }

    public PlayerData getPlayerData(UUID playerId) {
        if (this.playerDataCache.containsKey(playerId)) {
            return this.playerDataCache.get(playerId);
        }
        PlayerData data = this.loadPlayerData(playerId);
        this.playerDataCache.put(playerId, data);
        return data;
    }

    private PlayerData loadPlayerData(UUID playerId) {
        ConfigurationSection waitingProgressSection;
        ConfigurationSection availableDeliveriesSection;
        File playerFile = new File(this.playerDataFolder, playerId.toString() + ".yml");
        if (!playerFile.exists()) {
            return this.createNewPlayerData(playerId);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
        PlayerData data = new PlayerData(playerId);
        data.setFishScale(config.getInt("fish-scale", this.configManager.getStartingFishScale()));
        data.setFishingLevel(config.getInt("fishing-level", 1));
        data.setFishingXP(config.getInt("fishing-xp", 0));
        data.setTotalFishCaught(config.getInt("total-fish-caught", 0));
        data.setUpgradePoints(config.getInt("upgrade-points", 0));
        data.setDeliverySlotsLevel(config.getInt("delivery.upgrade-slots-level", 0));
        data.setLessFishesToCompleteLevel(config.getInt("delivery.less-fishes-to-complete-level", 0));
        data.setLessFishesToGetLevel(config.getInt("delivery.less-fishes-to-get-level", 0));
        data.setMoreTimeToDeliveryLevel(config.getInt("delivery.more-time-to-delivery-level", 0));
        data.setLessShipmentTimeLevel(config.getInt("delivery.less-shipment-time-level", 0));
        ConfigurationSection activeDeliverySection = config.getConfigurationSection("delivery.active");
        if (activeDeliverySection != null) {
            data.setActiveDeliveryType(activeDeliverySection.getString("type"));
            data.setRequiredFishes(activeDeliverySection.getInt("required-fishes"));
            data.setCaughtFishes(activeDeliverySection.getInt("caught-fishes"));
            data.setDeliveryStartTime(activeDeliverySection.getLong("start-time"));
            data.setDeliveryCompleteTime(activeDeliverySection.getLong("complete-time"));
            data.setDeliveryCompleted(activeDeliverySection.getBoolean("completed"));
            data.setShipmentCompleteTime(activeDeliverySection.getLong("shipment-complete-time"));
            data.setDeliveryFishScalesReward(activeDeliverySection.getInt("fish-scales-reward"));
            data.setShipmentTimeMinutes(activeDeliverySection.getInt("shipment-time-minutes"));
            data.setActiveDeliverySlot(activeDeliverySection.getInt("slot", -1));
            ConfigurationSection fishRequirementsSection = activeDeliverySection.getConfigurationSection("fish-requirements");
            if (fishRequirementsSection != null) {
                HashMap<String, Integer> fishRequirements = new HashMap<String, Integer>();
                for (String fishName : fishRequirementsSection.getKeys(false)) {
                    int requiredCount = fishRequirementsSection.getInt(fishName);
                    fishRequirements.put(fishName, requiredCount);
                }
                data.setDeliveryFishRequirements(fishRequirements);
            }
        }
        if ((availableDeliveriesSection = config.getConfigurationSection("delivery.available")) != null) {
            HashMap<Integer, AvailableDelivery> availableDeliveries = new HashMap<Integer, AvailableDelivery>();
            for (String slotKey : availableDeliveriesSection.getKeys(false)) {
                try {
                    ArrayList<String> commandRewards;
                    int slotIndex = Integer.parseInt(slotKey);
                    ConfigurationSection deliverySection = availableDeliveriesSection.getConfigurationSection(slotKey);
                    if (deliverySection == null) continue;
                    String deliveryType = deliverySection.getString("type");
                    int requiredFishes = deliverySection.getInt("required-fishes");
                    int fishScalesReward = deliverySection.getInt("fish-scales-reward");
                    int shipmentTimeMinutes = deliverySection.getInt("shipment-time-minutes");
                    HashMap<String, Integer> fishRequirements = new HashMap<String, Integer>();
                    ConfigurationSection fishRequirementsSection = deliverySection.getConfigurationSection("fish-requirements");
                    if (fishRequirementsSection != null) {
                        for (String fishName : fishRequirementsSection.getKeys(false)) {
                            int requiredCount = fishRequirementsSection.getInt(fishName);
                            fishRequirements.put(fishName, requiredCount);
                        }
                    }
                    if ((commandRewards = deliverySection.getStringList("command-rewards")) == null) {
                        commandRewards = new ArrayList<String>();
                    }
                    AvailableDelivery availableDelivery = new AvailableDelivery(deliveryType, requiredFishes, fishRequirements, fishScalesReward, commandRewards, shipmentTimeMinutes);
                    availableDeliveries.put(slotIndex, availableDelivery);
                }
                catch (NumberFormatException slotIndex) {}
            }
            data.setAvailableDeliveries(availableDeliveries);
        }
        if ((waitingProgressSection = config.getConfigurationSection("delivery.waiting-progress")) != null) {
            HashMap<Integer, Integer> waitingProgress = new HashMap<Integer, Integer>();
            for (String key : waitingProgressSection.getKeys(false)) {
                try {
                    int slotIndex = Integer.parseInt(key);
                    int progress = waitingProgressSection.getInt(key, 0);
                    waitingProgress.put(slotIndex, progress);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            data.setWaitingDeliveryProgress(waitingProgress);
        }
        return data;
    }

    private PlayerData createNewPlayerData(UUID playerId) {
        PlayerData data = new PlayerData(playerId);
        data.setFishScale(this.configManager.getStartingFishScale());
        data.setFishingLevel(1);
        data.setFishingXP(0);
        data.setTotalFishCaught(0);
        data.setUpgradePoints(0);
        data.setDeliverySlotsLevel(0);
        data.setLessFishesToCompleteLevel(0);
        data.setLessFishesToGetLevel(0);
        data.setMoreTimeToDeliveryLevel(0);
        data.setLessShipmentTimeLevel(0);
        data.setActiveDeliveryType(null);
        data.setRequiredFishes(0);
        data.setCaughtFishes(0);
        data.setDeliveryStartTime(0L);
        data.setDeliveryCompleteTime(0L);
        data.setDeliveryCompleted(false);
        data.setDeliveryFishScalesReward(0);
        data.setDeliveryFishRequirements(new HashMap<String, Integer>());
        data.setShipmentTimeMinutes(0);
        data.setActiveDeliverySlot(-1);
        data.setAvailableDeliveries(new HashMap<Integer, AvailableDelivery>());
        data.setWaitingDeliveryProgress(new HashMap<Integer, Integer>());
        return data;
    }

    public void savePlayerData(UUID playerId) {
        PlayerData data = this.playerDataCache.get(playerId);
        if (data == null) {
            return;
        }
        File playerFile = new File(this.playerDataFolder, playerId.toString() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
        config.set("fish-scale", (Object)data.getFishScale());
        config.set("fishing-level", (Object)data.getFishingLevel());
        config.set("fishing-xp", (Object)data.getFishingXP());
        config.set("total-fish-caught", (Object)data.getTotalFishCaught());
        config.set("upgrade-points", (Object)data.getUpgradePoints());
        config.set("delivery.upgrade-slots-level", (Object)data.getDeliverySlotsLevel());
        config.set("delivery.less-fishes-to-complete-level", (Object)data.getLessFishesToCompleteLevel());
        config.set("delivery.less-fishes-to-get-level", (Object)data.getLessFishesToGetLevel());
        config.set("delivery.more-time-to-delivery-level", (Object)data.getMoreTimeToDeliveryLevel());
        config.set("delivery.less-shipment-time-level", (Object)data.getLessShipmentTimeLevel());
        Map<Integer, AvailableDelivery> availableDeliveries = data.getAvailableDeliveries();
        if (availableDeliveries != null && !availableDeliveries.isEmpty()) {
            for (Map.Entry<Integer, AvailableDelivery> entry : availableDeliveries.entrySet()) {
                int n = entry.getKey();
                AvailableDelivery availableDelivery = entry.getValue();
                if (availableDelivery == null) continue;
                config.set("delivery.available." + n + ".type", (Object)availableDelivery.getDeliveryType());
                config.set("delivery.available." + n + ".required-fishes", (Object)availableDelivery.getRequiredFishes());
                config.set("delivery.available." + n + ".fish-scales-reward", (Object)availableDelivery.getFishScalesReward());
                Map<String, Integer> fishRequirements = availableDelivery.getFishRequirements();
                if (fishRequirements != null && !fishRequirements.isEmpty()) {
                    for (Map.Entry<String, Integer> requirementEntry : fishRequirements.entrySet()) {
                        config.set("delivery.available." + n + ".fish-requirements." + requirementEntry.getKey(), (Object)requirementEntry.getValue());
                    }
                } else {
                    config.set("delivery.available." + n + ".fish-requirements", null);
                }
                List<String> commandRewards = availableDelivery.getCommandRewards();
                if (commandRewards != null && !commandRewards.isEmpty()) {
                    config.set("delivery.available." + n + ".command-rewards", commandRewards);
                } else {
                    config.set("delivery.available." + n + ".command-rewards", null);
                }
                config.set("delivery.available." + n + ".shipment-time-minutes", (Object)availableDelivery.getShipmentTimeMinutes());
            }
        } else {
            config.set("delivery.available", null);
        }
        if (data.getActiveDeliveryType() != null) {
            config.set("delivery.active.type", (Object)data.getActiveDeliveryType());
            config.set("delivery.active.required-fishes", (Object)data.getRequiredFishes());
            config.set("delivery.active.caught-fishes", (Object)data.getCaughtFishes());
            config.set("delivery.active.start-time", (Object)data.getDeliveryStartTime());
            config.set("delivery.active.complete-time", (Object)data.getDeliveryCompleteTime());
            config.set("delivery.active.completed", (Object)data.isDeliveryCompleted());
            config.set("delivery.active.shipment-complete-time", (Object)data.getShipmentCompleteTime());
            config.set("delivery.active.fish-scales-reward", (Object)data.getDeliveryFishScalesReward());
            config.set("delivery.active.shipment-time-minutes", (Object)data.getShipmentTimeMinutes());
            config.set("delivery.active.slot", (Object)data.getActiveDeliverySlot());
            Map<String, Integer> fishRequirements = data.getDeliveryFishRequirements();
            if (fishRequirements != null && !fishRequirements.isEmpty()) {
                for (Map.Entry<String, Integer> entry : fishRequirements.entrySet()) {
                    config.set("delivery.active.fish-requirements." + entry.getKey(), (Object)entry.getValue());
                }
            } else {
                config.set("delivery.active.fish-requirements", null);
            }
        } else {
            config.set("delivery.active", null);
        }
        Map<Integer, Integer> waitingProgress = data.getWaitingDeliveryProgress();
        if (waitingProgress != null && !waitingProgress.isEmpty()) {
            for (Map.Entry<Integer, Integer> entry : waitingProgress.entrySet()) {
                config.set("delivery.waiting-progress." + String.valueOf(entry.getKey()), (Object)entry.getValue());
            }
        } else {
            config.set("delivery.waiting-progress", null);
        }
        try {
            config.save(playerFile);
        }
        catch (IOException iOException) {
            Bukkit.getServer().getConsoleSender().sendMessage(MrLibColors.colorize((String)("&8[&aMrUltimateFishing&8] &cCould not save player data for " + String.valueOf(playerId) + ": " + iOException.getMessage())));
        }
    }

    public void savePlayerData(Player player) {
        this.savePlayerData(player.getUniqueId());
    }

    public void saveAllPlayerData() {
        for (UUID playerId : this.playerDataCache.keySet()) {
            this.savePlayerData(playerId);
        }
    }

    public void handleFishCatch(Player player, String fishId) {
        PlayerData data = this.getPlayerData(player);
        boolean isPlayerFirstCatch = this.checkAndRecordPlayerFirstCatch(player, fishId);
        this.recordGlobalFirstCatch(player, fishId);
        this.incrementFishCatchCount(fishId);
        int xpGained = this.calculateXPGain(fishId);
        this.addXP(player, xpGained);
        int fishScaleGained = this.calculateFishScaleGain(fishId);
        this.addFishScale(player, fishScaleGained);
        data.setTotalFishCaught(data.getTotalFishCaught() + 1);
        if (isPlayerFirstCatch) {
            this.giveFirstCatchBonus(player, fishId);
        }
    }

    private boolean checkAndRecordPlayerFirstCatch(Player player, String fishId) {
        String path = "players." + player.getUniqueId().toString() + "." + fishId;
        if (this.firstCatchConfig.contains(path)) {
            return false;
        }
        this.firstCatchConfig.set(path + ".timestamp", (Object)System.currentTimeMillis());
        try {
            this.firstCatchConfig.save(this.firstCatchFile);
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(MrLibColors.colorize((String)("&8[&aMrUltimateFishing&8] &cCould not save player first catch data: " + e.getMessage())));
        }
        return true;
    }

    private void giveFirstCatchBonus(Player player, String fishId) {
        int bonusMoney = this.plugin.getConfig().getInt("MrUltimateFishing.fishing.First-Caught.Money", 0);
        int bonusFishScales = this.plugin.getConfig().getInt("MrUltimateFishing.fishing.First-Caught.fish-scales", 0);
        if (bonusMoney <= 0 || this.vaultManager.deposit((OfflinePlayer)player, (double)bonusMoney)) {
            // empty if block
        }
        if (bonusFishScales > 0) {
            this.addFishScale(player, bonusFishScales);
        }
        String fishDisplayName = this.configManager.getFishDisplayName(fishId);
        this.messageManager.broadcastMessage("fishing.first-catch-bonus", "[PlayerName]", player.getName(), "[fish]", fishDisplayName, "[money]", String.valueOf(bonusMoney), "[fish_scales]", String.valueOf(bonusFishScales));
    }

    private void recordGlobalFirstCatch(Player player, String fishId) {
        if (!this.configManager.isTrackFirstCatch()) {
            return;
        }
        String path = "first-catches." + fishId;
        if (!this.fishStatsConfig.contains(path + ".player")) {
            this.fishStatsConfig.set(path + ".player", (Object)player.getName());
            this.fishStatsConfig.set(path + ".timestamp", (Object)System.currentTimeMillis());
            try {
                this.fishStatsConfig.save(this.fishStatsFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void incrementFishCatchCount(String fishId) {
        String path = "catch-counts." + fishId;
        int currentCount = this.fishStatsConfig.getInt(path, 0);
        this.fishStatsConfig.set(path, (Object)(currentCount + 1));
        try {
            this.fishStatsConfig.save(this.fishStatsFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getFirstCatchPlayer(String fishId) {
        if (!this.configManager.isTrackFirstCatch()) {
            return null;
        }
        return this.fishStatsConfig.getString("first-catches." + fishId + ".player");
    }

    public Long getFirstCatchTimestamp(String fishId) {
        if (!this.configManager.isTrackFirstCatch()) {
            return null;
        }
        long timestamp = this.fishStatsConfig.getLong("first-catches." + fishId + ".timestamp", 0L);
        return timestamp > 0L ? Long.valueOf(timestamp) : null;
    }

    public int getFishCatchCount(String fishId) {
        return this.fishStatsConfig.getInt("catch-counts." + fishId, 0);
    }

    private int calculateXPGain(String fishId) {
        if (this.isVanillaFish(fishId)) {
            double vanillaXP = this.configManager.getVanillaFishXPReward();
            return (int)vanillaXP;
        }
        boolean hasOverrideRarity = this.configManager.getFishOverrideRarity(fishId);
        if (hasOverrideRarity) {
            int customXP = (int)this.configManager.getFishXPReward(fishId);
            return customXP > 0 ? customXP : 10;
        }
        String rarityId = this.configManager.getFishRarity(fishId);
        if (rarityId != null) {
            int rarityXP = (int)this.configManager.getRarityXPReward(rarityId);
            return rarityXP;
        }
        return 10;
    }

    private int calculateFishScaleGain(String fishId) {
        if (this.isVanillaFish(fishId)) {
            double vanillaScale = this.configManager.getVanillaFishScale();
            return (int)vanillaScale;
        }
        boolean hasOverrideRarity = this.configManager.getFishOverrideRarity(fishId);
        if (hasOverrideRarity) {
            double fishScale = this.configManager.getFishFishScale(fishId);
            if (fishScale > 0.0) {
                return (int)fishScale;
            }
            String rarityId = this.configManager.getFishRarity(fishId);
            if (rarityId != null) {
                int rarityScale = (int)this.configManager.getRarityFishScale(rarityId);
                return rarityScale;
            }
        } else {
            String rarityId = this.configManager.getFishRarity(fishId);
            if (rarityId != null) {
                int rarityScale = (int)this.configManager.getRarityFishScale(rarityId);
                return rarityScale;
            }
        }
        return 1;
    }

    private boolean isVanillaFish(String fishId) {
        try {
            Material material = Material.valueOf((String)fishId.toUpperCase());
            return material == Material.COD || material == Material.SALMON || material == Material.TROPICAL_FISH || material == Material.PUFFERFISH;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void addXP(Player player, int xp) {
        PlayerData data = this.getPlayerData(player);
        data.setFishingXP(data.getFishingXP() + xp);
        int currentLevel = data.getFishingLevel();
        int requiredXP = this.getXPRequiredForNextLevel(player);
        if (data.getFishingXP() >= requiredXP) {
            data.setFishingLevel(currentLevel + 1);
            data.setFishingXP(data.getFishingXP() - requiredXP);
            data.setUpgradePoints(data.getUpgradePoints() + 1);
            if (this.plugin instanceof MrUltimateFishing) {
                ((MrUltimateFishing)this.plugin).getCommunityQuestIntegration().processFishLevelEarning(player, 1);
            }
            String message = this.messageManager.getMessage("fishing.level-up").replace("[level]", String.valueOf(currentLevel + 1));
            ((MrUltimateFishing)this.plugin).sendMessage(player, MrLibColors.colorize((String)message));
        }
    }

    public void addLevel(Player player, int levels) {
        int maxLevel;
        PlayerData data = this.getPlayerData(player);
        int currentLevel = data.getFishingLevel();
        int newLevel = Math.min(currentLevel + levels, maxLevel = this.configManager.getMaxLevel());
        int levelsGained = newLevel - currentLevel;
        if (levelsGained > 0) {
            data.setFishingLevel(newLevel);
            data.setFishingXP(0);
            this.addUpgradePoints(player, levelsGained);
            this.messageManager.sendMessage((CommandSender)player, "fishing.level-up", "[level]", String.valueOf(newLevel));
            for (int i = currentLevel + 1; i <= newLevel; ++i) {
                this.executeLevelRewards(player, i);
            }
        }
    }

    private void executeLevelRewards(Player player, int level) {
        if (!this.plugin.getConfig().getBoolean("MrUltimateFishing.leveling.enabled", true)) {
            return;
        }
        List rewardCommands = this.plugin.getConfig().getStringList("MrUltimateFishing.leveling.level-rewards-commands");
        if (rewardCommands != null && !rewardCommands.isEmpty()) {
            for (String command : rewardCommands) {
                ((MrUltimateFishing)this.plugin).executeRewardCommand(player, command);
            }
        }
    }

    public void addFishScale(Player player, int amount) {
        PlayerData data = this.getPlayerData(player);
        int currentAmount = data.getFishScale();
        int maxAmount = this.configManager.getMaxFishScale();
        int newAmount = Math.min(currentAmount + amount, maxAmount);
        data.setFishScale(newAmount);
        MrUltimateFishing mrPlugin = (MrUltimateFishing)this.plugin;
        mrPlugin.getTournamentManager().onPlayerAction(player, TournamentManager.TournamentType.MOSTENTROPYEARNEDFISH, "", amount);
        mrPlugin.getCommunityQuestIntegration().processFishScalesEarning(player, amount);
    }

    public boolean removeFishScale(Player player, int amount) {
        PlayerData data = this.getPlayerData(player);
        int currentAmount = data.getFishScale();
        if (currentAmount < amount) {
            return false;
        }
        data.setFishScale(currentAmount - amount);
        return true;
    }

    public int getXPRequiredForLevel(int level) {
        if (level <= 1) {
            return 0;
        }
        int baseXP = this.configManager.getBaseXP();
        double multiplier = this.configManager.getXPMultiplier();
        return (int)((double)baseXP * Math.pow(multiplier, level - 2));
    }

    public int getXPRequiredForNextLevel(Player player) {
        PlayerData data = this.getPlayerData(player);
        return this.getXPRequiredForLevel(data.getFishingLevel() + 1);
    }

    public void addUpgradePoints(Player player, int points) {
        PlayerData data = this.getPlayerData(player);
        data.setUpgradePoints(data.getUpgradePoints() + points);
    }

    public boolean removeUpgradePoints(Player player, int points) {
        PlayerData data = this.getPlayerData(player);
        int currentPoints = data.getUpgradePoints();
        if (currentPoints < points) {
            return false;
        }
        data.setUpgradePoints(currentPoints - points);
        return true;
    }

    public int getUpgradePoints(Player player) {
        PlayerData data = this.getPlayerData(player);
        return data.getUpgradePoints();
    }

    private void startAutoSaveTask() {
        if (!this.configManager.isAutoSaveEnabled()) {
            return;
        }
        int saveInterval = this.configManager.getSaveInterval() * 60 * 20;
        new BukkitRunnable(){

            public void run() {
                PlayerDataManager.this.saveAllPlayerData();
                if (PlayerDataManager.this.configManager.isDebugEnabled()) {
                    Bukkit.getServer().getConsoleSender().sendMessage(MrLibColors.colorize((String)"&8[&aMrUltimateFishing&8] &aAuto-saved all player data"));
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, (long)saveInterval, (long)saveInterval);
    }

    private void startExpiredDeliveryCheckTask() {
        this.expiredDeliveryCheckTask = new BukkitRunnable(){

            public void run() {
                PlayerDataManager.this.checkForExpiredDeliveries();
            }
        };
        this.expiredDeliveryCheckTask.runTaskTimer((Plugin)this.plugin, 200L, 200L);
    }

    private void checkForExpiredDeliveries() {
        for (PlayerData playerData : this.playerDataCache.values()) {
            long currentTime;
            if (!playerData.hasActiveDelivery() || playerData.isDeliveryCompleted() || (currentTime = System.currentTimeMillis()) < playerData.getDeliveryCompleteTime()) continue;
            this.resetExpiredDelivery(playerData);
        }
    }

    private void resetExpiredDelivery(PlayerData playerData) {
        String message;
        playerData.setActiveDeliveryType(null);
        playerData.setRequiredFishes(0);
        playerData.setCaughtFishes(0);
        playerData.setDeliveryStartTime(0L);
        playerData.setDeliveryCompleteTime(0L);
        playerData.setDeliveryCompleted(false);
        playerData.setDeliveryFishScalesReward(0);
        playerData.getDeliveryFishRequirements().clear();
        this.savePlayerData(playerData.getPlayerId());
        Player player = Bukkit.getPlayer((UUID)playerData.getPlayerId());
        if (player != null && player.isOnline() && (message = this.messageManager.getMessage("delivery.expired")) != null && !message.isEmpty()) {
            ((MrUltimateFishing)this.plugin).sendMessage(player, MrLibColors.colorize((String)message));
        }
    }

    public void onPlayerJoin(Player player) {
        PlayerData data = this.getPlayerData(player);
        if (data != null) {
            // empty if block
        }
    }

    public void onPlayerQuit(Player player) {
        this.savePlayerData(player);
        this.playerDataCache.remove(player.getUniqueId());
    }

    public int getLevel(Player player) {
        PlayerData data = this.getPlayerData(player);
        return data != null ? data.getFishingLevel() : 1;
    }

    public int getXP(Player player) {
        PlayerData data = this.getPlayerData(player);
        return data != null ? data.getFishingXP() : 0;
    }

    public int getFishScale(Player player) {
        PlayerData data = this.getPlayerData(player);
        return data != null ? data.getFishScale() : 0;
    }

    public void disable() {
        if (this.expiredDeliveryCheckTask != null) {
            this.expiredDeliveryCheckTask.cancel();
        }
        this.saveAllPlayerData();
        this.playerDataCache.clear();
    }

    public int getCurrentDeliverySlots(PlayerData playerData) {
        ConfigurationSection upgradesSection;
        FileConfiguration deliveryMenuConfig = this.configManager.getDeliveryMenuConfig();
        if (deliveryMenuConfig != null && (upgradesSection = deliveryMenuConfig.getConfigurationSection("MrUltimateFishing.Delivery.items.Upgrades.MoreDeliveries")) != null) {
            int firstLevel = upgradesSection.getInt("FirstLevel", 1);
            int forUpgradeGet = upgradesSection.getInt("ForUpgradeGet", 1);
            return firstLevel + playerData.getDeliverySlotsLevel() * forUpgradeGet;
        }
        return 1 + playerData.getDeliverySlotsLevel();
    }

    public int getMoreTimeToDeliveryBonus(PlayerData playerData) {
        ConfigurationSection upgradesSection;
        FileConfiguration deliveryMenuConfig = this.configManager.getDeliveryMenuConfig();
        if (deliveryMenuConfig != null && (upgradesSection = deliveryMenuConfig.getConfigurationSection("MrUltimateFishing.Delivery.items.Upgrades.MoreTimeToDelivery")) != null) {
            int forUpgradeGet = upgradesSection.getInt("ForUpgradeGet", 80);
            return playerData.getMoreTimeToDeliveryLevel() * forUpgradeGet;
        }
        return playerData.getMoreTimeToDeliveryLevel() * 80;
    }

    public int getLessShipmentTimeBonus(PlayerData playerData) {
        ConfigurationSection upgradesSection;
        FileConfiguration deliveryMenuConfig = this.configManager.getDeliveryMenuConfig();
        if (deliveryMenuConfig != null && (upgradesSection = deliveryMenuConfig.getConfigurationSection("MrUltimateFishing.Delivery.items.Upgrades.LessShipmentTime")) != null) {
            int forUpgradeGet = upgradesSection.getInt("ForUpgradeGet", 2);
            return playerData.getLessShipmentTimeLevel() * forUpgradeGet;
        }
        return playerData.getLessShipmentTimeLevel() * 2;
    }

    public static class PlayerData {
        private final UUID playerId;
        private int fishScale;
        private int fishingLevel;
        private int fishingXP;
        private int totalFishCaught;
        private int upgradePoints;
        private int deliverySlotsLevel;
        private int lessFishesToCompleteLevel;
        private int lessFishesToGetLevel;
        private int moreTimeToDeliveryLevel;
        private int lessShipmentTimeLevel;
        private String activeDeliveryType;
        private int requiredFishes;
        private int caughtFishes;
        private long deliveryStartTime;
        private long deliveryCompleteTime;
        private boolean deliveryCompleted;
        private long shipmentCompleteTime;
        private int deliveryFishScalesReward;
        private Map<String, Integer> deliveryFishRequirements;
        private int shipmentTimeMinutes;
        private int activeDeliverySlot;
        private Map<Integer, AvailableDelivery> availableDeliveries;
        private Map<Integer, Integer> waitingDeliveryProgress;

        public PlayerData(UUID playerId) {
            this.playerId = playerId;
            this.upgradePoints = 0;
            this.deliverySlotsLevel = 0;
            this.lessFishesToCompleteLevel = 0;
            this.lessFishesToGetLevel = 0;
            this.moreTimeToDeliveryLevel = 0;
            this.lessShipmentTimeLevel = 0;
            this.activeDeliveryType = null;
            this.requiredFishes = 0;
            this.caughtFishes = 0;
            this.deliveryStartTime = 0L;
            this.deliveryCompleteTime = 0L;
            this.deliveryCompleted = false;
            this.shipmentCompleteTime = 0L;
            this.deliveryFishScalesReward = 0;
            this.deliveryFishRequirements = new HashMap<String, Integer>();
            this.shipmentTimeMinutes = 0;
            this.activeDeliverySlot = -1;
            this.availableDeliveries = new HashMap<Integer, AvailableDelivery>();
            this.waitingDeliveryProgress = new HashMap<Integer, Integer>();
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public int getFishScale() {
            return this.fishScale;
        }

        public void setFishScale(int fishScale) {
            this.fishScale = fishScale;
        }

        public int getFishingLevel() {
            return this.fishingLevel;
        }

        public void setFishingLevel(int fishingLevel) {
            this.fishingLevel = fishingLevel;
        }

        public int getFishingXP() {
            return this.fishingXP;
        }

        public void setFishingXP(int fishingXP) {
            this.fishingXP = fishingXP;
        }

        public int getTotalFishCaught() {
            return this.totalFishCaught;
        }

        public void setTotalFishCaught(int totalFishCaught) {
            this.totalFishCaught = totalFishCaught;
        }

        public int getUpgradePoints() {
            return this.upgradePoints;
        }

        public void setUpgradePoints(int upgradePoints) {
            this.upgradePoints = upgradePoints;
        }

        public int getDeliverySlotsLevel() {
            return this.deliverySlotsLevel;
        }

        public void setDeliverySlotsLevel(int level) {
            this.deliverySlotsLevel = level;
        }

        public int getLessFishesToCompleteLevel() {
            return this.lessFishesToCompleteLevel;
        }

        public void setLessFishesToCompleteLevel(int level) {
            this.lessFishesToCompleteLevel = level;
        }

        public int getLessFishesToGetLevel() {
            return this.lessFishesToGetLevel;
        }

        public void setLessFishesToGetLevel(int level) {
            this.lessFishesToGetLevel = level;
        }

        public int getMoreTimeToDeliveryLevel() {
            return this.moreTimeToDeliveryLevel;
        }

        public void setMoreTimeToDeliveryLevel(int level) {
            this.moreTimeToDeliveryLevel = level;
        }

        public int getLessShipmentTimeLevel() {
            return this.lessShipmentTimeLevel;
        }

        public void setLessShipmentTimeLevel(int level) {
            this.lessShipmentTimeLevel = level;
        }

        public String getActiveDeliveryType() {
            return this.activeDeliveryType;
        }

        public void setActiveDeliveryType(String type) {
            this.activeDeliveryType = type;
        }

        public int getRequiredFishes() {
            return this.requiredFishes;
        }

        public void setRequiredFishes(int count) {
            this.requiredFishes = count;
        }

        public int getCaughtFishes() {
            return this.caughtFishes;
        }

        public void setCaughtFishes(int count) {
            this.caughtFishes = count;
        }

        public long getDeliveryStartTime() {
            return this.deliveryStartTime;
        }

        public void setDeliveryStartTime(long time) {
            this.deliveryStartTime = time;
        }

        public long getDeliveryCompleteTime() {
            return this.deliveryCompleteTime;
        }

        public void setDeliveryCompleteTime(long time) {
            this.deliveryCompleteTime = time;
        }

        public boolean isDeliveryCompleted() {
            return this.deliveryCompleted;
        }

        public void setDeliveryCompleted(boolean completed) {
            this.deliveryCompleted = completed;
        }

        public long getShipmentCompleteTime() {
            return this.shipmentCompleteTime;
        }

        public void setShipmentCompleteTime(long time) {
            this.shipmentCompleteTime = time;
        }

        public int getDeliveryFishScalesReward() {
            return this.deliveryFishScalesReward;
        }

        public void setDeliveryFishScalesReward(int reward) {
            this.deliveryFishScalesReward = reward;
        }

        public Map<String, Integer> getDeliveryFishRequirements() {
            return this.deliveryFishRequirements;
        }

        public void setDeliveryFishRequirements(Map<String, Integer> requirements) {
            this.deliveryFishRequirements = requirements;
        }

        public int getShipmentTimeMinutes() {
            return this.shipmentTimeMinutes;
        }

        public void setShipmentTimeMinutes(int minutes) {
            this.shipmentTimeMinutes = minutes;
        }

        public int getActiveDeliverySlot() {
            return this.activeDeliverySlot;
        }

        public void setActiveDeliverySlot(int slot) {
            this.activeDeliverySlot = slot;
        }

        public Map<Integer, AvailableDelivery> getAvailableDeliveries() {
            return this.availableDeliveries;
        }

        public void setAvailableDeliveries(Map<Integer, AvailableDelivery> availableDeliveries) {
            this.availableDeliveries = availableDeliveries;
        }

        public AvailableDelivery getAvailableDelivery(int slotIndex) {
            return this.availableDeliveries.get(slotIndex);
        }

        public void setAvailableDelivery(int slotIndex, AvailableDelivery availableDelivery) {
            if (availableDelivery == null) {
                this.availableDeliveries.remove(slotIndex);
            } else {
                this.availableDeliveries.put(slotIndex, availableDelivery);
            }
        }

        public boolean hasAvailableDelivery(int slotIndex) {
            return this.availableDeliveries.containsKey(slotIndex) && this.availableDeliveries.get(slotIndex) != null;
        }

        public Map<Integer, Integer> getWaitingDeliveryProgress() {
            return this.waitingDeliveryProgress;
        }

        public void setWaitingDeliveryProgress(Map<Integer, Integer> progress) {
            this.waitingDeliveryProgress = progress;
        }

        public int getWaitingDeliveryProgress(int slotIndex) {
            return this.waitingDeliveryProgress.getOrDefault(slotIndex, 0);
        }

        public void setWaitingDeliveryProgress(int slotIndex, int progress) {
            this.waitingDeliveryProgress.put(slotIndex, progress);
        }

        public void incrementWaitingDeliveryProgress(int slotIndex) {
            int currentProgress = this.waitingDeliveryProgress.getOrDefault(slotIndex, 0);
            this.waitingDeliveryProgress.put(slotIndex, currentProgress + 1);
        }

        public int getCurrentDeliverySlots() {
            return 1 + this.deliverySlotsLevel;
        }

        public int getLessFishesToCompleteBonus() {
            return this.lessFishesToCompleteLevel;
        }

        public int getLessFishesToGetBonus() {
            return this.lessFishesToGetLevel;
        }

        public int getMoreTimeToDeliveryBonus() {
            return this.moreTimeToDeliveryLevel;
        }

        public int getLessShipmentTimeBonus() {
            return this.lessShipmentTimeLevel;
        }

        public boolean hasActiveDelivery() {
            return this.activeDeliveryType != null && !this.deliveryCompleted;
        }

        public boolean hasCompletedDelivery() {
            return this.activeDeliveryType != null && this.deliveryCompleted;
        }

        public long getActiveDeliveryTime() {
            return (this.deliveryCompleteTime - this.deliveryStartTime) / 1000L;
        }

        public FishItem getAvailableDeliveryFish(int slotIndex) {
            AvailableDelivery availableDelivery = this.getAvailableDelivery(slotIndex);
            if (availableDelivery != null) {
                return null;
            }
            return null;
        }

        public void incrementCaughtFishes() {
            if (this.hasActiveDelivery()) {
                ++this.caughtFishes;
            }
        }
    }

    public static class AvailableDelivery {
        private String deliveryType;
        private int requiredFishes;
        private Map<String, Integer> fishRequirements;
        private int fishScalesReward;
        private List<String> commandRewards;
        private int shipmentTimeMinutes;

        public AvailableDelivery() {
            this.fishRequirements = new HashMap<String, Integer>();
            this.commandRewards = new ArrayList<String>();
            this.shipmentTimeMinutes = 0;
        }

        public AvailableDelivery(String deliveryType, int requiredFishes, Map<String, Integer> fishRequirements, int fishScalesReward, List<String> commandRewards, int shipmentTimeMinutes) {
            this.deliveryType = deliveryType;
            this.requiredFishes = requiredFishes;
            this.fishRequirements = fishRequirements != null ? fishRequirements : new HashMap();
            this.fishScalesReward = fishScalesReward;
            this.commandRewards = commandRewards != null ? commandRewards : new ArrayList();
            this.shipmentTimeMinutes = shipmentTimeMinutes;
        }

        public String getDeliveryType() {
            return this.deliveryType;
        }

        public void setDeliveryType(String deliveryType) {
            this.deliveryType = deliveryType;
        }

        public int getRequiredFishes() {
            return this.requiredFishes;
        }

        public void setRequiredFishes(int requiredFishes) {
            this.requiredFishes = requiredFishes;
        }

        public Map<String, Integer> getFishRequirements() {
            return this.fishRequirements;
        }

        public void setFishRequirements(Map<String, Integer> fishRequirements) {
            this.fishRequirements = fishRequirements;
        }

        public int getFishScalesReward() {
            return this.fishScalesReward;
        }

        public void setFishScalesReward(int fishScalesReward) {
            this.fishScalesReward = fishScalesReward;
        }

        public List<String> getCommandRewards() {
            return this.commandRewards;
        }

        public void setCommandRewards(List<String> commandRewards) {
            this.commandRewards = commandRewards;
        }

        public int getShipmentTimeMinutes() {
            return this.shipmentTimeMinutes;
        }

        public void setShipmentTimeMinutes(int shipmentTimeMinutes) {
            this.shipmentTimeMinutes = shipmentTimeMinutes;
        }
    }
}

