/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.commands;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.ConfigManager;
import eu.mrneznamy.mrultimatefishing.CustomDropsManager;
import eu.mrneznamy.mrultimatefishing.FishItem;
import eu.mrneznamy.mrultimatefishing.MessageManager;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FishCommand
implements CommandExecutor,
TabCompleter {
    private final MrUltimateFishing plugin;
    private final MessageManager messageManager;
    private final ConfigManager configManager;
    private final CustomDropsManager customDropsManager;

    public FishCommand(MrUltimateFishing plugin, MessageManager messageManager, ConfigManager configManager, CustomDropsManager customDropsManager) {
        this.plugin = plugin;
        this.messageManager = messageManager;
        this.configManager = configManager;
        this.customDropsManager = customDropsManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.messageManager.sendMessage(sender, "invalid-command");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "menu": {
                if (!(sender instanceof Player)) {
                    this.messageManager.sendMessage(sender, "invalid-command");
                    return true;
                }
                this.plugin.getMenuManager().openHeadMenu((Player)sender);
                return true;
            }
            case "reload": {
                if (!sender.hasPermission("mrultimatefishing.reload")) {
                    this.messageManager.sendMessage(sender, "no-permission");
                    return true;
                }
                try {
                    this.messageManager.reloadConfig();
                    this.configManager.reloadConfigs();
                    this.plugin.getTournamentManager().reloadConfig();
                    this.plugin.getEventManager().reloadConfig();
                    this.plugin.getTotemManager().rebuildAllTotemHolograms();
                    this.messageManager.sendMessage(sender, "commands.reload.success");
                }
                catch (Exception e) {
                    this.messageManager.sendMessage(sender, "reload-failed");
                    e.printStackTrace();
                }
                break;
            }
            case "give": {
                if (!sender.hasPermission("mrultimatefishing.give")) {
                    this.messageManager.sendMessage(sender, "no-permission");
                    return true;
                }
                this.handleGiveCommand(sender, args);
                break;
            }
            case "take": {
                if (!sender.hasPermission("mrultimatefishing.take")) {
                    this.messageManager.sendMessage(sender, "no-permission");
                    return true;
                }
                this.handleTakeCommand(sender, args);
                break;
            }
            default: {
                if (!(sender instanceof Player)) {
                    this.messageManager.sendMessage(sender, "invalid-command");
                    return true;
                }
                Player player = (Player)sender;
                Player targetPlayer = this.plugin.getServer().getPlayer(args[0]);
                if (targetPlayer != null && sender.hasPermission("mrultimatefishing.admin")) {
                    this.plugin.getMenuManager().openHeadMenu(targetPlayer);
                    this.messageManager.sendMessage(sender, "menu-opened-for-player", "player", targetPlayer.getName());
                    break;
                }
                this.plugin.getMenuManager().openHeadMenu(player);
            }
        }
        return true;
    }

    private void handleGiveCommand(CommandSender sender, String[] args) {
        String type;
        if (args.length < 2) {
            this.messageManager.sendMessage(sender, "commands.give.usage", "command", "fish");
            this.messageManager.sendMessage(sender, "commands.give.types");
            return;
        }
        switch (type = args[1].toLowerCase()) {
            case "fish": {
                this.handleGiveFish(sender, args);
                break;
            }
            case "level": {
                this.handleGiveLevel(sender, args);
                break;
            }
            case "xp": {
                this.handleGiveXP(sender, args);
                break;
            }
            case "fishscale": {
                this.handleGiveFishScale(sender, args);
                break;
            }
            case "upgradepoints": {
                this.handleGiveUpgradePoints(sender, args);
                break;
            }
            case "item": {
                this.handleGiveItem(sender, args);
                break;
            }
            case "enchant": {
                this.handleGiveEnchant(sender, args);
                break;
            }
            default: {
                this.messageManager.sendMessage(sender, "commands.give.invalid-type", "type", type);
                this.messageManager.sendMessage(sender, "commands.give.types");
            }
        }
    }

    private void handleGiveFish(CommandSender sender, String[] args) {
        int amount;
        if (args.length < 5) {
            this.messageManager.sendMessage(sender, "commands.give.fish.usage", "command", "fish");
            return;
        }
        String fishInput = args[2].replace('_', ' ');
        String fishId = this.configManager.getFishIdByName(fishInput);
        if (fishId == null) {
            fishId = args[2];
        }
        String amountStr = args[3];
        String playerName = args[4];
        if (!this.configManager.fishExists(fishId)) {
            this.messageManager.sendMessage(sender, "commands.give.fish.not-exist", "fish", fishInput);
            return;
        }
        String displayName = this.configManager.getCleanFishName(fishId);
        String fishPlaceholder = displayName != null ? displayName : fishId;
        try {
            amount = Integer.parseInt(amountStr);
            if (amount <= 0) {
                this.messageManager.sendMessage(sender, "commands.give.amount-positive");
                return;
            }
        }
        catch (NumberFormatException e) {
            this.messageManager.sendMessage(sender, "commands.give.invalid-amount", "amount", amountStr);
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            this.messageManager.sendMessage(sender, "commands.give.player-not-found", "player", playerName);
            return;
        }
        FishItem fishItem = new FishItem(this.configManager);
        for (int i = 0; i < amount; ++i) {
            ItemStack fish = fishItem.createFishItem(fishId, targetPlayer);
            targetPlayer.getInventory().addItem(new ItemStack[]{fish});
        }
        this.messageManager.sendMessage(sender, "commands.give.fish.success", "amount", String.valueOf(amount), "fish", fishPlaceholder, "player", targetPlayer.getName());
        this.messageManager.sendMessage((CommandSender)targetPlayer, "commands.give.fish.received", "amount", String.valueOf(amount), "fish", fishPlaceholder, "sender", sender.getName());
    }

    private void handleGiveLevel(CommandSender sender, String[] args) {
        int amount;
        if (args.length < 4) {
            this.sendColoredMessage(sender, "&cUsage: /fish give level <amount> <player>");
            return;
        }
        String amountStr = args[2];
        String playerName = args[3];
        try {
            amount = Integer.parseInt(amountStr);
            if (amount <= 0) {
                this.messageManager.sendMessage(sender, "commands.give.amount-positive");
                return;
            }
        }
        catch (NumberFormatException e) {
            this.messageManager.sendMessage(sender, "commands.give.invalid-amount", "amount", amountStr);
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            this.messageManager.sendMessage(sender, "commands.give.player-not-found", "player", playerName);
            return;
        }
        this.plugin.getPlayerDataManager().addLevel(targetPlayer, amount);
        this.sendColoredMessage(sender, "&aGave " + amount + " level(s) to " + targetPlayer.getName());
        this.sendColoredMessage((CommandSender)targetPlayer, "&aYou received " + amount + " level(s) from " + sender.getName());
    }

    private void handleGiveXP(CommandSender sender, String[] args) {
        int amount;
        if (args.length < 4) {
            this.messageManager.sendMessage(sender, "commands.give.xp.usage", "command", "fish");
            return;
        }
        String amountStr = args[2];
        String playerName = args[3];
        try {
            amount = Integer.parseInt(amountStr);
            if (amount <= 0) {
                this.sendColoredMessage(sender, "&cAmount must be a positive number!");
                return;
            }
        }
        catch (NumberFormatException e) {
            this.sendColoredMessage(sender, "&cInvalid amount: " + amountStr);
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            this.sendColoredMessage(sender, "&cPlayer not found: " + playerName);
            return;
        }
        this.plugin.getPlayerDataManager().addXP(targetPlayer, amount);
        this.sendColoredMessage(sender, "&aGave " + amount + " XP to " + targetPlayer.getName());
        this.sendColoredMessage((CommandSender)targetPlayer, "&aYou received " + amount + " XP from " + sender.getName());
    }

    private void handleGiveFishScale(CommandSender sender, String[] args) {
        int amount;
        if (args.length < 4) {
            this.messageManager.sendMessage(sender, "commands.give.fishscale.usage", "command", "fish");
            return;
        }
        String amountStr = args[2];
        String playerName = args[3];
        try {
            amount = Integer.parseInt(amountStr);
            if (amount <= 0) {
                this.sendColoredMessage(sender, "&cAmount must be a positive number!");
                return;
            }
        }
        catch (NumberFormatException e) {
            this.sendColoredMessage(sender, "&cInvalid amount: " + amountStr);
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            this.sendColoredMessage(sender, "&cPlayer not found: " + playerName);
            return;
        }
        this.plugin.getPlayerDataManager().addFishScale(targetPlayer, amount);
        this.sendColoredMessage(sender, "&aGave " + amount + " fish scale(s) to " + targetPlayer.getName());
        this.sendColoredMessage((CommandSender)targetPlayer, "&aYou received " + amount + " fish scale(s) from " + sender.getName());
    }

    private void handleGiveUpgradePoints(CommandSender sender, String[] args) {
        int amount;
        if (args.length < 4) {
            this.messageManager.sendMessage(sender, "commands.give.upgradepoints.usage", "command", "fish");
            return;
        }
        String amountStr = args[2];
        String playerName = args[3];
        try {
            amount = Integer.parseInt(amountStr);
            if (amount <= 0) {
                this.sendColoredMessage(sender, "&cAmount must be a positive number!");
                return;
            }
        }
        catch (NumberFormatException e) {
            this.sendColoredMessage(sender, "&cInvalid amount: " + amountStr);
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            this.sendColoredMessage(sender, "&cPlayer not found: " + playerName);
            return;
        }
        this.plugin.getPlayerDataManager().addUpgradePoints(targetPlayer, amount);
        this.sendColoredMessage(sender, "&aGave " + amount + " upgrade point(s) to " + targetPlayer.getName());
        this.sendColoredMessage((CommandSender)targetPlayer, "&aYou received " + amount + " upgrade point(s) from " + sender.getName());
    }

    private void handleGiveItem(CommandSender sender, String[] args) {
        int amount;
        if (args.length < 5) {
            this.messageManager.sendMessage(sender, "commands.give.item.usage", "command", "fish");
            return;
        }
        String itemType = args[2].toLowerCase();
        String amountStr = args[3];
        String playerName = args[4];
        if (!(itemType.equals("squid-tentacle") || itemType.equals("dolphin-tail") || itemType.equals("crab-claws") || itemType.equals("crab-shell"))) {
            this.messageManager.sendMessage(sender, "commands.give.item.invalid-type", "type", itemType);
            return;
        }
        try {
            amount = Integer.parseInt(amountStr);
            if (amount <= 0) {
                this.sendColoredMessage(sender, "&cAmount must be a positive number!");
                return;
            }
        }
        catch (NumberFormatException e) {
            this.sendColoredMessage(sender, "&cInvalid amount: " + amountStr);
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            this.sendColoredMessage(sender, "&cPlayer not found: " + playerName);
            return;
        }
        ItemStack item = null;
        switch (itemType) {
            case "squid-tentacle": {
                item = this.customDropsManager.createSquidTentacle();
                break;
            }
            case "dolphin-tail": {
                item = this.customDropsManager.createDolphinTail();
                break;
            }
            case "crab-claws": {
                item = this.customDropsManager.createCrabClaws();
                break;
            }
            case "crab-shell": {
                item = this.customDropsManager.createCrabShell();
            }
        }
        if (item != null) {
            item.setAmount(amount);
            targetPlayer.getInventory().addItem(new ItemStack[]{item});
            this.messageManager.sendMessage(sender, "commands.give.item.success", "amount", String.valueOf(amount), "item", itemType, "player", targetPlayer.getName());
            this.messageManager.sendMessage((CommandSender)targetPlayer, "commands.give.item.received", "amount", String.valueOf(amount), "item", itemType, "sender", sender.getName());
        } else {
            this.messageManager.sendMessage(sender, "commands.give.item.failed", "item", itemType);
        }
    }

    private void handleGiveEnchant(CommandSender sender, String[] args) {
        int amount;
        if (args.length < 5) {
            this.messageManager.sendMessage(sender, "commands.give.enchant.usage", "command", "fish");
            return;
        }
        String enchantName = args[2];
        String amountStr = args[3];
        String playerName = args[4];
        if (!(enchantName.equalsIgnoreCase("GoldenPlace") || enchantName.equalsIgnoreCase("MagicStorm") || enchantName.equalsIgnoreCase("Feeding") || enchantName.equalsIgnoreCase("BiomeTeleportation") || enchantName.equalsIgnoreCase("CrabBait") || enchantName.equalsIgnoreCase("ProfessionalFisher") || enchantName.equalsIgnoreCase("SharpBait"))) {
            this.messageManager.sendMessage(sender, "commands.give.enchant.invalid-name", "enchant", enchantName);
            return;
        }
        if (enchantName.equalsIgnoreCase("goldenplace")) {
            enchantName = "GoldenPlace";
        } else if (enchantName.equalsIgnoreCase("magicstorm")) {
            enchantName = "MagicStorm";
        } else if (enchantName.equalsIgnoreCase("feeding")) {
            enchantName = "Feeding";
        } else if (enchantName.equalsIgnoreCase("biometeleportation")) {
            enchantName = "BiomeTeleportation";
        } else if (enchantName.equalsIgnoreCase("crabbait")) {
            enchantName = "CrabBait";
        } else if (enchantName.equalsIgnoreCase("professionalfisher")) {
            enchantName = "ProfessionalFisher";
        } else if (enchantName.equalsIgnoreCase("sharpbait")) {
            enchantName = "SharpBait";
        }
        try {
            amount = Integer.parseInt(amountStr);
            if (amount <= 0) {
                this.sendColoredMessage(sender, "&cAmount must be a positive number!");
                return;
            }
        }
        catch (NumberFormatException e) {
            this.sendColoredMessage(sender, "&cInvalid amount: " + amountStr);
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            this.sendColoredMessage(sender, "&cPlayer not found: " + playerName);
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack enchantItem = this.plugin.getEnchantManager().createEnchantItem(enchantName);
            if (enchantItem == null) {
                this.sendColoredMessage(sender, "&cFailed to create enchant item: " + enchantName);
                return;
            }
            targetPlayer.getInventory().addItem(new ItemStack[]{enchantItem});
        }
        this.sendColoredMessage(sender, "&aGave " + amount + " " + enchantName + " enchant(s) to " + targetPlayer.getName());
        this.sendColoredMessage((CommandSender)targetPlayer, "&aYou received " + amount + " " + enchantName + " enchant(s) from " + sender.getName());
    }

    private void sendColoredMessage(CommandSender sender, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        sender.sendMessage(MrLibColors.colorize((String)message));
    }

    private void handleTakeCommand(CommandSender sender, String[] args) {
        int amount;
        if (args.length < 4) {
            this.messageManager.sendMessage(sender, "commands.take.usage", "command", "fish");
            return;
        }
        String type = args[1].toLowerCase();
        String amountStr = args[2];
        String playerName = args[3];
        if (!type.equals("level") && !type.equals("fishscales")) {
            this.messageManager.sendMessage(sender, "commands.take.invalid-type", "type", type);
            return;
        }
        try {
            amount = Integer.parseInt(amountStr);
            if (amount <= 0) {
                this.messageManager.sendMessage(sender, "commands.take.amount-positive");
                return;
            }
        }
        catch (NumberFormatException e) {
            this.messageManager.sendMessage(sender, "commands.take.invalid-amount", "amount", amountStr);
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            this.messageManager.sendMessage(sender, "commands.take.player-not-found", "player", playerName);
            return;
        }
        switch (type) {
            case "level": {
                int currentLevel = this.plugin.getPlayerDataManager().getLevel(targetPlayer);
                int levelsToTake = Math.min(amount, Math.max(0, currentLevel - 1));
                if (levelsToTake > 0) {
                    this.plugin.getPlayerDataManager().getPlayerData(targetPlayer).setFishingLevel(currentLevel - levelsToTake);
                    this.plugin.getPlayerDataManager().getPlayerData(targetPlayer).setFishingXP(0);
                    this.messageManager.sendMessage(sender, "commands.take.level.success", "amount", String.valueOf(levelsToTake), "player", targetPlayer.getName());
                    this.messageManager.sendMessage((CommandSender)targetPlayer, "commands.take.level.removed", "amount", String.valueOf(levelsToTake), "sender", sender.getName());
                    break;
                }
                this.messageManager.sendMessage(sender, "commands.take.level.insufficient", "player", targetPlayer.getName());
                break;
            }
            case "fishscales": {
                boolean success = this.plugin.getPlayerDataManager().removeFishScale(targetPlayer, amount);
                if (success) {
                    this.messageManager.sendMessage(sender, "commands.take.fishscales.success", "amount", String.valueOf(amount), "player", targetPlayer.getName());
                    this.messageManager.sendMessage((CommandSender)targetPlayer, "commands.take.fishscales.removed", "amount", String.valueOf(amount), "sender", sender.getName());
                    break;
                }
                this.messageManager.sendMessage(sender, "commands.take.fishscales.insufficient", "player", targetPlayer.getName());
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("menu", "reload", "give", "take");
            for (String subcommand : subcommands) {
                if (!subcommand.toLowerCase().startsWith(args[0].toLowerCase()) || subcommand.equals("reload") && !sender.hasPermission("mrultimatefishing.reload") || subcommand.equals("give") && !sender.hasPermission("mrultimatefishing.give") || subcommand.equals("take") && !sender.hasPermission("mrultimatefishing.take")) continue;
                completions.add(subcommand);
            }
            if (sender.hasPermission("mrultimatefishing.admin")) {
                for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    completions.add(player.getName());
                }
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            if (sender.hasPermission("mrultimatefishing.give")) {
                completions.addAll(Arrays.asList("fish", "level", "xp", "fishscale", "upgradepoints", "item", "enchant"));
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("take")) {
            if (sender.hasPermission("mrultimatefishing.take")) {
                completions.addAll(Arrays.asList("level", "fishscales"));
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("give")) {
            if (sender.hasPermission("mrultimatefishing.give")) {
                String subType = args[1].toLowerCase();
                if (subType.equals("fish")) {
                    completions.addAll(this.configManager.getFishCommandSuggestions());
                } else if (subType.equals("item")) {
                    completions.addAll(Arrays.asList("squid-tentacle", "dolphin-tail", "crab-claws", "crab-shell"));
                } else if (subType.equals("enchant")) {
                    completions.addAll(Arrays.asList("GoldenPlace", "MagicStorm", "Feeding", "BiomeTeleportation", "CrabBait", "ProfessionalFisher", "SharpBait"));
                } else if (subType.equals("level") || subType.equals("xp") || subType.equals("fishscale") || subType.equals("upgradepoints")) {
                    completions.addAll(Arrays.asList("1", "5", "10", "100"));
                }
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("take")) {
            if (sender.hasPermission("mrultimatefishing.take")) {
                completions.addAll(Arrays.asList("1", "5", "10", "100"));
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("give")) {
            if (sender.hasPermission("mrultimatefishing.give")) {
                String subType = args[1].toLowerCase();
                if (subType.equals("fish") || subType.equals("item") || subType.equals("enchant")) {
                    completions.addAll(Arrays.asList("1", "5", "10", "64"));
                } else if (subType.equals("level") || subType.equals("xp") || subType.equals("fishscale") || subType.equals("upgradepoints")) {
                    completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                }
            }
        } else if (args.length == 5 && args[0].equalsIgnoreCase("give") && (args[1].equalsIgnoreCase("fish") || args[1].equalsIgnoreCase("item") || args[1].equalsIgnoreCase("enchant"))) {
            if (sender.hasPermission("mrultimatefishing.give")) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("take") && sender.hasPermission("mrultimatefishing.take")) {
            completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
        }
        return completions;
    }
}

