/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.managers.BaseMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.EnchantManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class RecipeMenuManager
extends BaseMenuManager
implements Listener {
    private final EnchantManager enchantManager;
    private final Set<Inventory> activeRecipeMenuInventories = new HashSet<Inventory>();

    public void registerRecipeMenuInventory(Inventory inventory) {
        this.activeRecipeMenuInventories.add(inventory);
    }

    public void unregisterRecipeMenuInventory(Inventory inventory) {
        this.activeRecipeMenuInventories.remove(inventory);
    }

    public boolean isRecipeMenuRegistered(Inventory inventory) {
        return this.activeRecipeMenuInventories.contains(inventory);
    }

    public RecipeMenuManager(MrUltimateFishing plugin) {
        super(plugin);
        this.enchantManager = plugin.getEnchantManager();
    }

    public void openRecipeMenu(Player player) {
        this.openMenu(player);
    }

    public void openMenu(Player player) {
        ConfigurationSection itemsSection;
        ConfigurationSection menuConfig = this.plugin.getConfigManager().getRecipesConfig().getConfigurationSection("MrUltimateFishing.Recipes");
        if (menuConfig == null) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.menu-not-found")));
            return;
        }
        String baseTitle = menuConfig.getString("title", "Recipes");
        String colorSuffix = this.menuTitleSuffixes.getOrDefault("Recipes", "");
        String title = MrLibColors.colorize((String)(baseTitle + colorSuffix));
        int size = menuConfig.getInt("size", 54);
        Inventory inventory = this.createInventory(baseTitle, "Recipes", size);
        this.registerRecipeMenuInventory(inventory);
        ConfigurationSection decorationsSection = menuConfig.getConfigurationSection("decorations");
        if (decorationsSection != null) {
            this.addDecorations(inventory, decorationsSection);
        }
        if ((itemsSection = menuConfig.getConfigurationSection("items")) != null) {
            this.addItems(inventory, menuConfig);
        }
        this.addNavigationKeys(inventory, menuConfig, player, 0);
        this.addEnchantItems(inventory, menuConfig, player);
        this.addFishScalesBundle(inventory, menuConfig, player);
        player.openInventory(inventory);
    }

    private void addEnchantItems(Inventory inventory, ConfigurationSection menuConfig, Player player) {
        ConfigurationSection itemsSection = menuConfig.getConfigurationSection("items");
        if (itemsSection == null) {
            return;
        }
        ConfigurationSection enchantsConfig = itemsSection.getConfigurationSection("enchants");
        if (enchantsConfig == null) {
            return;
        }
        String slotsString = enchantsConfig.getString("slots", "");
        List<Integer> slots = this.parseSlots(slotsString);
        ArrayList<String> enchantNames = new ArrayList<String>(this.enchantManager.getEnchantNames());
        for (int i = 0; i < slots.size(); ++i) {
            int slot = slots.get(i);
            if (i < enchantNames.size()) {
                String enchantName = (String)enchantNames.get(i);
                ItemStack enchantItem = this.enchantManager.createRecipeMenuItem(enchantName);
                if (enchantItem == null) continue;
                ItemMeta meta = enchantItem.getItemMeta();
                if (meta != null) {
                    NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "recipe_enchant");
                    meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)enchantName);
                    enchantItem.setItemMeta(meta);
                }
                inventory.setItem(slot, enchantItem);
                continue;
            }
            inventory.setItem(slot, null);
        }
    }

    private void addFishScalesBundle(Inventory inventory, ConfigurationSection menuConfig, Player player) {
        List<Integer> slots;
        ConfigurationSection itemsSection = menuConfig.getConfigurationSection("items");
        if (itemsSection == null) {
            return;
        }
        ConfigurationSection bundleConfig = itemsSection.getConfigurationSection("withdraw-fish-scales");
        if (bundleConfig == null) {
            return;
        }
        String materialName = bundleConfig.getString("material", "PRISMARINE_CRYSTALS");
        Material material = Material.valueOf((String)materialName);
        ItemStack bundleItem = new ItemStack(material);
        ItemMeta meta = bundleItem.getItemMeta();
        if (meta != null) {
            String displayName = MrLibColors.colorize((String)bundleConfig.getString("display-name", "Bundle of Fish Scales"));
            meta.setDisplayName(displayName);
            ArrayList<String> lore = new ArrayList<String>();
            List configLore = bundleConfig.getStringList("lore");
            PlayerDataManager playerData = this.plugin.getPlayerDataManager();
            int fishScales = playerData.getFishScale(player);
            for (String line : configLore) {
                String coloredLine = MrLibColors.colorize((String)line.replace("[FishScales]", String.valueOf(fishScales)));
                lore.add(coloredLine);
            }
            meta.setLore(lore);
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "fish_scales_bundle");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"withdraw");
            bundleItem.setItemMeta(meta);
        }
        if (!(slots = this.parseSlots(bundleConfig.getString("slots", "5"))).isEmpty()) {
            inventory.setItem(slots.get(0).intValue(), bundleItem);
        }
    }

    private void addNavigationKeys(Inventory inventory, ConfigurationSection menuSection, Player player, int page) {
        ConfigurationSection keysSection = menuSection.getConfigurationSection("keys");
        if (keysSection == null) {
            return;
        }
        for (String key : keysSection.getKeys(false)) {
            ConfigurationSection keySection = keysSection.getConfigurationSection(key);
            if (keySection == null) continue;
            ItemStack keyItem = this.createNavigationKeyItem(keySection, key, player, page);
            String slotsStr = keySection.getString("slots", "");
            List<Integer> slots = this.parseSlots(slotsStr);
            for (int slot : slots) {
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, keyItem);
            }
        }
    }

    private ItemStack createNavigationKeyItem(ConfigurationSection keySection, String keyType, Player player, int page) {
        ArrayList<String> lore;
        String displayName;
        String type = keySection.getString("type", keyType);
        FileConfiguration messagesConfig = this.plugin.getMessageManager().getMessagesConfig();
        if (messagesConfig == null) {
            return this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
        }
        ConfigurationSection menuKeysSection = messagesConfig.getConfigurationSection("MrUltimateFishing.menu-keys");
        if (menuKeysSection == null) {
            return this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
        }
        ConfigurationSection itemSection = menuKeysSection.getConfigurationSection(type);
        if (itemSection == null) {
            return this.createMenuItem("ARROW", "Navigation", new ArrayList<String>(), false);
        }
        String material = itemSection.getString("material", "ARROW").toUpperCase();
        ItemStack finalItem = this.createMenuItem(material, displayName = itemSection.getString("display-name", ""), lore = new ArrayList<String>(itemSection.getStringList("lore")), false);
        ItemMeta meta = finalItem.getItemMeta();
        if (meta != null) {
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey navigationKey = new NamespacedKey((Plugin)this.plugin, "navigation");
            dataContainer.set(navigationKey, PersistentDataType.STRING, (Object)type);
            finalItem.setItemMeta(meta);
        }
        return finalItem;
    }

    public boolean handleInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.isRecipeMenuRegistered(event.getInventory())) {
            return false;
        }
        this.onInventoryClick(event);
        return true;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.isRecipeMenuRegistered(event.getInventory())) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (this.isNavigationItem(clickedItem)) {
            String navigationId;
            switch (navigationId = this.getNavigationIdentifier(clickedItem)) {
                case "back": {
                    player.closeInventory();
                    this.plugin.getMenuManager().openHeadMenu(player);
                    return;
                }
                case "next-page": 
                case "next": {
                    return;
                }
                case "previous-page": 
                case "prev": {
                    return;
                }
            }
        }
        NamespacedKey bundleKey = new NamespacedKey((Plugin)this.plugin, "fish_scales_bundle");
        if (meta.getPersistentDataContainer().has(bundleKey, PersistentDataType.STRING)) {
            this.handleFishScalesBundle(player);
            return;
        }
        NamespacedKey enchantKey = new NamespacedKey((Plugin)this.plugin, "recipe_enchant");
        if (meta.getPersistentDataContainer().has(enchantKey, PersistentDataType.STRING)) {
            String enchantName = (String)meta.getPersistentDataContainer().get(enchantKey, PersistentDataType.STRING);
            this.handleEnchantCrafting(player, enchantName);
            return;
        }
    }

    private void handleFishScalesBundle(Player player) {
        PlayerDataManager playerData = this.plugin.getPlayerDataManager();
        int currentScales = playerData.getFishScale(player);
        if (currentScales < 15000) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.insufficient-fish-scales-bundle")));
            return;
        }
        if (playerData.removeFishScale(player, 15000)) {
            ItemStack bundleItem = this.createFishScalesBundle();
            if (player.getInventory().firstEmpty() != -1) {
                player.getInventory().addItem(new ItemStack[]{bundleItem});
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.fish-scales-bundle-withdrawn")));
                player.closeInventory();
                this.openMenu(player);
            } else {
                playerData.addFishScale(player, 15000);
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.inventory-full")));
            }
        }
    }

    private void handleEnchantCrafting(Player player, String enchantName) {
        EnchantManager.EnchantData enchant = this.plugin.getEnchantManager().getEnchant(enchantName);
        if (enchant == null) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.invalid-enchant")));
            return;
        }
        PlayerDataManager playerData = this.plugin.getPlayerDataManager();
        int currentScales = playerData.getFishScale(player);
        if (currentScales < enchant.requiredFishScales) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.recipe-craft-insufficient-scales").replace("[required]", String.valueOf(enchant.requiredFishScales)).replace("[current]", String.valueOf(currentScales))));
            return;
        }
        int currentLevel = playerData.getLevel(player);
        if (currentLevel < enchant.requiredFishLevel) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.recipe-craft-insufficient-level").replace("[required]", String.valueOf(enchant.requiredFishLevel)).replace("[current]", String.valueOf(currentLevel))));
            return;
        }
        List<String> missingItems = this.getMissingItems(player, enchant.requiredItems);
        if (!missingItems.isEmpty()) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.recipe-craft-missing-items").replace("[missing_items]", String.join((CharSequence)", ", missingItems))));
            return;
        }
        this.performRecipeCrafting(player, enchant);
    }

    private ItemStack createFishScalesBundle() {
        ConfigurationSection itemConfig = this.plugin.getMessageManager().getConfigSection("Items.bundle-of-fish-scales");
        if (itemConfig == null) {
            return new ItemStack(Material.PRISMARINE_CRYSTALS);
        }
        String materialName = itemConfig.getString("material", "PRISMARINE_CRYSTALS");
        Material material = Material.valueOf((String)materialName);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = MrLibColors.colorize((String)itemConfig.getString("display-name", "Bundle of Fish Scales"));
            meta.setDisplayName(displayName);
            ArrayList<String> lore = new ArrayList<String>();
            List configLore = itemConfig.getStringList("lore");
            for (String line : configLore) {
                lore.add(MrLibColors.colorize((String)line));
            }
            meta.setLore(lore);
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "fish_scales_bundle_item");
            meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)15000);
            if (itemConfig.getBoolean("glowing", false)) {
                meta.addEnchant(Enchantment.LURE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (this.isRecipeMenuRegistered(event.getInventory())) {
            this.unregisterRecipeMenuInventory(event.getInventory());
        }
    }

    public void cleanupPlayerData(Player player) {
    }

    public boolean handleInventoryClose(InventoryCloseEvent event) {
        return true;
    }

    public boolean handleInventoryDrag(InventoryDragEvent event) {
        if (!this.isRecipeMenuRegistered(event.getInventory())) {
            return false;
        }
        event.setCancelled(true);
        return true;
    }

    private boolean isRecipeMenu(String inventoryTitle) {
        return false;
    }

    private boolean isCustomItem(String materialName) {
        return materialName.equals("DOLPHIN_TAIL") || materialName.equals("CRAB_CLAWS") || materialName.equals("CRAB_SHELL") || materialName.equals("SQUID_TENTACLE");
    }

    private List<String> getMissingItems(Player player, Map<String, Integer> requiredItems) {
        ArrayList<String> missingItems = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : requiredItems.entrySet()) {
            String materialName = entry.getKey();
            int requiredAmount = entry.getValue();
            if (this.isCustomItem(materialName)) {
                String customType = this.getCustomItemType(materialName);
                if (this.hasCustomItem(player, customType, requiredAmount)) continue;
                missingItems.add(requiredAmount + "x " + this.formatItemName(materialName));
                continue;
            }
            try {
                Material material = Material.valueOf((String)materialName);
                if (this.hasItem(player, material, requiredAmount)) continue;
                missingItems.add(requiredAmount + "x " + this.formatItemName(materialName));
            }
            catch (IllegalArgumentException e) {
                missingItems.add(requiredAmount + "x " + materialName);
            }
        }
        return missingItems;
    }

    private String getCustomItemType(String materialName) {
        switch (materialName) {
            case "DOLPHIN_TAIL": {
                return "dolphin-tail";
            }
            case "CRAB_CLAWS": {
                return "crab-claws";
            }
            case "CRAB_SHELL": {
                return "crab-shell";
            }
            case "SQUID_TENTACLE": {
                return "squid-tentacle";
            }
        }
        return materialName.toLowerCase().replace("_", "-");
    }

    private boolean hasCustomItem(Player player, String customType, int amount) {
        int count = 0;
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_drop_type");
        for (ItemStack item : player.getInventory().getContents()) {
            String type;
            ItemMeta meta;
            if (item == null || !item.hasItemMeta() || !(meta = item.getItemMeta()).getPersistentDataContainer().has(key, PersistentDataType.STRING) || !customType.equals(type = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING)) || (count += item.getAmount()) < amount) continue;
            return true;
        }
        return false;
    }

    private boolean hasItem(Player player, Material material, int amount) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material || !this.isVanillaItem(item) || (count += item.getAmount()) < amount) continue;
            return true;
        }
        return false;
    }

    private boolean isVanillaItem(ItemStack item) {
        if (!item.hasItemMeta()) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            return false;
        }
        if (meta.hasLore()) {
            return false;
        }
        if (!meta.getPersistentDataContainer().isEmpty()) {
            return false;
        }
        return !meta.hasEnchants();
    }

    private String formatItemName(String materialName) {
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
        }
        return formatted.toString();
    }

    private void performRecipeCrafting(Player player, EnchantManager.EnchantData enchant) {
        PlayerDataManager playerData = this.plugin.getPlayerDataManager();
        if (!playerData.removeFishScale(player, enchant.requiredFishScales)) {
            return;
        }
        this.removeItemsFromInventory(player, enchant.requiredItems);
        ItemStack enchantItem = this.plugin.getEnchantManager().createEnchantItem(enchant.name);
        if (enchantItem != null) {
            if (player.getInventory().firstEmpty() == -1) {
                player.getWorld().dropItem(player.getLocation(), enchantItem);
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.recipe-craft-success-dropped").replace("[enchant]", enchant.name)));
            } else {
                player.getInventory().addItem(new ItemStack[]{enchantItem});
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.recipe-craft-success-item").replace("[enchant]", enchant.name)));
            }
        } else {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("enchants.recipe-craft-success").replace("[enchant]", enchant.name)));
        }
        this.playCraftingEffects(player);
        this.plugin.getCommunityQuestIntegration().processEnchantCrafting(player, enchant.name);
        this.openMenu(player);
    }

    private void removeItemsFromInventory(Player player, Map<String, Integer> requiredItems) {
        for (Map.Entry<String, Integer> entry : requiredItems.entrySet()) {
            String materialName = entry.getKey();
            int amountToRemove = entry.getValue();
            if (this.isCustomItem(materialName)) {
                String customType = this.getCustomItemType(materialName);
                this.removeCustomItems(player, customType, amountToRemove);
                continue;
            }
            try {
                Material material = Material.valueOf((String)materialName);
                this.removeItems(player, material, amountToRemove);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material: " + materialName);
            }
        }
    }

    private void removeCustomItems(Player player, String customType, int amount) {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_drop_type");
        int remaining = amount;
        for (ItemStack item : player.getInventory().getContents()) {
            String type;
            ItemMeta meta;
            if (remaining <= 0) break;
            if (item == null || !item.hasItemMeta() || !(meta = item.getItemMeta()).getPersistentDataContainer().has(key, PersistentDataType.STRING) || !customType.equals(type = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING))) continue;
            int itemAmount = item.getAmount();
            if (itemAmount <= remaining) {
                player.getInventory().remove(item);
                remaining -= itemAmount;
                continue;
            }
            item.setAmount(itemAmount - remaining);
            remaining = 0;
        }
    }

    private void removeItems(Player player, Material material, int amount) {
        int remaining = amount;
        for (ItemStack item : player.getInventory().getContents()) {
            if (remaining <= 0) break;
            if (item == null || item.getType() != material || !this.isVanillaItem(item)) continue;
            int itemAmount = item.getAmount();
            if (itemAmount <= remaining) {
                player.getInventory().remove(item);
                remaining -= itemAmount;
                continue;
            }
            item.setAmount(itemAmount - remaining);
            remaining = 0;
        }
    }

    private void playCraftingEffects(Player player) {
        player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.ENCHANT, player.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5, 0.1);
    }
}

