/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TotemManager
implements Listener {
    private final MrUltimateFishing plugin;
    private final Map<Location, TotemData> activeTotems;
    private final File totemsDataFile;
    private FileConfiguration totemsConfig;

    public TotemManager(MrUltimateFishing plugin) {
        this.plugin = plugin;
        this.activeTotems = new HashMap<Location, TotemData>();
        this.totemsDataFile = new File(plugin.getDataFolder(), "totems.yml");
        this.loadTotemsData();
        this.loadActiveTotems();
        this.startHologramUpdateTask();
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItemInHand();
        if (!this.isTotemItem(item)) {
            return;
        }
        for (TotemData totemData : this.activeTotems.values()) {
            if (!totemData.getOwnerId().equals(player.getUniqueId())) continue;
            event.setCancelled(true);
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.max-totems-reached")));
            return;
        }
        Location newLocation = event.getBlock().getLocation();
        for (Location existingLocation : this.activeTotems.keySet()) {
            double distance;
            if (!newLocation.getWorld().equals((Object)existingLocation.getWorld()) || !((distance = newLocation.distance(existingLocation)) < 5.0)) continue;
            event.setCancelled(true);
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.too-close-to-other")));
            return;
        }
        TotemData totemData = this.getTotemDataFromItem(item, player, event.getBlock().getLocation());
        if (totemData != null) {
            this.activeTotems.put(event.getBlock().getLocation(), totemData);
            this.saveTotemsData();
            if (this.plugin.getConfig().getBoolean("MrUltimateFishing.Totem.EnableHologram", true)) {
                this.createTotemHologram(totemData);
            }
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.placed-successfully")));
            this.plugin.getLogger().info("Player " + player.getName() + " placed a totem at " + event.getBlock().getLocation().getBlockX() + ", " + event.getBlock().getLocation().getBlockY() + ", " + event.getBlock().getLocation().getBlockZ());
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        TotemData totemData = this.activeTotems.get(location);
        if (totemData == null) {
            return;
        }
        Player player = event.getPlayer();
        if (!totemData.getOwnerId().equals(player.getUniqueId()) && !player.hasPermission("mrultimatefishing.admin")) {
            event.setCancelled(true);
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.ownership.break-not-owner")));
            return;
        }
        event.setDropItems(false);
        block.setType(Material.AIR);
        ItemStack totemItem = this.createTotemItemWithData(totemData);
        block.getWorld().dropItemNaturally(location, totemItem);
        if (this.plugin.getHologramManager().isEnabled()) {
            this.plugin.getHologramManager().deleteHologram("totem_" + location.getBlockX() + "_" + location.getBlockY() + "_" + location.getBlockZ());
        }
        this.activeTotems.remove(location);
        this.saveTotemsData();
        this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.broken-successfully")));
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        Location location = event.getClickedBlock().getLocation();
        TotemData totemData = this.activeTotems.get(location);
        if (totemData == null) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getAction().toString().contains("RIGHT_CLICK")) {
            if (totemData.getOwnerId().equals(player.getUniqueId()) || player.hasPermission("mrultimatefishing.admin")) {
                this.openTotemMenu(player, totemData);
            } else {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.ownership.menu-not-owner")));
            }
            event.setCancelled(true);
        }
    }

    private boolean isTotemItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        NamespacedKey totemKey = new NamespacedKey((Plugin)this.plugin, "totem");
        return dataContainer.has(totemKey, PersistentDataType.STRING);
    }

    private TotemData getTotemDataFromItem(ItemStack item, Player player, Location location) {
        NamespacedKey experiencedFishermanKey;
        NamespacedKey randomDropsKey;
        NamespacedKey fishScaleAmbushKey;
        NamespacedKey mythicWaterKey;
        NamespacedKey upgradeSlotsKey;
        NamespacedKey cooldownKey;
        NamespacedKey activeTimeKey;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        TotemData totemData = new TotemData(player.getUniqueId(), player.getName(), location, this.plugin);
        NamespacedKey radiusKey = new NamespacedKey((Plugin)this.plugin, "totem_radius_level");
        if (dataContainer.has(radiusKey, PersistentDataType.INTEGER)) {
            totemData.setRadiusLevel((Integer)dataContainer.get(radiusKey, PersistentDataType.INTEGER));
        }
        if (dataContainer.has(activeTimeKey = new NamespacedKey((Plugin)this.plugin, "totem_active_time_level"), PersistentDataType.INTEGER)) {
            totemData.setActiveTimeLevel((Integer)dataContainer.get(activeTimeKey, PersistentDataType.INTEGER));
        }
        if (dataContainer.has(cooldownKey = new NamespacedKey((Plugin)this.plugin, "totem_cooldown_level"), PersistentDataType.INTEGER)) {
            totemData.setCooldownLevel((Integer)dataContainer.get(cooldownKey, PersistentDataType.INTEGER));
        }
        if (dataContainer.has(upgradeSlotsKey = new NamespacedKey((Plugin)this.plugin, "totem_upgrade_slots_level"), PersistentDataType.INTEGER)) {
            totemData.setUpgradeSlotsLevel((Integer)dataContainer.get(upgradeSlotsKey, PersistentDataType.INTEGER));
        }
        if (dataContainer.has(mythicWaterKey = new NamespacedKey((Plugin)this.plugin, "totem_mythic_water_active"), PersistentDataType.BYTE)) {
            totemData.setMythicWaterActive((Byte)dataContainer.get(mythicWaterKey, PersistentDataType.BYTE) == 1);
        }
        if (dataContainer.has(fishScaleAmbushKey = new NamespacedKey((Plugin)this.plugin, "totem_fish_scale_ambush_active"), PersistentDataType.BYTE)) {
            totemData.setFishScaleAmbushActive((Byte)dataContainer.get(fishScaleAmbushKey, PersistentDataType.BYTE) == 1);
        }
        if (dataContainer.has(randomDropsKey = new NamespacedKey((Plugin)this.plugin, "totem_random_drops_active"), PersistentDataType.BYTE)) {
            totemData.setRandomDropsActive((Byte)dataContainer.get(randomDropsKey, PersistentDataType.BYTE) == 1);
        }
        if (dataContainer.has(experiencedFishermanKey = new NamespacedKey((Plugin)this.plugin, "totem_experienced_fisherman_active"), PersistentDataType.BYTE)) {
            totemData.setExperiencedFishermanActive((Byte)dataContainer.get(experiencedFishermanKey, PersistentDataType.BYTE) == 1);
        }
        totemData.updateAvailableSlots();
        return totemData;
    }

    private ItemStack createTotemItemWithData(TotemData totemData) {
        ConfigurationSection totemConfig = this.plugin.getConfig().getConfigurationSection("MrUltimateFishing.Totem.Buy.Settings.Item");
        if (totemConfig == null) {
            return new ItemStack(Material.BEACON);
        }
        Material material = Material.valueOf((String)totemConfig.getString("Material", "BEACON"));
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = totemConfig.getString("Display-Name", "Fish Totem");
            meta.setDisplayName(MrLibColors.colorize((String)displayName));
            List lore = totemConfig.getStringList("Lore");
            ArrayList<String> processedLore = new ArrayList<String>();
            for (String line : lore) {
                line = MrLibColors.colorize((String)line);
                line = line.replace("[CurrentUpgradeSlots]", String.valueOf(totemData.getCurrentUpgradeSlots())).replace("[CurrentRadius]", String.valueOf(totemData.getCurrentRadius())).replace("[CurrentEnableTime]", String.valueOf(totemData.getCurrentActiveTime())).replace("[CurrentCooldownTime]", String.valueOf(totemData.getCurrentCooldown()));
                processedLore.add(line);
            }
            meta.setLore(processedLore);
            PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
            NamespacedKey totemKey = new NamespacedKey((Plugin)this.plugin, "totem");
            dataContainer.set(totemKey, PersistentDataType.STRING, (Object)"fish_totem");
            NamespacedKey radiusKey = new NamespacedKey((Plugin)this.plugin, "totem_radius_level");
            dataContainer.set(radiusKey, PersistentDataType.INTEGER, (Object)totemData.getRadiusLevel());
            NamespacedKey activeTimeKey = new NamespacedKey((Plugin)this.plugin, "totem_active_time_level");
            dataContainer.set(activeTimeKey, PersistentDataType.INTEGER, (Object)totemData.getActiveTimeLevel());
            NamespacedKey cooldownKey = new NamespacedKey((Plugin)this.plugin, "totem_cooldown_level");
            dataContainer.set(cooldownKey, PersistentDataType.INTEGER, (Object)totemData.getCooldownLevel());
            NamespacedKey upgradeSlotsKey = new NamespacedKey((Plugin)this.plugin, "totem_upgrade_slots_level");
            dataContainer.set(upgradeSlotsKey, PersistentDataType.INTEGER, (Object)totemData.getUpgradeSlotsLevel());
            NamespacedKey mythicWaterKey = new NamespacedKey((Plugin)this.plugin, "totem_mythic_water_active");
            dataContainer.set(mythicWaterKey, PersistentDataType.BYTE, (Object)((byte)(totemData.isMythicWaterActive() ? 1 : 0)));
            NamespacedKey fishScaleAmbushKey = new NamespacedKey((Plugin)this.plugin, "totem_fish_scale_ambush_active");
            dataContainer.set(fishScaleAmbushKey, PersistentDataType.BYTE, (Object)((byte)(totemData.isFishScaleAmbushActive() ? 1 : 0)));
            NamespacedKey randomDropsKey = new NamespacedKey((Plugin)this.plugin, "totem_random_drops_active");
            dataContainer.set(randomDropsKey, PersistentDataType.BYTE, (Object)((byte)(totemData.isRandomDropsActive() ? 1 : 0)));
            NamespacedKey experiencedFishermanKey = new NamespacedKey((Plugin)this.plugin, "totem_experienced_fisherman_active");
            dataContainer.set(experiencedFishermanKey, PersistentDataType.BYTE, (Object)((byte)(totemData.isExperiencedFishermanActive() ? 1 : 0)));
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack createFishTotemItem() {
        TotemData defaultTotemData = new TotemData(null, null, null, this.plugin);
        defaultTotemData.setRadiusLevel(0);
        defaultTotemData.setActiveTimeLevel(0);
        defaultTotemData.setCooldownLevel(0);
        defaultTotemData.setUpgradeSlotsLevel(0);
        defaultTotemData.setMythicWaterActive(false);
        defaultTotemData.setFishScaleAmbushActive(false);
        defaultTotemData.setRandomDropsActive(false);
        defaultTotemData.setExperiencedFishermanActive(false);
        return this.createTotemItemWithData(defaultTotemData);
    }

    private void openTotemMenu(Player player, TotemData totemData) {
        this.plugin.getMenuManager().getTotemMenuManager().openTotemMenu(player, totemData);
    }

    private void cleanNearbyTextDisplays(Location loc) {
        if (loc == null || loc.getWorld() == null) {
            return;
        }
        for (Entity entity : loc.getWorld().getNearbyEntities(loc, 3.0, 8.0, 3.0)) {
            if (!entity.getType().name().equals("TEXT_DISPLAY")) continue;
            entity.remove();
        }
    }

    private void createTotemHologram(TotemData totemData) {
        if (!this.plugin.getHologramManager().isEnabled()) {
            return;
        }
        this.cleanNearbyTextDisplays(totemData.getLocation());
        String hologramId = "totem_" + totemData.getLocation().getBlockX() + "_" + totemData.getLocation().getBlockY() + "_" + totemData.getLocation().getBlockZ();
        List hologramLines = this.plugin.getConfig().getStringList("MrUltimateFishing.Totem.HologramLines");
        ArrayList<String> processedLines = new ArrayList<String>();
        for (String line : hologramLines) {
            String state;
            line = MrLibColors.colorize((String)line);
            line = line.replace("[Owner]", totemData.getOwnerName()).replace("[Radius]", String.valueOf(totemData.getCurrentRadius()));
            if (totemData.isActive() && totemData.isCurrentlyActive()) {
                long remainingTime = totemData.getRemainingActiveTime();
                state = this.plugin.getMessageManager().getMessage("totem.states.active").replace("[time]", this.formatTime(remainingTime));
            } else if (!totemData.isActive() && totemData.getRemainingCooldown() > 0L) {
                long remainingCooldown = totemData.getRemainingCooldown();
                state = this.plugin.getMessageManager().getMessage("totem.states.cooldown").replace("[time]", this.formatTime(remainingCooldown));
            } else {
                state = !totemData.isActive() ? this.plugin.getMessageManager().getMessage("totem.states.ready") : this.plugin.getMessageManager().getMessage("totem.states.inactive");
            }
            line = line.replace("[State]", state);
            String mythicWaterStatus = totemData.isMythicWaterActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.inactive");
            String fishScaleAmbushStatus = totemData.isFishScaleAmbushActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.inactive");
            String randomDropsStatus = totemData.isRandomDropsActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.inactive");
            String experiencedFishermanStatus = totemData.isExperiencedFishermanActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.inactive");
            line = line.replace("[Bonus-1]", mythicWaterStatus).replace("[Bonus-2]", fishScaleAmbushStatus).replace("[Bonus-3]", randomDropsStatus).replace("[Bonus-4]", experiencedFishermanStatus);
            line = line.replace("(!message!)", "");
            processedLines.add(line);
        }
        double yLevel = this.plugin.getConfig().getDouble("MrUltimateFishing.Totem.YLevel", 1.0);
        if ("MrLibCore-TextDisplay".equals(this.plugin.getHologramManager().getActiveProviderName())) {
            yLevel += 2.0;
        }
        Location hologramLocation = totemData.getLocation().clone().add(0.5, yLevel, 0.5);
        this.plugin.getHologramManager().createHologram(hologramId, hologramLocation, processedLines);
    }

    private String formatTime(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes, secs);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, secs);
        }
        return String.format("%ds", secs);
    }

    private void startHologramUpdateTask() {
        long updateInterval = this.plugin.getConfig().getLong("MrUltimateFishing.UpdateInterval", 100L);
        this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (TotemData totemData : this.activeTotems.values()) {
                if (totemData.isActive() && !totemData.isCurrentlyActive()) {
                    totemData.setActive(false);
                    this.saveTotemsData();
                }
                this.updateTotemHologram(totemData);
                if (!totemData.isActive() || !totemData.isCurrentlyActive()) continue;
                this.showTotemRadiusParticles(totemData);
            }
        }, updateInterval, updateInterval);
    }

    public void shutdown() {
        this.saveTotemsData();
    }

    public void updateTotemHologram(TotemData totemData) {
        if (!this.plugin.getHologramManager().isEnabled()) {
            return;
        }
        String hologramId = "totem_" + totemData.getLocation().getBlockX() + "_" + totemData.getLocation().getBlockY() + "_" + totemData.getLocation().getBlockZ();
        List hologramLines = this.plugin.getConfig().getStringList("MrUltimateFishing.Totem.HologramLines");
        ArrayList<String> processedLines = new ArrayList<String>();
        for (String line : hologramLines) {
            String state;
            line = MrLibColors.colorize((String)line);
            line = line.replace("[Owner]", totemData.getOwnerName()).replace("[Radius]", String.valueOf(totemData.getCurrentRadius()));
            if (totemData.isActive() && totemData.isCurrentlyActive()) {
                long remainingTime = totemData.getRemainingActiveTime();
                state = this.plugin.getMessageManager().getMessage("totem.states.active").replace("[time]", this.formatTime(remainingTime));
            } else if (!totemData.isActive() && totemData.getRemainingCooldown() > 0L) {
                long remainingCooldown = totemData.getRemainingCooldown();
                state = this.plugin.getMessageManager().getMessage("totem.states.cooldown").replace("[time]", this.formatTime(remainingCooldown));
            } else {
                state = !totemData.isActive() ? this.plugin.getMessageManager().getMessage("totem.states.ready") : this.plugin.getMessageManager().getMessage("totem.states.inactive");
            }
            line = line.replace("[State]", state);
            String mythicWaterStatus = totemData.isMythicWaterActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.inactive");
            String fishScaleAmbushStatus = totemData.isFishScaleAmbushActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.inactive");
            String randomDropsStatus = totemData.isRandomDropsActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.inactive");
            String experiencedFishermanStatus = totemData.isExperiencedFishermanActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.inactive");
            line = line.replace("[Bonus-1]", mythicWaterStatus).replace("[Bonus-2]", fishScaleAmbushStatus).replace("[Bonus-3]", randomDropsStatus).replace("[Bonus-4]", experiencedFishermanStatus);
            processedLines.add(line);
        }
        this.plugin.getHologramManager().updateHologram(hologramId, processedLines);
    }

    public void rebuildAllTotemHolograms() {
        if (!this.plugin.getHologramManager().isEnabled()) {
            return;
        }
        try {
            for (TotemData totemData : this.activeTotems.values()) {
                this.cleanNearbyTextDisplays(totemData.getLocation());
            }
            for (TotemData totemData : this.activeTotems.values()) {
                String hologramId = "totem_" + totemData.getLocation().getBlockX() + "_" + totemData.getLocation().getBlockY() + "_" + totemData.getLocation().getBlockZ();
                List hologramLines = this.plugin.getConfig().getStringList("MrUltimateFishing.Totem.HologramLines");
                ArrayList<String> processedLines = new ArrayList<String>();
                for (String line : hologramLines) {
                    String state;
                    line = MrLibColors.colorize((String)line);
                    line = line.replace("[Owner]", totemData.getOwnerName()).replace("[Radius]", String.valueOf(totemData.getCurrentRadius()));
                    if (totemData.isActive() && totemData.isCurrentlyActive()) {
                        long remainingTime = totemData.getRemainingActiveTime();
                        state = this.plugin.getMessageManager().getMessage("totem.states.active").replace("[time]", this.formatTime(remainingTime));
                    } else if (!totemData.isActive() && totemData.getRemainingCooldown() > 0L) {
                        long remainingCooldown = totemData.getRemainingCooldown();
                        state = this.plugin.getMessageManager().getMessage("totem.states.cooldown").replace("[time]", this.formatTime(remainingCooldown));
                    } else {
                        state = !totemData.isActive() ? this.plugin.getMessageManager().getMessage("totem.states.ready") : this.plugin.getMessageManager().getMessage("totem.states.inactive");
                    }
                    line = line.replace("[State]", state);
                    String mythicWaterStatus = totemData.isMythicWaterActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.inactive");
                    String fishScaleAmbushStatus = totemData.isFishScaleAmbushActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.inactive");
                    String randomDropsStatus = totemData.isRandomDropsActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.inactive");
                    String experiencedFishermanStatus = totemData.isExperiencedFishermanActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.inactive");
                    line = line.replace("[Bonus-1]", mythicWaterStatus).replace("[Bonus-2]", fishScaleAmbushStatus).replace("[Bonus-3]", randomDropsStatus).replace("[Bonus-4]", experiencedFishermanStatus).replace("(!message!)", "");
                    processedLines.add(line);
                }
                if (this.plugin.getHologramManager().hologramExists(hologramId)) {
                    this.plugin.getHologramManager().updateHologram(hologramId, processedLines);
                    continue;
                }
                double yLevel = this.plugin.getConfig().getDouble("MrUltimateFishing.Totem.YLevel", 1.0);
                if ("MrLibCore-TextDisplay".equals(this.plugin.getHologramManager().getActiveProviderName())) {
                    yLevel += 2.0;
                }
                Location hologramLocation = totemData.getLocation().clone().add(0.5, yLevel, 0.5);
                this.plugin.getHologramManager().createHologram(hologramId, hologramLocation, processedLines);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to rebuild totem holograms: " + e.getMessage());
        }
    }

    private void showTotemRadiusParticles(TotemData totemData) {
        Location totemLocation = totemData.getLocation().clone().add(0.5, 0.1, 0.5);
        int radius = totemData.getCurrentRadius();
        double angleStep = 0.19634954084936207;
        for (double angle = 0.0; angle < Math.PI * 2; angle += angleStep) {
            double x = totemLocation.getX() + (double)radius * Math.cos(angle);
            double z = totemLocation.getZ() + (double)radius * Math.sin(angle);
            double y = totemLocation.getY();
            Location particleLocation = new Location(totemLocation.getWorld(), x, y, z);
            totemLocation.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, particleLocation, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void loadTotemsData() {
        if (!this.totemsDataFile.exists()) {
            try {
                this.totemsDataFile.createNewFile();
                this.totemsConfig = YamlConfiguration.loadConfiguration((File)this.totemsDataFile);
                this.saveTotemsData();
            }
            catch (IOException e) {
                return;
            }
        }
        this.totemsConfig = YamlConfiguration.loadConfiguration((File)this.totemsDataFile);
    }

    private void loadActiveTotems() {
        if (this.totemsConfig == null) {
            return;
        }
        ConfigurationSection totemsSection = this.totemsConfig.getConfigurationSection("totems");
        if (totemsSection == null) {
            return;
        }
        for (String key : totemsSection.getKeys(false)) {
            try {
                long savedLastDeactivated;
                Location location;
                ConfigurationSection totemSection = totemsSection.getConfigurationSection(key);
                if (totemSection == null) continue;
                String worldName = totemSection.getString("world");
                int x = totemSection.getInt("x");
                int y = totemSection.getInt("y");
                int z = totemSection.getInt("z");
                if (Bukkit.getWorld((String)worldName) == null || !(location = new Location(Bukkit.getWorld((String)worldName), (double)x, (double)y, (double)z)).getBlock().getType().toString().contains("BEACON")) continue;
                UUID ownerId = UUID.fromString(totemSection.getString("owner_id"));
                String ownerName = totemSection.getString("owner_name");
                TotemData totemData = new TotemData(ownerId, ownerName, location, this.plugin);
                totemData.setRadiusLevel(totemSection.getInt("radius_level", 0));
                totemData.setActiveTimeLevel(totemSection.getInt("active_time_level", 0));
                totemData.setCooldownLevel(totemSection.getInt("cooldown_level", 0));
                totemData.setUpgradeSlotsLevel(totemSection.getInt("upgrade_slots_level", 0));
                totemData.setMythicWaterActive(totemSection.getBoolean("mythic_water_active", false));
                totemData.setFishScaleAmbushActive(totemSection.getBoolean("fish_scale_ambush_active", false));
                totemData.setRandomDropsActive(totemSection.getBoolean("random_drops_active", false));
                totemData.setExperiencedFishermanActive(totemSection.getBoolean("experienced_fisherman_active", false));
                totemData.updateAvailableSlots();
                totemData.lastDeactivated = savedLastDeactivated = totemSection.getLong("last_deactivated", System.currentTimeMillis());
                totemData.setActive(false);
                this.activeTotems.put(location, totemData);
                if (!this.plugin.getConfig().getBoolean("MrUltimateFishing.Totem.EnableHologram", true)) continue;
                this.createTotemHologram(totemData);
            }
            catch (Exception exception) {}
        }
        this.plugin.getLogger().info("Loaded " + this.activeTotems.size() + " active totems");
    }

    public void saveTotemsData() {
        if (this.totemsConfig == null) {
            return;
        }
        this.totemsConfig.set("totems", null);
        int index = 0;
        for (Map.Entry<Location, TotemData> entry : this.activeTotems.entrySet()) {
            Location location = entry.getKey();
            TotemData totemData = entry.getValue();
            String path = "totems." + index;
            this.totemsConfig.set(path + ".world", (Object)location.getWorld().getName());
            this.totemsConfig.set(path + ".x", (Object)location.getBlockX());
            this.totemsConfig.set(path + ".y", (Object)location.getBlockY());
            this.totemsConfig.set(path + ".z", (Object)location.getBlockZ());
            this.totemsConfig.set(path + ".owner_id", (Object)totemData.getOwnerId().toString());
            this.totemsConfig.set(path + ".owner_name", (Object)totemData.getOwnerName());
            this.totemsConfig.set(path + ".radius_level", (Object)totemData.getRadiusLevel());
            this.totemsConfig.set(path + ".active_time_level", (Object)totemData.getActiveTimeLevel());
            this.totemsConfig.set(path + ".cooldown_level", (Object)totemData.getCooldownLevel());
            this.totemsConfig.set(path + ".upgrade_slots_level", (Object)totemData.getUpgradeSlotsLevel());
            this.totemsConfig.set(path + ".mythic_water_active", (Object)totemData.isMythicWaterActive());
            this.totemsConfig.set(path + ".fish_scale_ambush_active", (Object)totemData.isFishScaleAmbushActive());
            this.totemsConfig.set(path + ".random_drops_active", (Object)totemData.isRandomDropsActive());
            this.totemsConfig.set(path + ".experienced_fisherman_active", (Object)totemData.isExperiencedFishermanActive());
            this.totemsConfig.set(path + ".last_deactivated", (Object)totemData.getLastDeactivated());
            ++index;
        }
        try {
            this.totemsConfig.save(this.totemsDataFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public TotemData getTotemAt(Location location) {
        return this.activeTotems.get(location);
    }

    public Collection<TotemData> getAllTotems() {
        return this.activeTotems.values();
    }

    public TotemData getPlayerTotem(UUID playerId) {
        for (TotemData totemData : this.activeTotems.values()) {
            if (!totemData.getOwnerId().equals(playerId)) continue;
            return totemData;
        }
        return null;
    }

    public static class TotemData {
        private final UUID ownerId;
        private final String ownerName;
        private final Location location;
        private final MrUltimateFishing plugin;
        private int radiusLevel;
        private int activeTimeLevel;
        private int cooldownLevel;
        private int upgradeSlotsLevel;
        private boolean isActive;
        private long activatedAt;
        private long lastDeactivated;
        private boolean mythicWaterActive;
        private int availableUpgradeSlots;
        private boolean fishScaleAmbushActive;
        private boolean randomDropsActive;
        private boolean experiencedFishermanActive;

        public TotemData(UUID ownerId, String ownerName, Location location, MrUltimateFishing plugin) {
            this.ownerId = ownerId;
            this.ownerName = ownerName;
            this.location = location;
            this.plugin = plugin;
            this.radiusLevel = 0;
            this.activeTimeLevel = 0;
            this.cooldownLevel = 0;
            this.upgradeSlotsLevel = 0;
            this.isActive = false;
            this.activatedAt = 0L;
            this.lastDeactivated = System.currentTimeMillis();
            this.mythicWaterActive = false;
            this.availableUpgradeSlots = 0;
            this.fishScaleAmbushActive = false;
            this.randomDropsActive = false;
            this.experiencedFishermanActive = false;
        }

        public UUID getOwnerId() {
            return this.ownerId;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public Location getLocation() {
            return this.location;
        }

        public int getRadiusLevel() {
            return this.radiusLevel;
        }

        public int getActiveTimeLevel() {
            return this.activeTimeLevel;
        }

        public int getCooldownLevel() {
            return this.cooldownLevel;
        }

        public int getUpgradeSlotsLevel() {
            return this.upgradeSlotsLevel;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public long getActivatedAt() {
            return this.activatedAt;
        }

        public long getLastDeactivated() {
            return this.lastDeactivated;
        }

        public boolean isMythicWaterActive() {
            return this.mythicWaterActive;
        }

        public int getAvailableUpgradeSlots() {
            return this.availableUpgradeSlots;
        }

        public boolean isFishScaleAmbushActive() {
            return this.fishScaleAmbushActive;
        }

        public boolean isRandomDropsActive() {
            return this.randomDropsActive;
        }

        public boolean isExperiencedFishermanActive() {
            return this.experiencedFishermanActive;
        }

        public void setRadiusLevel(int level) {
            this.radiusLevel = level;
        }

        public void setActiveTimeLevel(int level) {
            this.activeTimeLevel = level;
        }

        public void setCooldownLevel(int level) {
            this.cooldownLevel = level;
        }

        public void setUpgradeSlotsLevel(int level) {
            this.upgradeSlotsLevel = level;
        }

        public void setActive(boolean active) {
            this.isActive = active;
            if (active) {
                Player player;
                this.activatedAt = System.currentTimeMillis();
                if (this.plugin instanceof MrUltimateFishing && (player = Bukkit.getPlayer((UUID)this.ownerId)) != null) {
                    this.plugin.getCommunityQuestIntegration().processTotemActivation(player);
                }
            } else {
                this.lastDeactivated = System.currentTimeMillis();
            }
        }

        public void setMythicWaterActive(boolean active) {
            this.mythicWaterActive = active;
        }

        public void setAvailableUpgradeSlots(int slots) {
            this.availableUpgradeSlots = slots;
        }

        public void setFishScaleAmbushActive(boolean active) {
            this.fishScaleAmbushActive = active;
        }

        public void setRandomDropsActive(boolean active) {
            this.randomDropsActive = active;
        }

        public void setExperiencedFishermanActive(boolean active) {
            this.experiencedFishermanActive = active;
        }

        public int getCurrentRadius() {
            ConfigurationSection config = this.plugin.getConfig().getConfigurationSection("MrUltimateFishing.Totem");
            if (config == null) {
                return 5;
            }
            int baseRadius = config.getInt("upgrades.Radius.FirstLevel", 5);
            int radiusPerLevel = config.getInt("upgrades.Radius.ForUpgradeGet", 3);
            return baseRadius + this.radiusLevel * radiusPerLevel;
        }

        public int getCurrentActiveTime() {
            ConfigurationSection config = this.plugin.getConfig().getConfigurationSection("MrUltimateFishing.Totem");
            if (config == null) {
                return 30;
            }
            int baseTime = config.getInt("upgrades.ActiveTime.FirstLevel", 30);
            int timePerLevel = config.getInt("upgrades.ActiveTime.ForUpgradeGet", 30);
            return baseTime + this.activeTimeLevel * timePerLevel;
        }

        public int getCurrentCooldown() {
            ConfigurationSection config = this.plugin.getConfig().getConfigurationSection("MrUltimateFishing.Totem");
            if (config == null) {
                return 1800;
            }
            int baseCooldown = config.getInt("upgrades.ReduceCooldown.FirstLevel", 1800);
            int reductionPerLevel = config.getInt("upgrades.ReduceCooldown.ForUpgradeGet", 80);
            return Math.max(60, baseCooldown - this.cooldownLevel * reductionPerLevel);
        }

        public int getCurrentUpgradeSlots() {
            ConfigurationSection config = this.plugin.getConfig().getConfigurationSection("MrUltimateFishing.Totem");
            if (config == null) {
                return 1;
            }
            int baseSlots = config.getInt("upgrades.UpgradeSlots.FirstLevel", 1);
            int slotsPerLevel = config.getInt("upgrades.UpgradeSlots.ForUpgradeGet", 1);
            return baseSlots + this.upgradeSlotsLevel * slotsPerLevel;
        }

        public int getUsedUpgradeSlots() {
            int usedSlots = 0;
            if (this.mythicWaterActive) {
                usedSlots += 5;
            }
            if (this.fishScaleAmbushActive) {
                usedSlots += 4;
            }
            if (this.randomDropsActive) {
                usedSlots += 2;
            }
            if (this.experiencedFishermanActive) {
                usedSlots += 3;
            }
            return usedSlots;
        }

        public void updateAvailableSlots() {
            this.availableUpgradeSlots = this.getCurrentUpgradeSlots() - this.getUsedUpgradeSlots();
        }

        public boolean isCurrentlyActive() {
            long activeTimeSeconds;
            if (!this.isActive) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            return currentTime - this.activatedAt < (activeTimeSeconds = (long)this.getCurrentActiveTime()) * 1000L;
        }

        public long getRemainingActiveTime() {
            if (!this.isActive) {
                return 0L;
            }
            long currentTime = System.currentTimeMillis();
            long activeTimeSeconds = this.getCurrentActiveTime();
            long elapsedTime = currentTime - this.activatedAt;
            long remainingTime = activeTimeSeconds * 1000L - elapsedTime;
            return Math.max(0L, remainingTime / 1000L);
        }

        public long getRemainingCooldown() {
            if (this.isActive) {
                return 0L;
            }
            long currentTime = System.currentTimeMillis();
            long cooldownSeconds = this.getCurrentCooldown();
            long timeSinceDeactivated = currentTime - this.lastDeactivated;
            long remainingTime = cooldownSeconds * 1000L - timeSinceDeactivated;
            return Math.max(0L, remainingTime / 1000L);
        }

        public boolean canActivate() {
            return !this.isActive && this.getRemainingCooldown() == 0L;
        }
    }
}

