/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimatefishing.MrUltimateFishing;
import eu.mrneznamy.mrultimatefishing.PlayerDataManager;
import eu.mrneznamy.mrultimatefishing.managers.BaseMenuManager;
import eu.mrneznamy.mrultimatefishing.managers.TotemManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TotemMenuManager
extends BaseMenuManager {
    private final TotemManager totemManager;
    private final Map<UUID, TotemManager.TotemData> openMenus;
    private final Set<Inventory> activeTotemInventories = new HashSet<Inventory>();

    public void registerTotemMenuInventory(Inventory inventory) {
        this.activeTotemInventories.add(inventory);
    }

    public void unregisterTotemMenuInventory(Inventory inventory) {
        this.activeTotemInventories.remove(inventory);
    }

    public boolean isTotemMenuRegistered(Inventory inventory) {
        return this.activeTotemInventories.contains(inventory);
    }

    public TotemMenuManager(MrUltimateFishing plugin, TotemManager totemManager) {
        super(plugin);
        this.totemManager = totemManager;
        this.openMenus = new HashMap<UUID, TotemManager.TotemData>();
    }

    public void openTotemMenu(Player player, TotemManager.TotemData totemData) {
        File totemFile = new File(this.plugin.getDataFolder(), "Menus/totem.yml");
        if (!totemFile.exists()) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.menu-config-not-found")));
            return;
        }
        ConfigurationSection totemConfig = this.plugin.getMenuConfig("totem");
        if (totemConfig == null) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.menu-config-load-failed")));
            return;
        }
        String title = MrLibColors.colorize((String)totemConfig.getString("title", "Fish Totem"));
        int size = totemConfig.getInt("size", 54);
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        this.registerTotemMenuInventory(inventory);
        this.openMenus.put(player.getUniqueId(), totemData);
        this.addDecorations(inventory, totemConfig.getConfigurationSection("decorations"));
        this.addUpgradeItems(inventory, totemConfig, totemData, player);
        player.openInventory(inventory);
    }

    private void addUpgradeItems(Inventory inventory, ConfigurationSection totemConfig, TotemManager.TotemData totemData, Player player) {
        ConfigurationSection bonusesSection;
        ConfigurationSection upgradesSection = totemConfig.getConfigurationSection("upgrades");
        if (upgradesSection == null) {
            return;
        }
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        this.addRadiusUpgrade(inventory, upgradesSection.getConfigurationSection("Radius"), totemData, playerData);
        this.addActiveTimeUpgrade(inventory, upgradesSection.getConfigurationSection("ActiveTime"), totemData, playerData);
        this.addCooldownUpgrade(inventory, upgradesSection.getConfigurationSection("ReduceCooldown"), totemData, playerData);
        this.addUpgradeSlotsUpgrade(inventory, upgradesSection.getConfigurationSection("UpgradeSlots"), totemData, playerData);
        ConfigurationSection activationSection = totemConfig.getConfigurationSection("activation");
        if (activationSection != null) {
            this.addActivationItem(inventory, activationSection.getConfigurationSection("ActivateTotem"), totemData);
        }
        if ((bonusesSection = totemConfig.getConfigurationSection("bonuses")) != null) {
            this.addMythicWaterBonus(inventory, bonusesSection.getConfigurationSection("MythicWater"), totemData);
            this.addFishScaleAmbushBonus(inventory, bonusesSection.getConfigurationSection("FishScaleAmbush"), totemData);
            this.addRandomDropsBonus(inventory, bonusesSection.getConfigurationSection("RandomDrops"), totemData);
            this.addExperiencedFishermanBonus(inventory, bonusesSection.getConfigurationSection("ExperiencedFisherman"), totemData);
        }
        this.addInformationItem(inventory, totemConfig.getConfigurationSection("decorations.3"), totemData);
    }

    private void addRadiusUpgrade(Inventory inventory, ConfigurationSection config, TotemManager.TotemData totemData, PlayerDataManager.PlayerData playerData) {
        if (config == null) {
            return;
        }
        ConfigurationSection itemConfig = config.getConfigurationSection("Item");
        if (itemConfig == null) {
            return;
        }
        ItemStack item = this.createMenuItem(itemConfig);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List<Integer> slots;
            List lore = meta.getLore();
            if (lore != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                int currentLevel = totemData.getRadiusLevel();
                int maxLevel = config.getInt("MaxUpgradeLevel", 10);
                int price = config.getInt("PriceforUpgrade", 10000);
                int currentBonus = totemData.getCurrentRadius();
                for (String line : lore) {
                    line = line.replace("[Price]", String.valueOf(price)).replace("[CurrentLevel]", String.valueOf(currentLevel)).replace("[MaxLevels]", String.valueOf(maxLevel)).replace("[CurrentBonus]", currentBonus + " blocks");
                    newLore.add(line);
                }
                meta.setLore(newLore);
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey upgradeKey = new NamespacedKey((Plugin)this.plugin, "totem_upgrade");
                dataContainer.set(upgradeKey, PersistentDataType.STRING, (Object)"radius");
                item.setItemMeta(meta);
            }
            if (!(slots = this.parseSlots(itemConfig.getString("slots", ""))).isEmpty()) {
                inventory.setItem(slots.get(0).intValue(), item);
            }
        }
    }

    private void addActiveTimeUpgrade(Inventory inventory, ConfigurationSection config, TotemManager.TotemData totemData, PlayerDataManager.PlayerData playerData) {
        if (config == null) {
            return;
        }
        ConfigurationSection itemConfig = config.getConfigurationSection("Item");
        if (itemConfig == null) {
            return;
        }
        ItemStack item = this.createMenuItem(itemConfig);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List<Integer> slots;
            List lore = meta.getLore();
            if (lore != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                int currentLevel = totemData.getActiveTimeLevel();
                int maxLevel = config.getInt("MaxUpgradeLevel", 25);
                int price = config.getInt("PriceforUpgrade", 20000);
                int currentBonus = totemData.getCurrentActiveTime();
                for (String line : lore) {
                    line = line.replace("[Price]", String.valueOf(price)).replace("[CurrentLevel]", String.valueOf(currentLevel)).replace("[MaxLevels]", String.valueOf(maxLevel)).replace("[CurrentBonus]", String.valueOf(currentBonus));
                    newLore.add(line);
                }
                meta.setLore(newLore);
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey upgradeKey = new NamespacedKey((Plugin)this.plugin, "totem_upgrade");
                dataContainer.set(upgradeKey, PersistentDataType.STRING, (Object)"active_time");
                item.setItemMeta(meta);
            }
            if (!(slots = this.parseSlots(itemConfig.getString("slots", ""))).isEmpty()) {
                inventory.setItem(slots.get(0).intValue(), item);
            }
        }
    }

    private void addCooldownUpgrade(Inventory inventory, ConfigurationSection config, TotemManager.TotemData totemData, PlayerDataManager.PlayerData playerData) {
        if (config == null) {
            return;
        }
        ConfigurationSection itemConfig = config.getConfigurationSection("Item");
        if (itemConfig == null) {
            return;
        }
        ItemStack item = this.createMenuItem(itemConfig);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List<Integer> slots;
            List lore = meta.getLore();
            if (lore != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                int currentLevel = totemData.getCooldownLevel();
                int maxLevel = config.getInt("MaxUpgradeLevel", 15);
                int price = config.getInt("PriceforUpgrade", 50000);
                int currentBonus = config.getInt("ForUpgradeGet", 80) * currentLevel;
                for (String line : lore) {
                    line = line.replace("[Price]", String.valueOf(price)).replace("[CurrentLevel]", String.valueOf(currentLevel)).replace("[MaxLevels]", String.valueOf(maxLevel)).replace("[CurrentBonus]", String.valueOf(currentBonus));
                    newLore.add(line);
                }
                meta.setLore(newLore);
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey upgradeKey = new NamespacedKey((Plugin)this.plugin, "totem_upgrade");
                dataContainer.set(upgradeKey, PersistentDataType.STRING, (Object)"cooldown");
                item.setItemMeta(meta);
            }
            if (!(slots = this.parseSlots(itemConfig.getString("slots", ""))).isEmpty()) {
                inventory.setItem(slots.get(0).intValue(), item);
            }
        }
    }

    private void addUpgradeSlotsUpgrade(Inventory inventory, ConfigurationSection config, TotemManager.TotemData totemData, PlayerDataManager.PlayerData playerData) {
        if (config == null) {
            return;
        }
        ConfigurationSection itemConfig = config.getConfigurationSection("Item");
        if (itemConfig == null) {
            return;
        }
        ItemStack item = this.createMenuItem(itemConfig);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List<Integer> slots;
            List lore = meta.getLore();
            if (lore != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                int currentLevel = totemData.getUpgradeSlotsLevel();
                int maxLevel = config.getInt("MaxUpgradeLevel", 15);
                int price = config.getInt("PriceforUpgrade", 15000);
                int currentBonus = totemData.getCurrentUpgradeSlots();
                for (String line : lore) {
                    line = line.replace("[Price]", String.valueOf(price)).replace("[CurrentLevel]", String.valueOf(currentLevel)).replace("[MaxLevels]", String.valueOf(maxLevel)).replace("[CurrentBonus]", String.valueOf(currentBonus));
                    newLore.add(line);
                }
                meta.setLore(newLore);
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey upgradeKey = new NamespacedKey((Plugin)this.plugin, "totem_upgrade");
                dataContainer.set(upgradeKey, PersistentDataType.STRING, (Object)"upgrade_slots");
                item.setItemMeta(meta);
            }
            if (!(slots = this.parseSlots(itemConfig.getString("slots", ""))).isEmpty()) {
                inventory.setItem(slots.get(0).intValue(), item);
            }
        }
    }

    private void addInformationItem(Inventory inventory, ConfigurationSection config, TotemManager.TotemData totemData) {
        if (config == null) {
            return;
        }
        ItemStack item = this.createMenuItem(config);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List<Integer> slots;
            List lore = meta.getLore();
            if (lore != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                for (String line : lore) {
                    line = line.replace("[UpgradeSlots]", String.valueOf(totemData.getCurrentUpgradeSlots())).replace("[MaxUpgradeSlots]", "\u221e").replace("[AvailableUpgradeSlots]", String.valueOf(totemData.getAvailableUpgradeSlots())).replace("[UsedUpgradeSlots]", String.valueOf(totemData.getUsedUpgradeSlots()));
                    newLore.add(line);
                }
                meta.setLore(newLore);
                item.setItemMeta(meta);
            }
            if (!(slots = this.parseSlots(config.getString("slots", ""))).isEmpty()) {
                inventory.setItem(slots.get(0).intValue(), item);
            }
        }
    }

    private void addActivationItem(Inventory inventory, ConfigurationSection config, TotemManager.TotemData totemData) {
        if (config == null) {
            return;
        }
        ConfigurationSection itemConfig = config.getConfigurationSection("Item");
        if (itemConfig == null) {
            return;
        }
        ItemStack item = this.createMenuItem(itemConfig);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List<Integer> slots;
            List lore = meta.getLore();
            if (lore != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                for (String line : lore) {
                    Object status;
                    if (totemData.isActive() && totemData.isCurrentlyActive()) {
                        long remainingTime = totemData.getRemainingActiveTime();
                        status = "&aActive (&e" + this.formatTime(remainingTime) + "&a remaining)";
                    } else if (!totemData.isActive() && totemData.getRemainingCooldown() > 0L) {
                        long remainingCooldown = totemData.getRemainingCooldown();
                        status = "&cCooldown (&e" + this.formatTime(remainingCooldown) + "&c remaining)";
                    } else {
                        status = !totemData.isActive() ? "&7Ready to activate" : "&cInactive";
                    }
                    line = line.replace("[TotemStatus]", (CharSequence)status);
                    newLore.add(line);
                }
                meta.setLore(newLore);
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey activationKey = new NamespacedKey((Plugin)this.plugin, "totem_activation");
                dataContainer.set(activationKey, PersistentDataType.STRING, (Object)"activate_totem");
                item.setItemMeta(meta);
            }
            if (!(slots = this.parseSlots(itemConfig.getString("slots", ""))).isEmpty()) {
                inventory.setItem(slots.get(0).intValue(), item);
            }
        }
    }

    private void handleActivationClick(Player player, TotemManager.TotemData totemData) {
        if (!totemData.getOwnerId().equals(player.getUniqueId())) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.only-owner-upgrade")));
            return;
        }
        if (totemData.isActive()) {
            if (totemData.isCurrentlyActive()) {
                long remainingTime = totemData.getRemainingActiveTime();
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.cannot-deactivate-while-active").replace("[time]", this.formatTime(remainingTime))));
                return;
            }
            totemData.setActive(false);
        } else {
            if (!totemData.canActivate()) {
                long remainingCooldown = totemData.getRemainingCooldown();
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.activation-on-cooldown").replace("[time]", this.formatTime(remainingCooldown))));
                return;
            }
            totemData.setActive(true);
        }
        this.totemManager.saveTotemsData();
        this.totemManager.updateTotemHologram(totemData);
        String messageKey = totemData.isActive() ? "totem.totem-activated" : "totem.totem-deactivated";
        this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage(messageKey)));
        player.closeInventory();
        this.openTotemMenu(player, totemData);
    }

    private String formatTime(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes, secs);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, secs);
        }
        return String.format("%ds", secs);
    }

    private void addMythicWaterBonus(Inventory inventory, ConfigurationSection config, TotemManager.TotemData totemData) {
        if (config == null) {
            return;
        }
        ConfigurationSection itemConfig = config.getConfigurationSection("Item");
        if (itemConfig == null) {
            return;
        }
        ItemStack item = this.createMenuItem(itemConfig);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List<Integer> slots;
            List lore = meta.getLore();
            if (lore != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                String bonusStatus = totemData.isMythicWaterActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.inactive");
                for (String line : lore) {
                    line = line.replace("[BonusStatus]", bonusStatus);
                    line = MrLibColors.colorize((String)MrLibColors.colorize((String)line));
                    newLore.add(line);
                }
                meta.setLore(newLore);
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey bonusKey = new NamespacedKey((Plugin)this.plugin, "totem_bonus");
                dataContainer.set(bonusKey, PersistentDataType.STRING, (Object)"mythic_water");
                item.setItemMeta(meta);
            }
            if (!(slots = this.parseSlots(itemConfig.getString("slots", ""))).isEmpty()) {
                inventory.setItem(slots.get(0).intValue(), item);
            }
        }
    }

    private void addFishScaleAmbushBonus(Inventory inventory, ConfigurationSection config, TotemManager.TotemData totemData) {
        if (config == null) {
            return;
        }
        ConfigurationSection itemConfig = config.getConfigurationSection("Item");
        if (itemConfig == null) {
            return;
        }
        ItemStack item = this.createMenuItem(itemConfig);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List<Integer> slots;
            List lore = meta.getLore();
            if (lore != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                String bonusStatus = totemData.isFishScaleAmbushActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.inactive");
                for (String line : lore) {
                    line = line.replace("[BonusStatus]", bonusStatus);
                    line = MrLibColors.colorize((String)MrLibColors.colorize((String)line));
                    newLore.add(line);
                }
                meta.setLore(newLore);
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey bonusKey = new NamespacedKey((Plugin)this.plugin, "totem_bonus");
                dataContainer.set(bonusKey, PersistentDataType.STRING, (Object)"fish_scale_ambush");
                item.setItemMeta(meta);
            }
            if (!(slots = this.parseSlots(itemConfig.getString("slots", ""))).isEmpty()) {
                inventory.setItem(slots.get(0).intValue(), item);
            }
        }
    }

    private void addRandomDropsBonus(Inventory inventory, ConfigurationSection config, TotemManager.TotemData totemData) {
        if (config == null) {
            return;
        }
        ConfigurationSection itemConfig = config.getConfigurationSection("Item");
        if (itemConfig == null) {
            return;
        }
        ItemStack item = this.createMenuItem(itemConfig);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List<Integer> slots;
            List lore = meta.getLore();
            if (lore != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                String bonusStatus = totemData.isRandomDropsActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.inactive");
                for (String line : lore) {
                    line = line.replace("[BonusStatus]", bonusStatus);
                    line = MrLibColors.colorize((String)MrLibColors.colorize((String)line));
                    newLore.add(line);
                }
                meta.setLore(newLore);
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey bonusKey = new NamespacedKey((Plugin)this.plugin, "totem_bonus");
                dataContainer.set(bonusKey, PersistentDataType.STRING, (Object)"random_drops");
                item.setItemMeta(meta);
            }
            if (!(slots = this.parseSlots(itemConfig.getString("slots", ""))).isEmpty()) {
                inventory.setItem(slots.get(0).intValue(), item);
            }
        }
    }

    private void addExperiencedFishermanBonus(Inventory inventory, ConfigurationSection config, TotemManager.TotemData totemData) {
        if (config == null) {
            return;
        }
        ConfigurationSection itemConfig = config.getConfigurationSection("Item");
        if (itemConfig == null) {
            return;
        }
        ItemStack item = this.createMenuItem(itemConfig);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List<Integer> slots;
            List lore = meta.getLore();
            if (lore != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                String bonusStatus = totemData.isExperiencedFishermanActive() ? this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.active") : this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.inactive");
                for (String line : lore) {
                    line = line.replace("[BonusStatus]", bonusStatus);
                    line = MrLibColors.colorize((String)MrLibColors.colorize((String)line));
                    newLore.add(line);
                }
                meta.setLore(newLore);
                PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
                NamespacedKey bonusKey = new NamespacedKey((Plugin)this.plugin, "totem_bonus");
                dataContainer.set(bonusKey, PersistentDataType.STRING, (Object)"experienced_fisherman");
                item.setItemMeta(meta);
            }
            if (!(slots = this.parseSlots(itemConfig.getString("slots", ""))).isEmpty()) {
                inventory.setItem(slots.get(0).intValue(), item);
            }
        }
    }

    public boolean handleInventoryClick(InventoryClickEvent event) {
        NamespacedKey upgradeKey;
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.isTotemMenuRegistered(event.getInventory())) {
            return false;
        }
        event.setCancelled(true);
        TotemManager.TotemData totemData = this.openMenus.get(player.getUniqueId());
        if (totemData == null) {
            return true;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return true;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return true;
        }
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        if (dataContainer.has(upgradeKey = new NamespacedKey((Plugin)this.plugin, "totem_upgrade"), PersistentDataType.STRING)) {
            String upgradeType = (String)dataContainer.get(upgradeKey, PersistentDataType.STRING);
            this.handleUpgradeClick(player, totemData, upgradeType);
            return true;
        }
        NamespacedKey activationKey = new NamespacedKey((Plugin)this.plugin, "totem_activation");
        if (dataContainer.has(activationKey, PersistentDataType.STRING)) {
            this.handleActivationClick(player, totemData);
            return true;
        }
        NamespacedKey bonusKey = new NamespacedKey((Plugin)this.plugin, "totem_bonus");
        if (dataContainer.has(bonusKey, PersistentDataType.STRING)) {
            String bonusType = (String)dataContainer.get(bonusKey, PersistentDataType.STRING);
            this.handleBonusClick(player, totemData, bonusType, event.getClick());
            return true;
        }
        return true;
    }

    private void handleUpgradeClick(Player player, TotemManager.TotemData totemData, String upgradeType) {
        if (!totemData.getOwnerId().equals(player.getUniqueId())) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.only-owner-upgrade")));
            return;
        }
        ConfigurationSection upgradeConfig = this.getUpgradeConfig(upgradeType);
        if (upgradeConfig == null) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.menu-config-not-found")));
            return;
        }
        PlayerDataManager.PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
        int currentLevel = this.getCurrentUpgradeLevel(totemData, upgradeType);
        int maxLevel = upgradeConfig.getInt("MaxUpgradeLevel", Integer.MAX_VALUE);
        if (maxLevel != Integer.MAX_VALUE && currentLevel >= maxLevel) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.upgrade-max-level")));
            return;
        }
        int price = upgradeConfig.getInt("PriceforUpgrade", 10000);
        if (playerData.getFishScale() < price) {
            String message = this.plugin.getMessageManager().getMessage("totem.upgrade-insufficient-scales").replace("[scales]", String.valueOf(price));
            this.plugin.sendMessage(player, MrLibColors.colorize((String)message));
            return;
        }
        if ("upgrade_slots".equals(upgradeType)) {
            if (!this.checkUpgradeSlotsRequirements(player, upgradeConfig)) {
                return;
            }
            this.removeUpgradeSlotsRequirements(player, upgradeConfig);
        }
        if (!this.plugin.getPlayerDataManager().removeFishScale(player, price)) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.upgrade-scales-removal-failed")));
            return;
        }
        this.applyUpgrade(totemData, upgradeType);
        this.totemManager.saveTotemsData();
        this.totemManager.updateTotemHologram(totemData);
        this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.upgrade-purchased")));
        player.closeInventory();
        this.openTotemMenu(player, totemData);
    }

    private ConfigurationSection getUpgradeConfig(String upgradeType) {
        String configPath;
        ConfigurationSection totemConfig = this.plugin.getMenuConfig("totem");
        if (totemConfig == null) {
            return null;
        }
        ConfigurationSection upgradesSection = totemConfig.getConfigurationSection("upgrades");
        if (upgradesSection == null) {
            return null;
        }
        switch (upgradeType) {
            case "radius": {
                configPath = "Radius";
                break;
            }
            case "active_time": {
                configPath = "ActiveTime";
                break;
            }
            case "cooldown": {
                configPath = "ReduceCooldown";
                break;
            }
            case "upgrade_slots": {
                configPath = "UpgradeSlots";
                break;
            }
            default: {
                return null;
            }
        }
        return upgradesSection.getConfigurationSection(configPath);
    }

    private int getCurrentUpgradeLevel(TotemManager.TotemData totemData, String upgradeType) {
        switch (upgradeType) {
            case "radius": {
                return totemData.getRadiusLevel();
            }
            case "active_time": {
                return totemData.getActiveTimeLevel();
            }
            case "cooldown": {
                return totemData.getCooldownLevel();
            }
            case "upgrade_slots": {
                return totemData.getUpgradeSlotsLevel();
            }
        }
        return 0;
    }

    private void applyUpgrade(TotemManager.TotemData totemData, String upgradeType) {
        switch (upgradeType) {
            case "radius": {
                totemData.setRadiusLevel(totemData.getRadiusLevel() + 1);
                break;
            }
            case "active_time": {
                totemData.setActiveTimeLevel(totemData.getActiveTimeLevel() + 1);
                break;
            }
            case "cooldown": {
                totemData.setCooldownLevel(totemData.getCooldownLevel() + 1);
                break;
            }
            case "upgrade_slots": {
                totemData.setUpgradeSlotsLevel(totemData.getUpgradeSlotsLevel() + 1);
                totemData.updateAvailableSlots();
            }
        }
    }

    private void handleBonusClick(Player player, TotemManager.TotemData totemData, String bonusType, ClickType clickType) {
        if (!totemData.getOwnerId().equals(player.getUniqueId())) {
            this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem.only-owner-upgrade")));
            return;
        }
        if ("mythic_water".equals(bonusType)) {
            this.handleMythicWaterClick(player, totemData, clickType);
        } else if ("fish_scale_ambush".equals(bonusType)) {
            this.handleFishScaleAmbushClick(player, totemData, clickType);
        } else if ("random_drops".equals(bonusType)) {
            this.handleRandomDropsClick(player, totemData, clickType);
        } else if ("experienced_fisherman".equals(bonusType)) {
            this.handleExperiencedFishermanClick(player, totemData, clickType);
        }
        this.totemManager.saveTotemsData();
        this.totemManager.updateTotemHologram(totemData);
        player.closeInventory();
        this.openTotemMenu(player, totemData);
    }

    private void handleMythicWaterClick(Player player, TotemManager.TotemData totemData, ClickType clickType) {
        if (clickType == ClickType.LEFT) {
            if (!totemData.isMythicWaterActive()) {
                if (totemData.getAvailableUpgradeSlots() >= 5) {
                    totemData.setMythicWaterActive(true);
                    totemData.updateAvailableSlots();
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.activated")));
                } else {
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.insufficient-slots")));
                }
            } else {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.already-active")));
            }
        } else if (clickType == ClickType.RIGHT) {
            if (totemData.isMythicWaterActive()) {
                totemData.setMythicWaterActive(false);
                totemData.updateAvailableSlots();
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.deactivated")));
            } else {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.mythic-water.already-inactive")));
            }
        }
    }

    private void handleFishScaleAmbushClick(Player player, TotemManager.TotemData totemData, ClickType clickType) {
        if (clickType == ClickType.LEFT) {
            if (!totemData.isFishScaleAmbushActive()) {
                if (totemData.getAvailableUpgradeSlots() >= 4) {
                    totemData.setFishScaleAmbushActive(true);
                    totemData.updateAvailableSlots();
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.activated")));
                } else {
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.insufficient-slots")));
                }
            } else {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.already-active")));
            }
        } else if (clickType == ClickType.RIGHT) {
            if (totemData.isFishScaleAmbushActive()) {
                totemData.setFishScaleAmbushActive(false);
                totemData.updateAvailableSlots();
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.deactivated")));
            } else {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.fish-scale-ambush.already-inactive")));
            }
        }
    }

    private void handleRandomDropsClick(Player player, TotemManager.TotemData totemData, ClickType clickType) {
        if (clickType == ClickType.LEFT) {
            if (!totemData.isRandomDropsActive()) {
                if (totemData.getAvailableUpgradeSlots() >= 2) {
                    totemData.setRandomDropsActive(true);
                    totemData.updateAvailableSlots();
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.activated")));
                } else {
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.insufficient-slots")));
                }
            } else {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.already-active")));
            }
        } else if (clickType == ClickType.RIGHT) {
            if (totemData.isRandomDropsActive()) {
                totemData.setRandomDropsActive(false);
                totemData.updateAvailableSlots();
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.deactivated")));
            } else {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.random-drops.already-inactive")));
            }
        }
    }

    private void handleExperiencedFishermanClick(Player player, TotemManager.TotemData totemData, ClickType clickType) {
        if (clickType == ClickType.LEFT) {
            if (!totemData.isExperiencedFishermanActive()) {
                if (totemData.getAvailableUpgradeSlots() >= 3) {
                    totemData.setExperiencedFishermanActive(true);
                    totemData.updateAvailableSlots();
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.activated")));
                } else {
                    this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.insufficient-slots")));
                }
            } else {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.already-active")));
            }
        } else if (clickType == ClickType.RIGHT) {
            if (totemData.isExperiencedFishermanActive()) {
                totemData.setExperiencedFishermanActive(false);
                totemData.updateAvailableSlots();
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.deactivated")));
            } else {
                this.plugin.sendMessage(player, MrLibColors.colorize((String)this.plugin.getMessageManager().getMessage("totem-bonuses.experienced-fisherman.already-inactive")));
            }
        }
    }

    private boolean checkUpgradeSlotsRequirements(Player player, ConfigurationSection config) {
        List requiredItems = config.getStringList("Items");
        for (String itemStr : requiredItems) {
            String[] parts = itemStr.split(":");
            if (parts.length != 2) continue;
            String itemName = parts[0];
            int requiredAmount = Integer.parseInt(parts[1]);
            if (this.countCustomItems(player, itemName) >= requiredAmount) continue;
            String message = this.plugin.getMessageManager().getMessage("totem.upgrade-missing-items").replace("[amount]", String.valueOf(requiredAmount)).replace("[item]", itemName);
            this.plugin.sendMessage(player, MrLibColors.colorize((String)message));
            return false;
        }
        ConfigurationSection fishesSection = config.getConfigurationSection("Fishes");
        if (fishesSection != null) {
            boolean hasEpic;
            int rareRequired = fishesSection.getInt("Rare", 0);
            int epicRequired = fishesSection.getInt("Epic", 0);
            boolean hasRare = this.countFishByRarity(player, "RARE") >= rareRequired;
            boolean bl = hasEpic = this.countFishByRarity(player, "EPIC") >= epicRequired;
            if (!hasRare && !hasEpic) {
                String message = this.plugin.getMessageManager().getMessage("totem.upgrade-missing-fish").replace("[rare]", String.valueOf(rareRequired)).replace("[epic]", String.valueOf(epicRequired));
                this.plugin.sendMessage(player, MrLibColors.colorize((String)message));
                return false;
            }
        }
        return true;
    }

    private void removeUpgradeSlotsRequirements(Player player, ConfigurationSection config) {
        List requiredItems = config.getStringList("Items");
        for (String itemStr : requiredItems) {
            String[] parts = itemStr.split(":");
            if (parts.length != 2) continue;
            String itemName = parts[0];
            int requiredAmount = Integer.parseInt(parts[1]);
            this.removeCustomItems(player, itemName, requiredAmount);
        }
        ConfigurationSection fishesSection = config.getConfigurationSection("Fishes");
        if (fishesSection != null) {
            int rareRequired = fishesSection.getInt("Rare", 0);
            int epicRequired = fishesSection.getInt("Epic", 0);
            if (this.countFishByRarity(player, "RARE") >= rareRequired) {
                this.removeFishByRarity(player, "RARE", rareRequired);
            } else if (this.countFishByRarity(player, "EPIC") >= epicRequired) {
                this.removeFishByRarity(player, "EPIC", epicRequired);
            }
        }
    }

    private int countCustomItems(Player player, String itemName) {
        int count = 0;
        String customType = this.getCustomItemType(itemName);
        for (ItemStack item : player.getInventory().getContents()) {
            String customItemType;
            NamespacedKey customItemKey;
            PersistentDataContainer dataContainer;
            ItemMeta meta;
            if (item == null || item.getType() == Material.AIR || (meta = item.getItemMeta()) == null || !(dataContainer = meta.getPersistentDataContainer()).has(customItemKey = new NamespacedKey((Plugin)this.plugin, "custom_drop_type"), PersistentDataType.STRING) || !customType.equals(customItemType = (String)dataContainer.get(customItemKey, PersistentDataType.STRING))) continue;
            count += item.getAmount();
        }
        return count;
    }

    private String getCustomItemType(String materialName) {
        switch (materialName) {
            case "DOLPHIN_TAIL": {
                return "dolphin-tail";
            }
            case "CRAB_CLAWS": {
                return "crab-claws";
            }
            case "CRAB_SHELL": {
                return "crab-shell";
            }
            case "SQUID_TENTACLE": {
                return "squid-tentacle";
            }
        }
        return materialName.toLowerCase().replace("_", "-");
    }

    private int countFishByRarity(Player player, String rarity) {
        int count = 0;
        String actualRarity = "RARE".equalsIgnoreCase(rarity) ? this.plugin.getConfigManager().getRareRarity() : ("EPIC".equalsIgnoreCase(rarity) ? this.plugin.getConfigManager().getEpicRarity() : rarity.toUpperCase());
        for (ItemStack item : player.getInventory().getContents()) {
            String fishRarity;
            NamespacedKey fishRarityKey;
            PersistentDataContainer dataContainer;
            ItemMeta meta;
            if (item == null || item.getType() == Material.AIR || (meta = item.getItemMeta()) == null || !(dataContainer = meta.getPersistentDataContainer()).has(fishRarityKey = new NamespacedKey("mrultimatefishing", "muf_fish_rarity"), PersistentDataType.STRING) || !actualRarity.equalsIgnoreCase(fishRarity = (String)dataContainer.get(fishRarityKey, PersistentDataType.STRING))) continue;
            count += item.getAmount();
        }
        return count;
    }

    private void removeCustomItems(Player player, String itemName, int amount) {
        String customType = this.getCustomItemType(itemName);
        for (ItemStack item : player.getInventory().getContents()) {
            String customItemType;
            NamespacedKey customItemKey;
            PersistentDataContainer dataContainer;
            ItemMeta meta;
            if (item == null || item.getType() == Material.AIR || amount <= 0 || (meta = item.getItemMeta()) == null || !(dataContainer = meta.getPersistentDataContainer()).has(customItemKey = new NamespacedKey((Plugin)this.plugin, "custom_drop_type"), PersistentDataType.STRING) || !customType.equals(customItemType = (String)dataContainer.get(customItemKey, PersistentDataType.STRING))) continue;
            int itemAmount = item.getAmount();
            if (itemAmount <= amount) {
                amount -= itemAmount;
                item.setAmount(0);
                continue;
            }
            item.setAmount(itemAmount - amount);
            amount = 0;
        }
    }

    private void removeFishByRarity(Player player, String rarity, int amount) {
        String actualRarity = "RARE".equalsIgnoreCase(rarity) ? this.plugin.getConfigManager().getRareRarity() : ("EPIC".equalsIgnoreCase(rarity) ? this.plugin.getConfigManager().getEpicRarity() : rarity.toUpperCase());
        for (ItemStack item : player.getInventory().getContents()) {
            String fishRarity;
            NamespacedKey fishRarityKey;
            PersistentDataContainer dataContainer;
            ItemMeta meta;
            if (item == null || item.getType() == Material.AIR || amount <= 0 || (meta = item.getItemMeta()) == null || !(dataContainer = meta.getPersistentDataContainer()).has(fishRarityKey = new NamespacedKey("mrultimatefishing", "muf_fish_rarity"), PersistentDataType.STRING) || !actualRarity.equalsIgnoreCase(fishRarity = (String)dataContainer.get(fishRarityKey, PersistentDataType.STRING))) continue;
            int itemAmount = item.getAmount();
            if (itemAmount <= amount) {
                amount -= itemAmount;
                item.setAmount(0);
                continue;
            }
            item.setAmount(itemAmount - amount);
            amount = 0;
        }
    }

    public boolean handleInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return false;
        }
        Player player = (Player)event.getPlayer();
        if (this.isTotemMenuRegistered(event.getInventory())) {
            this.openMenus.remove(player.getUniqueId());
            this.unregisterTotemMenuInventory(event.getInventory());
            return true;
        }
        return false;
    }

    public boolean handleInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        if (this.isTotemMenuRegistered(event.getInventory())) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    public void cleanupPlayerData(Player player) {
        this.openMenus.remove(player.getUniqueId());
    }
}

