/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimatefishing.utils;

public class TimeUtils {
    public static String formatTime(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes, secs);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, secs);
        }
        return String.format("%ds", secs);
    }

    public static String formatTimeWithSuffixes(long seconds) {
        int length;
        if (seconds <= 0L) {
            return "0sec";
        }
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("min ");
        }
        if (secs > 0L || sb.length() == 0) {
            sb.append(secs).append("sec");
        }
        if ((length = sb.length()) > 0 && sb.charAt(length - 1) == ' ') {
            sb.setLength(length - 1);
        }
        return sb.toString();
    }
}

