/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.totemNerf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionType;
import org.jufyer.plugin.totemNerf.brewing.BrewingControler;
import org.jufyer.plugin.totemNerf.brewing.BrewingRecipe;
import org.jufyer.plugin.totemNerf.commands.GivePotion;
import org.jufyer.plugin.totemNerf.commands.SetMaxTotems;
import org.jufyer.plugin.totemNerf.listeners.PlayerListeners;

public final class Main
extends JavaPlugin {
    private static Main instance;
    public static BrewingControler bc;

    public static Main getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListeners(), (Plugin)this);
        this.getCommand("setMaxTotems").setExecutor((CommandExecutor)new SetMaxTotems());
        this.getCommand("givePotion").setExecutor((CommandExecutor)new GivePotion());
        Main.addBrewingRecipie();
    }

    public void onDisable() {
    }

    public static void addBrewingRecipie() {
        ItemStack resetPotion = new ItemStack(Material.POTION);
        resetPotion.setAmount(1);
        ItemMeta meta = resetPotion.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(123));
        meta.setDisplayName("\u00a7rPotion of Purification");
        meta.setLore(Arrays.asList("\u00a7aSet's your maximum Health back to 10 Hearts."));
        ((PotionMeta)meta).setColor(Color.LIME);
        resetPotion.setItemMeta(meta);
        ItemStack bottle = new ItemStack(Material.POTION, 1);
        PotionMeta pmeta = (PotionMeta)bottle.getItemMeta();
        pmeta.setBasePotionType(PotionType.WATER);
        bottle.setItemMeta((ItemMeta)pmeta);
        bc = new BrewingControler((Plugin)Main.getInstance());
        BrewingRecipe recipe = new BrewingRecipe(new NamespacedKey((Plugin)Main.getInstance(), "customPotion"), resetPotion, new ItemStack(Material.GOLDEN_APPLE), bottle);
        bc.addRecipe(recipe);
    }

    public static void setMaxTotemsFile(int numberOfTotems) {
        File folder = Main.getInstance().getDataFolder();
        File file = new File(folder, "maxTotems");
        try {
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("Directory couldn't be created: " + folder.getPath());
            }
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("File couldn't be created: " + file.getPath());
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, false));){
                writer.write(String.valueOf(numberOfTotems));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing the data", e);
        }
    }

    public static int getMaxTotems() {
        int maxTotems;
        try {
            BufferedReader reader = new BufferedReader(new BufferedReader(new FileReader(new File(Main.getInstance().getDataFolder(), "maxTotems"))));
            try {
                String data = reader.readLine();
                maxTotems = Integer.parseInt(data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (FileNotFoundException e) {
            maxTotems = 1;
        }
        return maxTotems;
    }
}

