/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.totemNerf.brewing;

import org.bukkit.Material;
import org.bukkit.block.BrewingStand;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jufyer.plugin.totemNerf.brewing.BrewingControler;
import org.jufyer.plugin.totemNerf.brewing.BrewingRecipe;

public class BrewClock
extends BukkitRunnable {
    private Plugin plugin;
    BrewingControler brewingControler;
    private BrewingStand stand;
    private int stopTime;
    private int brewTime;
    private int fuelUse;

    public BrewClock(Plugin plugin, BrewingControler brewingControler, BrewingStand stand, int stopTime, int fuelUse) {
        this.plugin = plugin;
        this.brewingControler = brewingControler;
        this.stand = stand;
        this.stopTime = stopTime;
        this.brewTime = 0;
        this.fuelUse = fuelUse;
        this.useUpFuel(fuelUse);
        this.runTaskTimer(this.plugin, 0L, 1L);
    }

    public void run() {
        this.updateTime();
        if (this.brewTime < this.stopTime) {
            ++this.brewTime;
        } else {
            BrewerInventory bInv = this.stand.getInventory();
            ItemStack ing = bInv.getIngredient();
            int maxIng = 0;
            for (int i = 0; i < 3; ++i) {
                ItemStack base = bInv.getItem(i);
                BrewingRecipe recipe = this.brewingControler.getRecipe(ing, base);
                if (recipe == null) continue;
                maxIng = Math.max(maxIng, recipe.getInputIngredient().getAmount());
                recipe.getAction().brew(this.stand, recipe, i);
            }
            if (ing != null) {
                ing.setAmount(ing.getAmount() - maxIng);
                if (ing.getAmount() == 0) {
                    ing = new ItemStack(Material.AIR);
                }
                bInv.setIngredient(ing);
                this.cancel();
            }
        }
    }

    private void useUpFuel(int fuel) {
        int processedFuel = 0;
        while (processedFuel < fuel) {
            int inside = this.stand.getFuelLevel();
            if (inside == 0) {
                return;
            }
            if (this.stand.getFuelLevel() >= fuel) {
                this.stand.setFuelLevel(inside - fuel);
                processedFuel = fuel;
            } else {
                processedFuel += inside;
                this.stand.setFuelLevel(0);
            }
            this.stand.update();
        }
    }

    private void updateTime() {
        this.stand.setBrewingTime((int)(400.0 * (1.0 - (double)this.brewTime / (double)this.stopTime)));
        this.stand.update();
    }

    public int getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(int stopTime) {
        this.stopTime = stopTime;
    }

    public int getFuelUse() {
        return this.fuelUse;
    }

    public void setFuelUse(int fuelUse) {
        if (fuelUse - this.fuelUse > 0) {
            this.useUpFuel(fuelUse - this.fuelUse);
        }
        this.fuelUse = fuelUse;
    }
}

