/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.totemNerf.brewing;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jufyer.plugin.totemNerf.brewing.BrewAction;

public class BrewingRecipe {
    private final NamespacedKey key;
    private final ItemStack result;
    private final ItemStack inputIngredient;
    private final ItemStack inputBase;
    private int fuelUse;
    private int cookingTime;
    private BrewAction action;

    public BrewingRecipe(NamespacedKey key, ItemStack result, ItemStack inputIngredient, ItemStack inputBase) {
        this(key, result, inputIngredient, inputBase, 1, 400, new BrewAction());
    }

    public BrewingRecipe(NamespacedKey key, ItemStack result, ItemStack inputIngredient, ItemStack inputBase, int fuelUse, int cookingTime) {
        this(key, result, inputIngredient, inputBase, fuelUse, cookingTime, new BrewAction());
    }

    public BrewingRecipe(NamespacedKey key, ItemStack result, ItemStack inputIngredient, ItemStack inputBase, int fuelUse, int cookingTime, BrewAction action) {
        this.key = key;
        this.result = result;
        this.inputIngredient = inputIngredient == null ? new ItemStack(Material.AIR) : inputIngredient;
        this.inputBase = inputBase == null ? new ItemStack(Material.AIR) : inputBase;
        this.fuelUse = fuelUse;
        this.cookingTime = cookingTime;
        this.action = action;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack getInputIngredient() {
        return this.inputIngredient;
    }

    public ItemStack getInputBase() {
        return this.inputBase;
    }

    public int getFuelUse() {
        return this.fuelUse;
    }

    public void setFuelUse(int fuelUse) {
        this.fuelUse = fuelUse;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public void setCookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
    }

    public BrewAction getAction() {
        return this.action;
    }

    public void setAction(BrewAction action) {
        this.action = action;
    }

    public String toString() {
        return "BrewingRecipe [cookingTime=" + this.cookingTime + ", fuelUse=" + this.fuelUse + ", inputBase=" + this.inputBase.toString() + ", inputIngredient=" + this.inputIngredient.toString() + ", key=" + this.key.toString() + ", result=" + this.result.toString() + "]";
    }
}

