/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.totemNerf.brewing;

import java.util.HashMap;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jufyer.plugin.totemNerf.brewing.BrewClock;
import org.jufyer.plugin.totemNerf.brewing.BrewingControler;
import org.jufyer.plugin.totemNerf.brewing.BrewingRecipe;

public class PotionEvent
implements Listener {
    private Plugin plugin;
    private BrewingControler brewingControler;
    private static HashMap<BrewingStand, BrewClock> activeBrews = new HashMap();

    public PotionEvent(Plugin plugin, BrewingControler brewingControler) {
        this.plugin = plugin;
        this.brewingControler = brewingControler;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBrewingInventoryClickEvent(InventoryClickEvent event) {
        Inventory inv = event.getClickedInventory();
        if (inv == null || inv.getType() != InventoryType.BREWING) {
            return;
        }
        this.manageBrewerInventory(event);
        BrewerInventory bInv = (BrewerInventory)inv;
        ItemStack ing = bInv.getIngredient();
        boolean canBrew = false;
        int maxTime = 0;
        int maxFuel = 0;
        BrewingStand bStand = bInv.getHolder();
        BrewClock brewClock = activeBrews.get(bStand);
        Logger l = this.plugin.getLogger();
        int fuel = BrewingControler.totalFuelInBrewingStand(bStand);
        if (brewClock != null && !brewClock.isCancelled()) {
            fuel += brewClock.getFuelUse();
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack base = bInv.getItem(i);
            BrewingRecipe r = this.brewingControler.getRecipe(ing, base, fuel);
            if (r == null) continue;
            canBrew = true;
            maxTime = Math.max(maxTime, r.getCookingTime());
            maxFuel = Math.max(maxFuel, r.getFuelUse());
        }
        if (brewClock != null && !brewClock.isCancelled()) {
            if (!canBrew) {
                brewClock.cancel();
                brewClock = null;
            } else {
                if (brewClock.getFuelUse() != maxFuel) {
                    brewClock.setFuelUse(maxFuel);
                }
                if (brewClock.getStopTime() != maxTime) {
                    brewClock.setStopTime(maxTime);
                }
            }
        } else if (canBrew) {
            brewClock = new BrewClock(this.plugin, this.brewingControler, bStand, maxTime, maxFuel);
            activeBrews.put(bStand, brewClock);
        }
    }

    private void manageBrewerInventory(InventoryClickEvent event) {
        event.setCancelled(true);
        ClickType cl = event.getClick();
        Player p = (Player)event.getWhoClicked();
        ItemStack slot = event.getCurrentItem();
        ItemStack held = event.getCursor();
        int slotC = slot.getAmount();
        int heldC = held.getAmount();
        ItemStack empty = new ItemStack(Material.AIR);
        boolean dropAll = true;
        switch (cl) {
            case LEFT: {
                if (slot.isSimilar(held)) {
                    if (slotC + heldC > slot.getMaxStackSize()) {
                        slot.setAmount(slot.getMaxStackSize());
                        event.setCurrentItem(slot);
                        held.setAmount(heldC - (slot.getMaxStackSize() - slotC));
                        p.setItemOnCursor(held);
                        break;
                    }
                    slot.setAmount(slotC + heldC);
                    event.setCurrentItem(slot);
                    p.setItemOnCursor(empty);
                    break;
                }
                event.setCurrentItem(held);
                p.setItemOnCursor(slot);
                break;
            }
            case RIGHT: {
                if (heldC > 0 && (slot.isSimilar(held) || slotC == 0) && slotC + 1 <= held.getMaxStackSize()) {
                    held.setAmount(slotC + 1);
                    event.setCurrentItem(held);
                    if (heldC - 1 > 0) {
                        held.setAmount(heldC - 1);
                    } else {
                        held = empty;
                    }
                    p.setItemOnCursor(held);
                    break;
                }
                if (heldC == 0) {
                    slot.setAmount(slotC / 2);
                    event.setCurrentItem(slot);
                    slot.setAmount(slotC - slotC / 2);
                    p.setItemOnCursor(slot);
                    break;
                }
                event.setCurrentItem(held);
                p.setItemOnCursor(slot);
                break;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: {
                HashMap overflow = p.getInventory().addItem(new ItemStack[]{slot});
                if (overflow.size() > 0) {
                    for (Integer i : overflow.keySet()) {
                        event.setCurrentItem((ItemStack)overflow.get(i));
                    }
                    break;
                }
                event.setCurrentItem(empty);
                break;
            }
            case DROP: {
                dropAll = false;
            }
            case CONTROL_DROP: {
                int drop;
                if (slotC == 0 || heldC > 0) break;
                ItemStack hand = p.getInventory().getItemInMainHand();
                p.getInventory().setItemInMainHand(slot);
                p.dropItem(dropAll);
                p.getInventory().setItemInMainHand(hand);
                int n = drop = dropAll ? slotC : 1;
                if (slotC - drop > 0) {
                    slot.setAmount(slotC - drop);
                } else {
                    slot = empty;
                }
                event.setCurrentItem(slot);
                break;
            }
            case SWAP_OFFHAND: {
                event.setCurrentItem(p.getInventory().getItemInOffHand());
                p.getInventory().setItemInOffHand(slot);
                break;
            }
            case NUMBER_KEY: {
                int hotbar = event.getHotbarButton();
                event.setCurrentItem(p.getInventory().getItem(hotbar));
                p.getInventory().setItem(hotbar, slot);
                break;
            }
            case DOUBLE_CLICK: {
                int stackC;
                int i = 0;
                for (ItemStack stack : event.getInventory().getContents()) {
                    if (stack != null && stack.isSimilar(held)) {
                        stackC = stack.getAmount();
                        if (stackC + held.getAmount() > held.getMaxStackSize()) {
                            stack.setAmount(held.getAmount() - (held.getMaxStackSize() - stackC));
                            held.setAmount(held.getMaxStackSize());
                            event.getInventory().setItem(i, stack);
                            p.setItemOnCursor(held);
                        } else {
                            held.setAmount(stackC + held.getAmount());
                            event.getInventory().setItem(i, empty);
                        }
                    }
                    p.setItemOnCursor(held);
                    ++i;
                }
                if (held.getAmount() >= held.getMaxStackSize()) break;
                i = 0;
                for (ItemStack stack : p.getInventory().getContents()) {
                    if (stack != null && stack.isSimilar(held)) {
                        stackC = stack.getAmount();
                        if (stackC + held.getAmount() > held.getMaxStackSize()) {
                            stack.setAmount(held.getAmount() - (held.getMaxStackSize() - stackC));
                            held.setAmount(held.getMaxStackSize());
                            p.getInventory().setItem(i, stack);
                            p.setItemOnCursor(held);
                        } else {
                            held.setAmount(stackC + held.getAmount());
                            p.getInventory().setItem(i, empty);
                        }
                    }
                    p.setItemOnCursor(held);
                    ++i;
                }
                break;
            }
        }
        ((BrewerInventory)event.getInventory()).getHolder().update(true);
    }
}

