/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.capability;

import de.cadentem.additional_enchantments.capability.EntityData;
import de.cadentem.additional_enchantments.capability.EntityDataProvider;
import de.cadentem.additional_enchantments.capability.PlayerData;
import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.capability.ProjectileData;
import de.cadentem.additional_enchantments.capability.ProjectileDataProvider;
import de.cadentem.additional_enchantments.enchantments.ExplosiveTipEnchantment;
import de.cadentem.additional_enchantments.enchantments.HomingEnchantment;
import de.cadentem.additional_enchantments.enchantments.StraightShotEnchantment;
import de.cadentem.additional_enchantments.enchantments.TippedEnchantment;
import de.cadentem.additional_enchantments.network.NetworkHandler;
import de.cadentem.additional_enchantments.network.SyncPlayerData;
import de.cadentem.additional_enchantments.network.SyncProjectileData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class CapabilityHandler {
    public static final Capability<PlayerData> PLAYER_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerData>(){});
    public static final ResourceLocation PLAYER_DATA = new ResourceLocation("additional_enchantments", "player_data");
    public static final Capability<ProjectileData> PROJECTILE_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ProjectileData>(){});
    public static final ResourceLocation PROJECTILE_DATA = new ResourceLocation("additional_enchantments", "projectile_data");
    public static final Capability<EntityData> ENTITY_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityData>(){});
    public static final ResourceLocation ENTITY_DATA = new ResourceLocation("additional_enchantments", "entity_data");

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Object object;
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(ENTITY_DATA, (ICapabilityProvider)new EntityDataProvider());
        }
        if ((object = event.getObject()) instanceof Player && !((player = (Player)object) instanceof FakePlayer)) {
            event.addCapability(PLAYER_DATA, (ICapabilityProvider)new PlayerDataProvider());
        }
        if (event.getObject() instanceof Projectile) {
            event.addCapability(PROJECTILE_DATA, (ICapabilityProvider)new ProjectileDataProvider());
        }
    }

    @SubscribeEvent
    public static void handleInitialSync(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            TippedEnchantment.applyEffects(projectile);
            StraightShotEnchantment.updateGravity(projectile);
            HomingEnchantment.setEnchantmentLevel(projectile);
            ExplosiveTipEnchantment.setEnchantmentLevel(projectile);
            CapabilityHandler.syncProjectileData(projectile);
        } else {
            entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                CapabilityHandler.syncPlayerData(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleProjectileImpact(ProjectileImpactEvent event) {
        if (!event.isCanceled()) {
            ProjectileDataProvider.getCapability((Entity)event.getProjectile()).ifPresent(data -> data.handleImpact(event.getProjectile()));
        }
    }

    @SubscribeEvent
    public static void handlePlayerDeath(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        PlayerDataProvider.getCapability((Entity)event.getEntity()).ifPresent(data -> PlayerDataProvider.getCapability((Entity)event.getOriginal()).ifPresent(oldData -> data.deserializeNBT(oldData.serializeNBT())));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void removeCachedEntry(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityDataProvider.removeCachedEntry(livingEntity);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PlayerDataProvider.removeCachedEntry(player);
        }
        if (entity instanceof Projectile) {
            ProjectileDataProvider.removeCachedEntry(entity);
        }
    }

    public static void syncProjectileData(Projectile projectile) {
        if (projectile.m_9236_().m_5776_()) {
            return;
        }
        ProjectileDataProvider.getCapability((Entity)projectile).ifPresent(data -> CapabilityHandler.syncProjectileData(projectile, data.serializeNBT()));
    }

    public static void syncProjectileData(Projectile projectile, CompoundTag tag) {
        if (projectile.m_9236_().m_5776_()) {
            return;
        }
        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> projectile), (Object)new SyncProjectileData(tag, projectile.m_19879_()));
    }

    public static void syncPlayerData(Player player) {
        PlayerDataProvider.getCapability((Entity)player).ifPresent(data -> CapabilityHandler.syncPlayerData(player, data.serializeNBT()));
    }

    public static void syncPlayerData(Player player, CompoundTag tag) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncPlayerData(tag));
        } else {
            NetworkHandler.CHANNEL.sendToServer((Object)new SyncPlayerData(tag));
        }
    }
}

