/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.capability;

import de.cadentem.additional_enchantments.capability.CapabilityHandler;
import de.cadentem.additional_enchantments.capability.EntityData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDataProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Map<Integer, LazyOptional<EntityData>> SERVER_CACHE = new HashMap<Integer, LazyOptional<EntityData>>();
    private final EntityData data = new EntityData();
    private final LazyOptional<EntityData> instance = LazyOptional.of(() -> this.data);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        return capability == CapabilityHandler.ENTITY_DATA_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return ((EntityData)this.instance.orElseThrow(() -> new IllegalArgumentException("Capability instance was not present"))).serializeNBT();
    }

    public void deserializeNBT(CompoundTag tag) {
        ((EntityData)this.instance.orElseThrow(() -> new IllegalArgumentException("Capability instance was not present"))).deserializeNBT(tag);
    }

    public static LazyOptional<EntityData> getCapability(Entity entity) {
        if (entity.m_9236_().m_5776_()) {
            return LazyOptional.empty();
        }
        if (entity instanceof LivingEntity) {
            LazyOptional capability = SERVER_CACHE.get(entity.m_19879_());
            if (capability == null) {
                capability = entity.getCapability(CapabilityHandler.ENTITY_DATA_CAPABILITY);
                capability.addListener(ignored -> SERVER_CACHE.remove(entity.m_19879_()));
                if (capability.isPresent()) {
                    SERVER_CACHE.put(entity.m_19879_(), (LazyOptional<EntityData>)capability);
                }
            }
            return capability;
        }
        return LazyOptional.empty();
    }

    public static void removeCachedEntry(LivingEntity entity) {
        if (!entity.m_9236_().m_5776_()) {
            SERVER_CACHE.remove(entity.m_19879_());
        }
    }
}

