/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.capability;

import de.cadentem.additional_enchantments.capability.CapabilityHandler;
import de.cadentem.additional_enchantments.capability.PlayerData;
import de.cadentem.additional_enchantments.client.ClientProxy;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDataProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Map<Integer, LazyOptional<PlayerData>> SERVER_CACHE = new HashMap<Integer, LazyOptional<PlayerData>>();
    public static final Map<Integer, LazyOptional<PlayerData>> CLIENT_CACHE = new HashMap<Integer, LazyOptional<PlayerData>>();
    private final PlayerData data = new PlayerData();
    private final LazyOptional<PlayerData> instance = LazyOptional.of(() -> this.data);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        return capability == CapabilityHandler.PLAYER_DATA_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return ((PlayerData)this.instance.orElseThrow(() -> new IllegalArgumentException("Capability instance was not present"))).serializeNBT();
    }

    public void deserializeNBT(CompoundTag tag) {
        ((PlayerData)this.instance.orElseThrow(() -> new IllegalArgumentException("Capability instance was not present"))).deserializeNBT(tag);
    }

    public static LazyOptional<PlayerData> getCapability(Entity entity) {
        if (entity instanceof Player) {
            Map<Integer, LazyOptional<PlayerData>> sidedCache = entity.m_9236_().m_5776_() ? CLIENT_CACHE : SERVER_CACHE;
            LazyOptional capability = sidedCache.get(entity.m_19879_());
            if (capability == null) {
                capability = entity.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY);
                capability.addListener(ignored -> sidedCache.remove(entity.m_19879_()));
                if (capability.isPresent()) {
                    sidedCache.put(entity.m_19879_(), (LazyOptional<PlayerData>)capability);
                }
            }
            return capability;
        }
        return LazyOptional.empty();
    }

    public static void removeCachedEntry(Player player) {
        if (player.m_9236_().m_5776_()) {
            if (player == ClientProxy.getLocalPlayer()) {
                CLIENT_CACHE.clear();
            } else {
                CLIENT_CACHE.remove(player.m_19879_());
            }
        } else {
            SERVER_CACHE.remove(player.m_19879_());
        }
    }
}

