/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.capability;

import com.google.common.collect.Sets;
import de.cadentem.additional_enchantments.capability.CapabilityHandler;
import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.data.AEEntityTags;
import de.cadentem.additional_enchantments.enchantments.HomingEnchantment;
import de.cadentem.additional_enchantments.mixin.AbstractArrowAccess;
import de.cadentem.additional_enchantments.mixin.TridentAccess;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class ProjectileData {
    public Set<MobEffectInstance> addedEffects;
    public int tippedEnchantmentLevel;
    public LivingEntity homingTarget;
    public int homingTargetId;
    public int homingEnchantmentLevel;
    public int explosiveTipEnchantmentLevel;
    public int straightShotEnchantmentLevel;
    public int gravityTime;

    public void handleHomingMovement(Projectile instance) {
        if (this.homingTarget == null && this.homingTargetId != -1) {
            Entity entity = instance.m_9236_().m_6815_(this.homingTargetId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.homingTarget = livingEntity = (LivingEntity)entity;
            } else {
                this.homingTargetId = -1;
            }
        }
        if (this.isInvalidTarget(this.homingTarget) || this.isInvalidProjectile(instance)) {
            this.setHomingTarget(instance, null);
            return;
        }
        Vec3 velocity = instance.m_20184_();
        Vec3 motion = instance.m_20182_().m_82505_(this.homingTarget.m_20182_().m_82520_(0.0, (double)(this.homingTarget.m_20192_() / 2.0f), 0.0));
        motion = motion.m_82541_();
        motion = motion.m_82490_(velocity.m_82553_() * (0.95 + (double)this.homingEnchantmentLevel * 0.01));
        instance.m_20256_(motion);
    }

    public void searchForHomingTarget(Projectile instance) {
        ServerPlayer serverPlayer;
        block3: {
            block2: {
                Entity entity;
                if (this.homingTarget != null || !((entity = instance.m_37282_()) instanceof ServerPlayer)) break block2;
                serverPlayer = (ServerPlayer)entity;
                if (!this.isInvalidProjectile(instance)) break block3;
            }
            return;
        }
        PlayerDataProvider.getCapability((Entity)serverPlayer).ifPresent(playerData -> {
            LivingEntity target;
            if (playerData.homingTypeFilter == HomingEnchantment.TypeFilter.NONE) {
                return;
            }
            List entities = serverPlayer.m_9236_().m_6443_(LivingEntity.class, instance.m_20191_().m_82400_((double)(5 + this.homingEnchantmentLevel * 2)), entity -> {
                TamableAnimal tamable;
                if (this.isInvalidTarget((LivingEntity)entity)) {
                    return false;
                }
                if (entity.m_6095_().m_204039_(AEEntityTags.HOMING_BLACKLIST)) {
                    return false;
                }
                if (entity.m_20147_() || entity.m_20145_() && !entity.m_142038_()) {
                    return false;
                }
                if (playerData.homingTypeFilter == HomingEnchantment.TypeFilter.MONSTER && !(entity instanceof Monster)) {
                    return false;
                }
                if (playerData.homingTypeFilter == HomingEnchantment.TypeFilter.ANIMAL && !(entity instanceof Animal)) {
                    return false;
                }
                if (playerData.homingTypeFilter == HomingEnchantment.TypeFilter.BOSSES && !entity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES)) {
                    return false;
                }
                return serverPlayer != entity && !entity.m_7307_((Entity)serverPlayer) && (!(entity instanceof TamableAnimal) || !(tamable = (TamableAnimal)entity).m_21830_((LivingEntity)serverPlayer));
            });
            if (entities.isEmpty()) {
                return;
            }
            if (playerData.homingPriority == HomingEnchantment.Priority.RANDOM) {
                target = (LivingEntity)entities.get(serverPlayer.m_217043_().m_188503_(entities.size()));
            } else {
                entities.sort((a, b) -> {
                    if (playerData.homingPriority == HomingEnchantment.Priority.CLOSEST) {
                        return Float.compare(a.m_20270_((Entity)instance), b.m_20270_((Entity)instance));
                    }
                    if (playerData.homingPriority == HomingEnchantment.Priority.LOWEST_HEALTH) {
                        return Float.compare(a.m_21233_() / 100.0f * a.m_21223_(), b.m_21233_() / 100.0f * b.m_21223_());
                    }
                    if (playerData.homingPriority == HomingEnchantment.Priority.HIGHEST_HEALTH) {
                        return Float.compare(a.m_21233_() / 100.0f * a.m_21223_(), b.m_21233_() / 100.0f * b.m_21223_()) * -1;
                    }
                    return 0;
                });
                target = (LivingEntity)entities.get(0);
            }
            this.setHomingTarget(instance, target);
        });
    }

    public void handleImpact(Projectile projectile) {
        if (this.straightShotEnchantmentLevel > 0) {
            projectile.m_20242_(false);
        }
        this.setHomingTarget(projectile, null);
    }

    public boolean hasAddedEffects() {
        return this.addedEffects != null && !this.addedEffects.isEmpty();
    }

    private void setHomingTarget(Projectile instance, LivingEntity target) {
        if (target == null) {
            this.homingTarget = null;
            this.homingTargetId = -1;
        } else {
            this.homingTarget = target;
            this.homingTargetId = target.m_19879_();
        }
        CapabilityHandler.syncProjectileData(instance);
    }

    private boolean isInvalidTarget(LivingEntity target) {
        if (target == null) {
            return true;
        }
        return target.m_213877_() || target.m_21224_();
    }

    private boolean isInvalidProjectile(Projectile projectile) {
        TridentAccess trident;
        AbstractArrowAccess arrow;
        if (projectile instanceof AbstractArrowAccess && (arrow = (AbstractArrowAccess)projectile).additional_enchantments$isInGround()) {
            return true;
        }
        if (projectile instanceof TridentAccess && (trident = (TridentAccess)projectile).additional_enchantments$didDealDamage()) {
            return true;
        }
        return projectile.m_213877_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("tippedEnchantmentLevel", this.tippedEnchantmentLevel);
        tag.m_128405_("homingEnchantmentLevel", this.homingEnchantmentLevel);
        tag.m_128405_("explosiveTipEnchantmentLevel", this.explosiveTipEnchantmentLevel);
        tag.m_128405_("straightShotEnchantmentLevel", this.straightShotEnchantmentLevel);
        tag.m_128405_("homingTargetId", this.homingTargetId);
        tag.m_128405_("gravityTime", this.gravityTime);
        if (this.hasAddedEffects()) {
            ListTag effects = new ListTag();
            for (MobEffectInstance effect : this.addedEffects) {
                effects.add((Object)effect.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("addedEffects", (Tag)effects);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.tippedEnchantmentLevel = tag.m_128451_("tippedEnchantmentLevel");
        this.homingEnchantmentLevel = tag.m_128451_("homingEnchantmentLevel");
        this.explosiveTipEnchantmentLevel = tag.m_128451_("explosiveTipEnchantmentLevel");
        this.straightShotEnchantmentLevel = tag.m_128451_("straightShotEnchantmentLevel");
        this.homingTargetId = tag.m_128451_("homingTargetId");
        this.gravityTime = tag.m_128451_("gravityTime");
        ListTag effects = tag.m_128437_("addedEffects", 10);
        if (!this.hasAddedEffects()) {
            this.addedEffects = Sets.newHashSet();
        }
        for (int i = 0; i < effects.size(); ++i) {
            this.addedEffects.add(MobEffectInstance.m_19560_((CompoundTag)effects.m_128728_(i)));
        }
    }
}

