/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.client;

import de.cadentem.additional_enchantments.AE;
import de.cadentem.additional_enchantments.config.VisionConfig;
import de.cadentem.additional_enchantments.data.AEBlockTags;
import de.cadentem.additional_enchantments.util.ColorUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CustomGlowParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final List<Integer> colors;
    private final double colorShiftRate;
    private final double colorOffset;

    protected CustomGlowParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, List<Integer> colors, double colorShiftRate) {
        super(level, x, y, z, 0.5 - level.m_213780_().m_188500_(), 0.0, 0.5 - level.m_213780_().m_188500_());
        this.f_172258_ = 0.96f;
        this.f_172259_ = true;
        this.sprites = sprites;
        this.f_107663_ *= 0.75f;
        this.f_107219_ = false;
        this.colors = colors;
        this.colorShiftRate = colorShiftRate;
        this.colorOffset = level.m_213780_().m_188500_();
        this.m_108339_(sprites);
        this.updateColor();
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float partialTick) {
        float progress = ((float)this.f_107224_ + partialTick) / (float)this.f_107225_;
        progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        int packedLight = super.m_6355_(partialTick);
        int light = packedLight & 0xFF;
        int k = packedLight >> 16 & 0xFF;
        if ((light += (int)(progress * 15.0f * 16.0f)) > 240) {
            light = 240;
        }
        return light | k << 16;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        this.updateColor();
    }

    public void updateColor() {
        int color = ColorUtils.lerpColor(this.colors, this.colorShiftRate, this.colorOffset);
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        this.m_107253_(red, green, blue);
        this.m_107271_((float)FastColor.ARGB32.m_13655_((int)color) / 255.0f);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double blockId, double enchantmentLevel, double ignored) {
            IdMap map = Minecraft.m_91087_().f_91073_.m_5962_().m_175515_(ForgeRegistries.BLOCKS.getRegistryKey()).m_206115_();
            Holder holder = (Holder)map.m_200957_((int)blockId);
            VisionConfig.VisionData visionData = VisionConfig.get((Block)holder.m_203334_(), (int)enchantmentLevel);
            if (visionData == null && holder.m_203656_(AEBlockTags.TREASURES)) {
                visionData = VisionConfig.SpecialBlock.TREASURE.get((int)enchantmentLevel);
            }
            if (visionData == null) {
                AE.LOG.warn("Invalid particle data for block [{}] at level [{}]", holder.m_203334_(), (Object)enchantmentLevel);
                return new CustomGlowParticle(level, x, y, z, this.sprites, List.of(), 1.0);
            }
            CustomGlowParticle particle = new CustomGlowParticle(level, x, y, z, this.sprites, visionData.colorsARGB(), visionData.colorShiftRate());
            particle.f_107216_ *= 0.2f;
            particle.f_107215_ *= 0.1f;
            particle.f_107217_ *= 0.1f;
            particle.m_107257_((int)(8.0 / (level.m_213780_().m_188500_() * 0.8 + 0.2)));
            return particle;
        }
    }
}

