/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.client;

import de.cadentem.additional_enchantments.capability.CapabilityHandler;
import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.enchantments.PerceptionEnchantment;
import de.cadentem.additional_enchantments.registry.AEEnchantments;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class KeyHandler {
    public static KeyMapping CYCLE_TIPPED;
    public static KeyMapping CYCLE_HOMING;
    public static KeyMapping CYCLE_EXPLOSIVE_TIP;
    public static KeyMapping CYCLE_PERCEPTION;
    public static KeyMapping CYCLE_VOIDING;
    private static int LAST_PRESS_TICK;

    @SubscribeEvent
    public static void handleKey(InputEvent.Key event) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null || Minecraft.m_91087_().f_91080_ != null || Math.abs(localPlayer.f_19797_ - LAST_PRESS_TICK) <= 20) {
            return;
        }
        AtomicBoolean playerDataChanged = new AtomicBoolean(false);
        if (event.getKey() == CYCLE_TIPPED.getKey().m_84873_() && localPlayer.m_21205_().getEnchantmentLevel((Enchantment)AEEnchantments.TIPPED.get()) > 0) {
            PlayerDataProvider.getCapability((Entity)localPlayer).ifPresent(data -> {
                data.cycleEffectFilter();
                localPlayer.m_213846_((Component)Component.m_237110_((String)"message.additional_enchantments.cycled_configuration", (Object[])new Object[]{"Tipped", data.effectFilter.name()}));
                playerDataChanged.set(true);
            });
        }
        if (event.getKey() == CYCLE_EXPLOSIVE_TIP.getKey().m_84873_() && localPlayer.m_21205_().getEnchantmentLevel((Enchantment)AEEnchantments.EXPLOSIVE_TIP.get()) > 0) {
            PlayerDataProvider.getCapability((Entity)localPlayer).ifPresent(data -> {
                data.cycleExplosionType();
                localPlayer.m_213846_((Component)Component.m_237110_((String)"message.additional_enchantments.cycled_configuration", (Object[])new Object[]{"Explosive Tip", data.explosionType.name()}));
                playerDataChanged.set(true);
            });
        }
        if (event.getKey() == CYCLE_HOMING.getKey().m_84873_() && localPlayer.m_21205_().getEnchantmentLevel((Enchantment)AEEnchantments.HOMING.get()) > 0) {
            if (localPlayer.m_6144_()) {
                PlayerDataProvider.getCapability((Entity)localPlayer).ifPresent(data -> {
                    data.cycleHomingPriority();
                    localPlayer.m_213846_((Component)Component.m_237110_((String)"message.additional_enchantments.cycled_configuration", (Object[])new Object[]{"Homing (priority)", data.homingPriority.name()}));
                    playerDataChanged.set(true);
                });
            } else {
                PlayerDataProvider.getCapability((Entity)localPlayer).ifPresent(data -> {
                    data.cycleHomingFilter();
                    localPlayer.m_213846_((Component)Component.m_237110_((String)"message.additional_enchantments.cycled_configuration", (Object[])new Object[]{"Homing (type)", data.homingTypeFilter.name()}));
                    playerDataChanged.set(true);
                });
            }
        }
        if (event.getKey() == CYCLE_PERCEPTION.getKey().m_84873_() && PerceptionEnchantment.getClientEnchantmentLevel() > 0) {
            if (localPlayer.m_6144_()) {
                PlayerDataProvider.getCapability((Entity)localPlayer).ifPresent(data -> {
                    data.cycleItemFilter();
                    localPlayer.m_213846_((Component)Component.m_237110_((String)"message.additional_enchantments.cycled_configuration", (Object[])new Object[]{"Perception (item filter)", data.itemFilter.name()}));
                    playerDataChanged.set(true);
                });
            } else {
                PlayerDataProvider.getCapability((Entity)localPlayer).ifPresent(data -> {
                    data.cycleDisplayType();
                    localPlayer.m_213846_((Component)Component.m_237110_((String)"message.additional_enchantments.cycled_configuration", (Object[])new Object[]{"Perception (display type)", data.displayType.name()}));
                    playerDataChanged.set(true);
                });
            }
        }
        if (event.getKey() == CYCLE_VOIDING.getKey().m_84873_() && localPlayer.m_21205_().getEnchantmentLevel((Enchantment)AEEnchantments.VOIDING.get()) > 0) {
            PlayerDataProvider.getCapability((Entity)localPlayer).ifPresent(data -> {
                data.cycleVoiding();
                localPlayer.m_213846_((Component)Component.m_237110_((String)"message.additional_enchantments.cycled_configuration", (Object[])new Object[]{"Voiding", data.voidingState.name()}));
                playerDataChanged.set(true);
            });
        }
        if (playerDataChanged.get()) {
            LAST_PRESS_TICK = localPlayer.f_19797_;
            CapabilityHandler.syncPlayerData((Player)localPlayer);
        }
    }
}

