/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.cadentem.additional_enchantments.client.block_vision.ShaderSimple;
import de.cadentem.additional_enchantments.client.block_vision.ShaderSimpleBlockEntities;
import de.cadentem.additional_enchantments.compat.Compat;
import de.cadentem.additional_enchantments.config.ServerConfig;
import de.cadentem.additional_enchantments.config.VisionConfig;
import de.cadentem.additional_enchantments.data.AEBlockTags;
import de.cadentem.additional_enchantments.enchantments.TreasureFinderEnchantment;
import de.cadentem.additional_enchantments.mixin.client.FrustumAccess;
import de.cadentem.additional_enchantments.mixin.client.RandomizableContainerBlockEntityAccess;
import de.cadentem.additional_enchantments.registry.AEParticles;
import de.cadentem.additional_enchantments.util.ColorUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class VisionHandler {
    private static final int EXTENDED_SEARCH_RANGE = 16;
    private static final Map<Long, Data> RENDER_DATA = new HashMap<Long, Data>();
    private static final List<Data> SHADER_RENDER_DATA = new ArrayList<Data>();
    private static final List<Data> SEARCH_RESULT = new ArrayList<Data>();
    private static final List<Long> REMOVAL = new ArrayList<Long>();
    private static Cache<LevelChunkSection, Boolean[]> CHUNK_CACHE;
    private static ShaderInstance simpleShader;
    private static int enchantmentLevel;
    private static Vec3 lastScanCenter;
    private static boolean isSearching;
    private static boolean hasPendingUpdate;
    private static boolean searchedTooEarly;

    public static void registerShaders(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("additional_enchantments", "block_vision_simple"), DefaultVertexFormat.f_85811_), instance -> {
                simpleShader = instance;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void handleBlockVision(RenderLevelStageEvent event) {
        double maxRange;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            return;
        }
        if (Compat.isRenderingShadows()) {
            return;
        }
        LocalPlayer player = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        int newEnchantmentLevel = TreasureFinderEnchantment.getClientEnchantmentLevel();
        if (newEnchantmentLevel == 0) {
            VisionHandler.clear();
            return;
        }
        if (enchantmentLevel != newEnchantmentLevel) {
            VisionHandler.clear();
        }
        if ((maxRange = VisionConfig.getMaxRange(enchantmentLevel = newEnchantmentLevel)) == 0.0) {
            VisionHandler.clear();
            return;
        }
        IdMap map = Minecraft.m_91087_().f_91073_.m_5962_().m_175515_(ForgeRegistries.BLOCKS.getRegistryKey()).m_206115_();
        VisionHandler.initCache();
        if (!isSearching && hasPendingUpdate) {
            RENDER_DATA.clear();
            for (Data data2 : SEARCH_RESULT) {
                RENDER_DATA.put(new BlockPos((double)data2.x(), (double)data2.y(), (double)data2.z()).m_121878_(), data2);
            }
            SEARCH_RESULT.clear();
            REMOVAL.clear();
            hasPendingUpdate = false;
        }
        if (!isSearching && VisionHandler.isOutsideRange(maxRange)) {
            lastScanCenter = player.m_20182_();
            isSearching = true;
            Util.m_183991_().submit(() -> {
                VisionHandler.collect((Player)player, maxRange + 16.0);
                isSearching = false;
                hasPendingUpdate = true;
            });
        }
        if (RENDER_DATA.isEmpty()) {
            return;
        }
        PoseStack pose = event.getPoseStack();
        pose.m_85836_();
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        pose.m_85837_(-camera.m_7096_(), -camera.m_7098_(), -camera.m_7094_());
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69465_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        for (long position2 : REMOVAL) {
            RENDER_DATA.remove(position2);
        }
        REMOVAL.clear();
        RENDER_DATA.forEach((position, data) -> {
            if (data.visionData().range() == 0.0 || !data.isInRange(player.m_146892_(), data.visionData().range())) {
                return;
            }
            if (((FrustumAccess)event.getFrustum()).additional_enchantments$cubeInFrustum(data.x(), data.y(), data.z(), data.x() + 1.0f, data.y() + 1.0f, data.z() + 1.0f)) {
                switch (data.visionData().displayType()) {
                    case X_RAY_OUTLINE: {
                        VisionHandler.drawLines((VertexConsumer)buffer, pose.m_85850_(), data.x(), data.y(), data.z(), data.x() + 1.0f, data.y() + 1.0f, data.z() + 1.0f, data.getColor());
                        break;
                    }
                    case GLOW: {
                        SHADER_RENDER_DATA.add((Data)data);
                        break;
                    }
                    case PARTICLES: {
                        if (Minecraft.m_91087_().m_91104_() || player.f_19797_ % (Integer)ServerConfig.TREASURE_FINDER_PARTICLE_RATE.get() != 0) break;
                        double x = (double)data.x() + 0.5 + (player.m_217043_().m_188500_() - 0.5) * 2.0;
                        double y = (double)data.y() + 0.5 + (player.m_217043_().m_188500_() - 0.5) * 2.0;
                        double z = (double)data.z() + 0.5 + (player.m_217043_().m_188500_() - 0.5) * 2.0;
                        player.f_19853_.m_7106_((ParticleOptions)AEParticles.GLOW.get(), x, y, z, (double)map.m_7447_((Object)data.state().m_60734_().m_204297_()), (double)enchantmentLevel, 0.0);
                    }
                }
            }
        });
        tesselator.m_85914_();
        pose.m_85849_();
        RenderSystem.m_69482_();
        RenderType.m_110463_().m_110188_();
    }

    @SubscribeEvent
    public static void handleShader(RenderLevelLastEvent event) {
        if (Compat.isRenderingShadows()) {
            return;
        }
        if (SHADER_RENDER_DATA.isEmpty()) {
            return;
        }
        ArrayList<Data> blockEntities = new ArrayList<Data>();
        PoseStack pose = event.getPoseStack();
        pose.m_85836_();
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        pose.m_85837_(-camera.m_7096_(), -camera.m_7098_(), -camera.m_7094_());
        ShaderSimple.beginBatch();
        for (Data data : SHADER_RENDER_DATA) {
            if (data.state().m_155947_()) {
                blockEntities.add(data);
                continue;
            }
            pose.m_85836_();
            pose.m_85837_((double)data.x(), (double)data.y(), (double)data.z());
            ShaderSimple.render(data, pose);
            pose.m_85849_();
        }
        ShaderSimple.endBatch();
        ShaderSimpleBlockEntities.beginBatch();
        for (Data data : blockEntities) {
            pose.m_85836_();
            pose.m_85837_((double)data.x(), (double)data.y(), (double)data.z());
            ShaderSimpleBlockEntities.render(data, pose);
            pose.m_85849_();
        }
        ShaderSimpleBlockEntities.endBatch();
        pose.m_85849_();
        SHADER_RENDER_DATA.clear();
    }

    @SubscribeEvent
    public static void clearData(LevelEvent.Unload event) {
        VisionHandler.clear();
    }

    public static void updateEntry(BlockPos position, BlockState oldState, BlockState newState) {
        VisionConfig.VisionData newData;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || enchantmentLevel == 0) {
            return;
        }
        Block newBlock = newState.m_60734_();
        if (oldState.m_60734_() == newBlock) {
            return;
        }
        double searchRange = VisionConfig.getMaxRange(enchantmentLevel) + 16.0;
        if (lastScanCenter != null && player.m_20182_().m_82557_(lastScanCenter) > searchRange * searchRange) {
            return;
        }
        VisionConfig.VisionData oldData = VisionConfig.get(oldState.m_60734_(), enchantmentLevel);
        if (oldData == null && oldState.m_204336_(AEBlockTags.TREASURES)) {
            oldData = VisionConfig.SpecialBlock.TREASURE.get(enchantmentLevel);
        }
        if (!RENDER_DATA.isEmpty() && oldData != null && oldData.range() > 0.0) {
            REMOVAL.add(position.m_121878_());
        }
        if ((newData = VisionConfig.get(newBlock, enchantmentLevel)) == null && newState.m_204336_(AEBlockTags.TREASURES)) {
            newData = VisionConfig.SpecialBlock.TREASURE.get(enchantmentLevel);
        }
        if (newData != null && newData.range() > 0.0) {
            RENDER_DATA.put(position.m_121878_(), new Data(newState, newData, position.m_123341_(), position.m_123342_(), position.m_123343_()));
        }
    }

    public static void addTreasure(BlockPos position, BlockState state) {
        VisionConfig.VisionData visionData = VisionConfig.SpecialBlock.TREASURE.get(enchantmentLevel);
        if (visionData != null) {
            RENDER_DATA.put(position.m_121878_(), new Data(state, visionData, position.m_123341_(), position.m_123342_(), position.m_123343_()));
        }
    }

    public static void removeTreasure(BlockPos position) {
        if (!RENDER_DATA.isEmpty()) {
            REMOVAL.add(position.m_121878_());
        }
    }

    public static ShaderInstance getSimpleShader() {
        return simpleShader;
    }

    private static void collect(Player player, double searchRange) {
        BlockPos startPosition = player.m_20183_();
        ChunkPos currentChunkPosition = new ChunkPos(startPosition);
        LevelChunk currentChunk = null;
        int minChunkX = (int)((double)startPosition.m_123341_() - searchRange);
        int maxChunkX = (int)((double)startPosition.m_123341_() + searchRange);
        int minChunkY = (int)Math.max((double)player.f_19853_.m_141937_(), (double)startPosition.m_123342_() - searchRange);
        int maxChunkY = (int)Math.min((double)(player.f_19853_.m_151558_() - 1), (double)startPosition.m_123342_() + searchRange);
        int minChunkZ = (int)((double)startPosition.m_123343_() - searchRange);
        int maxChunkZ = (int)((double)startPosition.m_123343_() + searchRange);
        BlockPos.MutableBlockPos mutablePosition = BlockPos.f_121853_.m_122032_();
        searchedTooEarly = true;
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            boolean foundXSection = false;
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                boolean foundZSection = false;
                int sectionX = SectionPos.m_123171_((int)x);
                int sectionZ = SectionPos.m_123171_((int)z);
                if (currentChunk == null || currentChunkPosition.f_45578_ != sectionX || currentChunkPosition.f_45579_ != sectionZ) {
                    currentChunkPosition = new ChunkPos(sectionX, sectionZ);
                    currentChunk = player.f_19853_.m_6325_(sectionX, sectionZ);
                }
                for (int y = maxChunkY; y >= minChunkY; --y) {
                    int sectionIndex = currentChunk.m_151564_(y);
                    LevelChunkSection section = currentChunk.m_183278_(sectionIndex);
                    mutablePosition.m_122178_(x, y, z);
                    if (foundXSection || foundZSection || VisionHandler.hasRelevantBlock(currentChunk, section, sectionIndex)) {
                        VisionConfig.VisionData visionData;
                        foundXSection = true;
                        foundZSection = true;
                        BlockState state = currentChunk.m_8055_((BlockPos)mutablePosition);
                        if (state.m_60795_()) continue;
                        Block block = state.m_60734_();
                        VisionConfig.VisionData vision = VisionConfig.get(block, enchantmentLevel);
                        if (vision != null && vision.range() > 0.0) {
                            SEARCH_RESULT.add(new Data(state, vision, x, y, z));
                            continue;
                        }
                        if (!state.m_204336_(AEBlockTags.TREASURES) || !VisionHandler.hasLoot(player.f_19853_, new BlockPos(x, y, z)) || (visionData = VisionConfig.SpecialBlock.TREASURE.get(enchantmentLevel)) == null) continue;
                        SEARCH_RESULT.add(new Data(state, visionData, x, y, z));
                        continue;
                    }
                    if (y == minChunkY) continue;
                    y = Math.max(minChunkY, SectionPos.m_123223_((int)SectionPos.m_123171_((int)y)));
                }
                if (foundZSection || z == maxChunkZ) continue;
                z = Math.min(maxChunkZ, SectionPos.m_123223_((int)(SectionPos.m_123171_((int)z) + 1)));
            }
            if (foundXSection || x == maxChunkX) continue;
            x = Math.min(maxChunkX, SectionPos.m_123223_((int)(SectionPos.m_123171_((int)x) + 1)));
        }
    }

    private static boolean hasLoot(Level level, BlockPos position) {
        RandomizableContainerBlockEntityAccess access;
        BlockEntity blockEntity = level.m_7702_(position);
        return blockEntity instanceof RandomizableContainerBlockEntityAccess && (access = (RandomizableContainerBlockEntityAccess)blockEntity).additional_enchantments$getLootTable() != null;
    }

    private static boolean hasRelevantBlock(LevelChunk chunk, LevelChunkSection section, int sectionIndex) {
        Boolean[] cachedSection = (Boolean[])CHUNK_CACHE.getIfPresent((Object)section);
        if (cachedSection == null || cachedSection[sectionIndex] == null) {
            boolean containsRelevantBlock;
            boolean bl = containsRelevantBlock = !section.m_188008_() && section.m_63002_(state -> {
                VisionConfig.VisionData vision = VisionConfig.get(state.m_60734_(), enchantmentLevel);
                searchedTooEarly = false;
                if (vision != null && vision.range() > 0.0) {
                    return true;
                }
                if (VisionConfig.SpecialBlock.TREASURE.get(enchantmentLevel) != null) {
                    return state.m_204336_(AEBlockTags.TREASURES);
                }
                return false;
            });
            if (cachedSection == null) {
                cachedSection = new Boolean[chunk.m_7103_().length];
            }
            cachedSection[sectionIndex] = containsRelevantBlock;
            CHUNK_CACHE.put((Object)section, (Object)cachedSection);
        }
        return cachedSection[sectionIndex];
    }

    private static boolean isOutsideRange(double visibleRange) {
        if (lastScanCenter == null || searchedTooEarly) {
            return true;
        }
        Vec3 currentPosition = Minecraft.m_91087_().f_91074_.m_20182_();
        double halfRange = visibleRange / 2.0;
        return currentPosition.m_82557_(lastScanCenter) > halfRange * halfRange;
    }

    public static void drawLines(VertexConsumer buffer, PoseStack.Pose pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int color) {
        VisionHandler.drawLine(buffer, pose, minX, minY, minZ, maxX, minY, minZ, 1, 0, 0, color);
        VisionHandler.drawLine(buffer, pose, minX, minY, minZ, minX, maxY, minZ, 0, 1, 0, color);
        VisionHandler.drawLine(buffer, pose, minX, minY, minZ, minX, minY, maxZ, 0, 0, 1, color);
        VisionHandler.drawLine(buffer, pose, maxX, minY, minZ, maxX, maxY, minZ, 0, 1, 0, color);
        VisionHandler.drawLine(buffer, pose, maxX, maxY, minZ, minX, maxY, minZ, -1, 0, 0, color);
        VisionHandler.drawLine(buffer, pose, minX, maxY, minZ, minX, maxY, maxZ, 0, 0, 1, color);
        VisionHandler.drawLine(buffer, pose, minX, maxY, maxZ, minX, minY, maxZ, 0, -1, 0, color);
        VisionHandler.drawLine(buffer, pose, minX, minY, maxZ, maxX, minY, maxZ, 1, 0, 0, color);
        VisionHandler.drawLine(buffer, pose, maxX, minY, maxZ, maxX, minY, minZ, 0, 0, -1, color);
        VisionHandler.drawLine(buffer, pose, minX, maxY, maxZ, maxX, maxY, maxZ, 1, 0, 0, color);
        VisionHandler.drawLine(buffer, pose, maxX, minY, maxZ, maxX, maxY, maxZ, 0, 1, 0, color);
        VisionHandler.drawLine(buffer, pose, maxX, maxY, minZ, maxX, maxY, maxZ, 0, 0, 1, color);
    }

    private static void drawLine(VertexConsumer buffer, PoseStack.Pose pose, float fromX, float fromY, float fromZ, float toX, float toY, float toZ, int normalX, int normalY, int normalZ, int color) {
        buffer.m_85982_(pose.m_85861_(), fromX, fromY, fromZ).m_193479_(color).m_85977_(pose.m_85864_(), (float)normalX, (float)normalY, (float)normalZ).m_5752_();
        buffer.m_85982_(pose.m_85861_(), toX, toY, toZ).m_193479_(color).m_85977_(pose.m_85864_(), (float)normalX, (float)normalY, (float)normalZ).m_5752_();
    }

    private static void clear() {
        if (CHUNK_CACHE == null) {
            return;
        }
        RENDER_DATA.clear();
        SHADER_RENDER_DATA.clear();
        SEARCH_RESULT.clear();
        REMOVAL.clear();
        lastScanCenter = null;
        isSearching = false;
        hasPendingUpdate = false;
        CHUNK_CACHE.invalidateAll();
        CHUNK_CACHE = null;
    }

    private static void initCache() {
        if (CHUNK_CACHE == null) {
            CHUNK_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).concurrencyLevel(1).build();
        }
    }

    public record Data(BlockState state, VisionConfig.VisionData visionData, float x, float y, float z) {
        public boolean isInRange(Vec3 position, double visibleRange) {
            return position.m_82531_((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) <= visibleRange * visibleRange;
        }

        public int getColor() {
            return ColorUtils.lerpColor(this.visionData().colorsARGB(), this.visionData().colorShiftRate(), 0.0);
        }
    }
}

