/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.client.block_vision;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.cadentem.additional_enchantments.client.BlockVisionRenderTypes;
import de.cadentem.additional_enchantments.client.VisionHandler;
import de.cadentem.additional_enchantments.compat.ModCheck;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ShaderSimple {
    private static BufferBuilder irisBuffer;
    private static Tesselator irisTesselator;

    public static void render(VisionHandler.Data data, PoseStack pose) {
        ShaderSimple.prepare();
        int colorARGB = data.getColor();
        int alpha = FastColor.ARGB32.m_13655_((int)colorARGB);
        int red = FastColor.ARGB32.m_13665_((int)colorARGB);
        int green = FastColor.ARGB32.m_13667_((int)colorARGB);
        int blue = FastColor.ARGB32.m_13669_((int)colorARGB);
        if (alpha == 0) {
            return;
        }
        BlockPos position = new BlockPos((double)data.x(), (double)data.y(), (double)data.z());
        Level level = (Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        pose.m_85836_();
        Vec3 offset = data.state().m_60824_((BlockGetter)level, position);
        pose.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        PoseStack.Pose lastPose = pose.m_85850_();
        pose.m_85849_();
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(data.state());
        ModelData modelData = model.getModelData((BlockAndTintGetter)level, position, data.state(), ModelData.EMPTY);
        long seed = data.state().m_60726_(position);
        RandomSource random = RandomSource.m_216335_((long)seed);
        for (RenderType type : model.getRenderTypes(data.state(), random, modelData)) {
            RenderType mapped = irisBuffer != null ? type : (type == RenderType.m_110463_() || type == RenderType.m_110457_() ? BlockVisionRenderTypes.blockVisionCutout() : BlockVisionRenderTypes.blockVisionTranslucent());
            BufferBuilder buffer = irisBuffer == null ? Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(mapped) : irisBuffer;
            ShaderSimple.putData((VertexConsumer)buffer, random, seed, model.getQuads(data.state(), null, random, modelData, type), lastPose, red, green, blue, alpha);
            for (Direction direction : Direction.values()) {
                ShaderSimple.putData((VertexConsumer)buffer, random, seed, model.getQuads(data.state(), direction, random, modelData, type), lastPose, red, green, blue, alpha);
            }
        }
    }

    private static void putData(VertexConsumer buffer, RandomSource rand, long seed, List<BakedQuad> model, PoseStack.Pose lastPose, int red, int green, int blue, int alpha) {
        rand.m_188584_(seed);
        for (BakedQuad quad : model) {
            buffer.putBulkData(lastPose, quad, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f, 0xF000F0, OverlayTexture.f_118083_, false);
        }
    }

    public static void beginBatch() {
        if (ModCheck.Mod.IRIS.isLoaded()) {
            irisTesselator = RenderSystem.m_69883_();
            irisBuffer = irisTesselator.m_85915_();
            irisBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        }
    }

    public static void endBatch() {
        ShaderSimple.prepare();
        MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
        source.m_109912_(BlockVisionRenderTypes.blockVisionCutout());
        source.m_109912_(BlockVisionRenderTypes.blockVisionTranslucent());
        if (irisTesselator != null) {
            irisTesselator.m_85914_();
        }
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69863_((float)0.0f, (float)0.0f);
        RenderSystem.m_69469_();
        VisionHandler.getSimpleShader().m_173362_();
        irisTesselator = null;
        irisBuffer = null;
    }

    private static void prepare() {
        RenderSystem.m_157427_(VisionHandler::getSimpleShader);
        VisionHandler.getSimpleShader().m_173348_("ProjMat").m_5679_(RenderSystem.m_157192_());
        VisionHandler.getSimpleShader().m_173348_("ModelViewMat").m_5679_(RenderSystem.m_157190_());
        VisionHandler.getSimpleShader().m_173348_("DepthBias").m_5985_(0.0115f);
        VisionHandler.getSimpleShader().m_173363_();
        if (irisTesselator != null) {
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69481_();
            RenderSystem.m_69486_();
            RenderSystem.m_69863_((float)-1.0f, (float)-1.0f);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
    }
}

