/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.client.block_vision;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.cadentem.additional_enchantments.client.VisionHandler;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ShaderSimpleBlockEntities {
    private static final ResourceLocation FLAT_TEXTURE = new ResourceLocation("additional_enchantments", "white.png");
    private static BufferBuilder buffer;
    private static Tesselator tesselator;

    public static void render(VisionHandler.Data data, PoseStack pose) {
        ShaderSimpleBlockEntities.prepare();
        int colorARGB = data.getColor();
        int alpha = FastColor.ARGB32.m_13655_((int)colorARGB);
        int red = FastColor.ARGB32.m_13665_((int)colorARGB);
        int green = FastColor.ARGB32.m_13667_((int)colorARGB);
        int blue = FastColor.ARGB32.m_13669_((int)colorARGB);
        if (alpha == 0) {
            return;
        }
        BlockPos position = new BlockPos((double)data.x(), (double)data.y(), (double)data.z());
        Level level = (Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        pose.m_85836_();
        Vec3 offset = data.state().m_60824_((BlockGetter)level, position);
        pose.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        PoseStack.Pose lastPose = pose.m_85850_();
        pose.m_85849_();
        AABB box = new AABB((double)data.x(), (double)data.y(), (double)data.z(), (double)(data.x() + 1.0f), (double)(data.y() + 1.0f), (double)(data.z() + 1.0f));
        float minX = (float)(box.f_82288_ - (double)data.x());
        float minY = (float)(box.f_82289_ - (double)data.y());
        float minZ = (float)(box.f_82290_ - (double)data.z());
        float maxX = (float)(box.f_82291_ - (double)data.x());
        float maxY = (float)(box.f_82292_ - (double)data.y());
        float maxZ = (float)(box.f_82293_ - (double)data.z());
        ShaderSimpleBlockEntities.renderAabbQuads(lastPose, minX, minY, minZ, maxX, maxY, maxZ, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    private static void renderAabbQuads(PoseStack.Pose pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float red, float green, float blue, float alpha) {
        ShaderSimpleBlockEntities.quad((VertexConsumer)buffer, pose, minX, minY, maxZ, maxX, minY, maxZ, maxX, maxY, maxZ, minX, maxY, maxZ, red, green, blue, alpha, 0, 0, 1);
        ShaderSimpleBlockEntities.quad((VertexConsumer)buffer, pose, maxX, minY, minZ, minX, minY, minZ, minX, maxY, minZ, maxX, maxY, minZ, red, green, blue, alpha, 0, 0, -1);
        ShaderSimpleBlockEntities.quad((VertexConsumer)buffer, pose, minX, minY, minZ, minX, minY, maxZ, minX, maxY, maxZ, minX, maxY, minZ, red, green, blue, alpha, -1, 0, 0);
        ShaderSimpleBlockEntities.quad((VertexConsumer)buffer, pose, maxX, minY, maxZ, maxX, minY, minZ, maxX, maxY, minZ, maxX, maxY, maxZ, red, green, blue, alpha, 1, 0, 0);
        ShaderSimpleBlockEntities.quad((VertexConsumer)buffer, pose, minX, maxY, maxZ, maxX, maxY, maxZ, maxX, maxY, minZ, minX, maxY, minZ, red, green, blue, alpha, 0, 1, 0);
        ShaderSimpleBlockEntities.quad((VertexConsumer)buffer, pose, minX, minY, minZ, maxX, minY, minZ, maxX, minY, maxZ, minX, minY, maxZ, red, green, blue, alpha, 0, -1, 0);
    }

    private static void quad(VertexConsumer buf, PoseStack.Pose pose, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float red, float green, float blue, float alpha, int nx, int ny, int nz) {
        buf.m_85982_(pose.m_85861_(), x1, y1, z1).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_86008_(OverlayTexture.f_118083_).m_85977_(pose.m_85864_(), (float)nx, (float)ny, (float)nz).m_5752_();
        buf.m_85982_(pose.m_85861_(), x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_86008_(OverlayTexture.f_118083_).m_85977_(pose.m_85864_(), (float)nx, (float)ny, (float)nz).m_5752_();
        buf.m_85982_(pose.m_85861_(), x3, y3, z3).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_86008_(OverlayTexture.f_118083_).m_85977_(pose.m_85864_(), (float)nx, (float)ny, (float)nz).m_5752_();
        buf.m_85982_(pose.m_85861_(), x4, y4, z4).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_86008_(OverlayTexture.f_118083_).m_85977_(pose.m_85864_(), (float)nx, (float)ny, (float)nz).m_5752_();
    }

    public static void beginBatch() {
        tesselator = RenderSystem.m_69883_();
        buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
    }

    public static void endBatch() {
        ShaderSimpleBlockEntities.prepare();
        if (tesselator != null) {
            tesselator.m_85914_();
        }
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69863_((float)0.0f, (float)0.0f);
        RenderSystem.m_69469_();
        VisionHandler.getSimpleShader().m_173362_();
        tesselator = null;
        buffer = null;
    }

    private static void prepare() {
        RenderSystem.m_157427_(VisionHandler::getSimpleShader);
        VisionHandler.getSimpleShader().m_173348_("ProjMat").m_5679_(RenderSystem.m_157192_());
        VisionHandler.getSimpleShader().m_173348_("ModelViewMat").m_5679_(RenderSystem.m_157190_());
        VisionHandler.getSimpleShader().m_173348_("DepthBias").m_5985_(0.0115f);
        VisionHandler.getSimpleShader().m_173363_();
        if (tesselator != null) {
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69481_();
            RenderSystem.m_69486_();
            RenderSystem.m_69863_((float)-1.0f, (float)-1.0f);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)FLAT_TEXTURE);
    }
}

