/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.compat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;

public class ModCheck {
    private static final Map<String, List<String>> ALIAS = Map.of(Mod.IRIS.modid(), List.of("oculus"));
    private static final Map<String, Boolean> MODS = new HashMap<String, Boolean>();

    private static boolean isModLoaded(String mod) {
        return MODS.computeIfAbsent(mod, key -> {
            if (ModCheck.check(key)) {
                return true;
            }
            for (String alias : ALIAS.getOrDefault(key, List.of())) {
                if (!ModCheck.check(alias)) continue;
                return true;
            }
            return false;
        });
    }

    private static boolean check(String modid) {
        ModList modList = ModList.get();
        if (modList != null && modList.isLoaded(modid)) {
            return true;
        }
        return LoadingModList.get().getModFileById(modid) != null;
    }

    public static enum Mod {
        IRIS("iris");

        private final String modid;

        private Mod(String modid) {
            this.modid = modid;
        }

        public String modid() {
            return this.modid;
        }

        public boolean isLoaded() {
            return ModCheck.isModLoaded(this.modid);
        }
    }
}

