/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.config;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import de.cadentem.additional_enchantments.AE;
import de.cadentem.additional_enchantments.client.ClientProxy;
import de.cadentem.additional_enchantments.config.ServerConfig;
import de.cadentem.additional_enchantments.mixin.HolderSet$NamedAccess;
import de.cadentem.additional_enchantments.util.ColorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.jetbrains.annotations.Nullable;

public class VisionConfig {
    public static ForgeConfigSpec.ConfigValue<List<?>> RAW_ENTRIES;
    private static final HashMap<Integer, Double> MAX_RANGE;
    private static Map<ResourceKey<Block>, List<VisionData>> DATA;
    private static Map<SpecialBlock, List<VisionData>> SPECIAL_BLOCK_DATA;
    private static long lastUpdate;
    private static long lastReload;

    @Nullable
    public static VisionData get(Block block, int enchantmentLevel) {
        List<VisionData> entries = DATA.get(block.m_204297_().m_205785_());
        if (entries == null) {
            return null;
        }
        for (VisionData entry : entries) {
            if (!entry.levelBounds().m_55390_(enchantmentLevel)) continue;
            return entry;
        }
        return null;
    }

    public static double getMaxRange(int enchantmentLevel) {
        if (lastUpdate < lastReload) {
            lastUpdate = System.currentTimeMillis();
            MAX_RANGE.clear();
        }
        return MAX_RANGE.computeIfAbsent(enchantmentLevel, key -> {
            double currentRange = 0.0;
            for (List<VisionData> entries : DATA.values()) {
                for (VisionData entry : entries) {
                    if (!entry.levelBounds().m_55390_(enchantmentLevel) || !(entry.range() > currentRange)) continue;
                    currentRange = entry.range();
                }
            }
            return currentRange;
        });
    }

    public static void updateFromReload(TagsUpdatedEvent event) {
        VisionConfig.reload(event.getRegistryAccess());
    }

    public static void updateFromConfig(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() != ServerConfig.SPEC) {
            return;
        }
        Player player = ClientProxy.getLocalPlayer();
        if (player == null) {
            return;
        }
        VisionConfig.reload(player.f_19853_.m_5962_());
    }

    private static void reload(RegistryAccess access) {
        if (!ServerConfig.SPEC.isLoaded()) {
            return;
        }
        VisionConfig.initializeData(access);
    }

    private static void initializeData(RegistryAccess access) {
        HashMap<ResourceKey<Block>, List<VisionData>> newEntries = new HashMap<ResourceKey<Block>, List<VisionData>>();
        HashMap<SpecialBlock, List<VisionData>> newSpecialEntries = new HashMap<SpecialBlock, List<VisionData>>();
        ((List)RAW_ENTRIES.get()).forEach(entry -> {
            ParsedEntry parsed = ParsedEntry.from(entry);
            if (parsed.resource().startsWith("$")) {
                newSpecialEntries.computeIfAbsent(SpecialBlock.fromKey(parsed.resource()), key -> new ArrayList()).add(parsed.data());
            } else if (parsed.resource().startsWith("#")) {
                ResourceLocation resource = new ResourceLocation(parsed.resource().substring(1));
                access.m_175515_(Registry.f_122901_).m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)resource)).ifPresent(tag -> ((HolderSet$NamedAccess)tag).additional_enchantments$contents().forEach(block -> newEntries.computeIfAbsent((ResourceKey)block.m_203543_().orElseThrow(), key -> new ArrayList()).add(parsed.data())));
            } else {
                newEntries.computeIfAbsent(ResourceKey.m_135785_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(parsed.resource())), key -> new ArrayList()).add(parsed.data());
            }
        });
        DATA = newEntries;
        SPECIAL_BLOCK_DATA = newSpecialEntries;
        AE.LOG.debug("Reloaded treasure finder entries:\n - Normal blocks: {}\n - Special blocks: {}", DATA, SPECIAL_BLOCK_DATA);
        lastReload = System.currentTimeMillis();
    }

    static {
        MAX_RANGE = new HashMap();
        DATA = new HashMap<ResourceKey<Block>, List<VisionData>>();
        SPECIAL_BLOCK_DATA = new HashMap<SpecialBlock, List<VisionData>>();
    }

    public record VisionData(DisplayType displayType, double range, List<Integer> colorsARGB, double colorShiftRate, MinMaxBounds.Ints levelBounds) {
    }

    public record ParsedEntry(String resource, int fromLevel, int toLevel, double range, List<Integer> colorsARGB, double colorShiftRate, DisplayType displayType) {
        public VisionData data() {
            MinMaxBounds.Ints levelBounds = this.toLevel > 0 ? MinMaxBounds.Ints.m_154814_((int)this.fromLevel, (int)this.toLevel) : MinMaxBounds.Ints.m_55386_((int)this.fromLevel);
            return new VisionData(this.displayType, this.range, this.colorsARGB, this.colorShiftRate, levelBounds);
        }

        public static ParsedEntry fromConfig(UnmodifiableConfig config) {
            DisplayType displayType;
            String resource = (String)config.get("resource");
            int fromLevel = config.getInt("from_level");
            int toLevel = config.getInt("to_level");
            double range = (Double)config.get("range");
            double colorShiftRate = (Double)config.get("color_shift_rate");
            Object parsedDisplayType = config.get("display_type");
            if (parsedDisplayType instanceof DisplayType) {
                DisplayType type;
                displayType = type = (DisplayType)((Object)parsedDisplayType);
            } else if (parsedDisplayType instanceof String) {
                String string = (String)parsedDisplayType;
                displayType = DisplayType.valueOf(string.toUpperCase());
            } else {
                throw new IllegalArgumentException("Unsupported display type: " + parsedDisplayType.getClass());
            }
            ArrayList<Integer> colors = new ArrayList<Integer>();
            Iterator iterator = config.get("colors");
            if (iterator instanceof List) {
                List list = (List)((Object)iterator);
                for (Object entry : list) {
                    if (entry instanceof UnmodifiableConfig) {
                        UnmodifiableConfig colorConfig = (UnmodifiableConfig)entry;
                        TextColor color = TextColor.m_131268_((String)((String)colorConfig.get("color")));
                        if (color == null) {
                            throw new IllegalArgumentException("Invalid color entry: " + colorConfig.get("color"));
                        }
                        int base = color.m_131265_();
                        double alpha = (Double)colorConfig.get("alpha");
                        colors.add(ColorUtils.withAlpha(base, (float)alpha));
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported color entry type: " + entry.getClass());
                }
            }
            return new ParsedEntry(resource, fromLevel, toLevel, range, colors, colorShiftRate, displayType);
        }

        public static ParsedEntry from(Object value) {
            if (value instanceof UnmodifiableConfig) {
                UnmodifiableConfig config = (UnmodifiableConfig)value;
                return ParsedEntry.fromConfig(config);
            }
            throw new IllegalArgumentException("Unsupported value type: " + value);
        }

        public static boolean validate(Object data) {
            try {
                ParsedEntry vision = ParsedEntry.from(data);
                if (vision.resource().startsWith("$")) {
                    if (SpecialBlock.fromKey(vision.resource()) == null) {
                        AE.LOG.error("Invalid resource: {}", (Object)vision.resource());
                        return false;
                    }
                } else {
                    String resource = vision.resource().startsWith("#") ? vision.resource().substring(1) : vision.resource();
                    if (!ResourceLocation.m_135830_((String)resource)) {
                        AE.LOG.error("Invalid resource: {}", (Object)vision.resource());
                        return false;
                    }
                }
                if (vision.range() < 0.0) {
                    AE.LOG.error("Invalid range: {}", (Object)vision.range());
                    return false;
                }
                if (vision.colorShiftRate() < 0.0) {
                    AE.LOG.error("Invalid color shift rate: {}", (Object)vision.colorShiftRate());
                    return false;
                }
                if (vision.fromLevel() < 0) {
                    AE.LOG.error("Invalid from level: {}", (Object)vision.fromLevel());
                    return false;
                }
                return true;
            }
            catch (Exception exception) {
                AE.LOG.error("Invalid vision entry: {}", data, (Object)exception);
                return false;
            }
        }
    }

    public static enum SpecialBlock {
        TREASURE("$treasure");

        private final String key;

        private SpecialBlock(String key) {
            this.key = key;
        }

        @Nullable
        public static SpecialBlock fromKey(String key) {
            for (SpecialBlock value : SpecialBlock.values()) {
                if (!value.getKey().equals(key)) continue;
                return value;
            }
            return null;
        }

        @Nullable
        public VisionData get(int enchantmentLevel) {
            List<VisionData> entries = SPECIAL_BLOCK_DATA.get((Object)this);
            if (entries == null) {
                return null;
            }
            for (VisionData entry : entries) {
                if (!entry.levelBounds().m_55390_(enchantmentLevel)) continue;
                return entry;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum DisplayType {
        X_RAY_OUTLINE,
        GLOW,
        PARTICLES;

    }
}

