/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.core.loot_modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.data.AEBlockTags;
import de.cadentem.additional_enchantments.enchantments.VoidingEnchantment;
import de.cadentem.additional_enchantments.registry.AEEnchantments;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;

public class VoidingModifier
extends LootModifier {
    public static final String ID = "voiding";
    public static final Codec<VoidingModifier> CODEC = RecordCodecBuilder.create(instance -> LootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, VoidingModifier::new));

    public VoidingModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        int enchantmentLevel;
        Entity entity;
        if (!context.m_78936_(LootContextParams.f_81461_)) {
            return generatedLoot;
        }
        BlockState state = (BlockState)context.m_165124_(LootContextParams.f_81461_);
        ItemStack tool = (ItemStack)context.m_165124_(LootContextParams.f_81463_);
        if (context.m_78936_(LootContextParams.f_81455_) && (entity = (Entity)context.m_165124_(LootContextParams.f_81455_)) instanceof Player) {
            AtomicBoolean shouldSkip = new AtomicBoolean(false);
            PlayerDataProvider.getCapability(entity).ifPresent(data -> shouldSkip.set(data.voidingState == VoidingEnchantment.State.DISABLED));
            if (shouldSkip.get()) {
                return generatedLoot;
            }
        }
        if (state.m_204336_(AEBlockTags.VOIDING) && (enchantmentLevel = tool.getEnchantmentLevel((Enchantment)AEEnchantments.VOIDING.get())) > 0) {
            ITagManager tagManager = ForgeRegistries.BLOCKS.tags();
            if (tagManager != null) {
                ITag entries = tagManager.getTag(AEBlockTags.VOIDING);
                for (int i = 0; i < generatedLoot.size(); ++i) {
                    BlockItem blockItem;
                    Item item = ((ItemStack)generatedLoot.get(i)).m_41720_();
                    if (!(item instanceof BlockItem) || !entries.contains((Object)(blockItem = (BlockItem)item).m_40614_())) continue;
                    generatedLoot.remove(i);
                    --i;
                }
            } else {
                generatedLoot.clear();
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

