/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.enchantments;

import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.capability.ProjectileDataProvider;
import de.cadentem.additional_enchantments.config.ServerConfig;
import de.cadentem.additional_enchantments.core.interfaces.ExplosionAccess;
import de.cadentem.additional_enchantments.enchantments.base.AEEnchantmentCategory;
import de.cadentem.additional_enchantments.enchantments.base.ConfigurableEnchantment;
import de.cadentem.additional_enchantments.registry.AEEnchantments;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class ExplosiveTipEnchantment
extends ConfigurableEnchantment {
    public ExplosiveTipEnchantment() {
        super(Enchantment.Rarity.RARE, AEEnchantmentCategory.RANGED_AND_TRIDENT, EquipmentSlot.MAINHAND, "explosive_tip");
    }

    protected boolean m_5975_(@NotNull Enchantment other) {
        return other != Enchantments.f_44957_ && super.m_5975_(other);
    }

    public static void setEnchantmentLevel(Projectile projectile) {
        LivingEntity livingOwner;
        int level;
        Entity entity = projectile.m_37282_();
        if (entity instanceof LivingEntity && (level = (livingOwner = (LivingEntity)entity).m_21205_().getEnchantmentLevel((Enchantment)AEEnchantments.EXPLOSIVE_TIP.get())) > 0) {
            ProjectileDataProvider.getCapability((Entity)projectile).ifPresent(data -> {
                data.explosiveTipEnchantmentLevel = level;
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void triggerExplosion(ProjectileImpactEvent event) {
        Level level;
        Projectile projectile = event.getProjectile();
        if (event.isCanceled() || !((level = projectile.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ProjectileDataProvider.getCapability((Entity)projectile).ifPresent(projectileData -> {
            if (projectileData.explosiveTipEnchantmentLevel > 0) {
                Entity patt3082$temp = projectile.m_37282_();
                if (!(patt3082$temp instanceof LivingEntity)) {
                    return;
                }
                LivingEntity livingOwner = (LivingEntity)patt3082$temp;
                float radius = Math.max(0.1f, (float)projectileData.explosiveTipEnchantmentLevel * ((Double)ServerConfig.EXPLOSIVE_TIP_RADIUS_MULTIPLIER.get()).floatValue());
                PlayerDataProvider.getCapability((Entity)livingOwner).ifPresent(playerData -> {
                    Explosion explosion = new Explosion((Level)serverLevel, (Entity)projectile, null, null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), radius, false, playerData.explosionType);
                    ((ExplosionAccess)explosion).additional_enchantments$setWasTriggeredByEnchantment(true);
                    if (ForgeEventFactory.onExplosionStart((Level)projectile.m_9236_(), (Explosion)explosion)) {
                        return;
                    }
                    explosion.m_46061_();
                    explosion.m_46075_(true);
                    if (playerData.explosionType == Explosion.BlockInteraction.NONE) {
                        explosion.m_46080_();
                    }
                    for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
                        if (!(serverPlayer.m_20275_(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_()) < 4096.0)) continue;
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverPlayer)));
                    }
                    projectileData.explosiveTipEnchantmentLevel = 0;
                    if (playerData.explosionType == Explosion.BlockInteraction.BREAK && event.getRayTraceResult().m_6662_() == HitResult.Type.BLOCK) {
                        event.setCanceled(true);
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public static void handleExplosion(ExplosionEvent.Detonate event) {
        if (((ExplosionAccess)event.getExplosion()).additional_enchantments$wasTriggeredByEnchantment()) {
            LivingEntity source = event.getExplosion().m_46079_();
            event.getAffectedEntities().removeIf(entity -> {
                if (entity == source) {
                    return true;
                }
                if (entity instanceof ExperienceOrb || entity instanceof ItemEntity) {
                    return true;
                }
                if (source != null) {
                    TamableAnimal animal;
                    if (entity instanceof TamableAnimal && (animal = (TamableAnimal)entity).m_21830_(source)) {
                        return true;
                    }
                    return entity.m_7307_((Entity)source);
                }
                return false;
            });
        }
    }
}

