/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.enchantments;

import com.mojang.datafixers.util.Pair;
import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.client.ClientProxy;
import de.cadentem.additional_enchantments.core.interfaces.LivingEntityAccess;
import de.cadentem.additional_enchantments.data.AEBlockTags;
import de.cadentem.additional_enchantments.enchantments.base.ConfigurableEnchantment;
import de.cadentem.additional_enchantments.registry.AEEnchantments;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HunterEnchantment
extends ConfigurableEnchantment {
    private static final Map<String, Pair<Integer, Integer>> CLIENT_CACHE = new HashMap<String, Pair<Integer, Integer>>();

    public HunterEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR_FEET, EquipmentSlot.FEET, "hunter");
    }

    @SubscribeEvent
    public static void applyEffect(LivingEvent.LivingTickEvent event) {
        Mob mob;
        LivingEntity livingEntity;
        LivingEntity livingEntity2 = event.getEntity();
        if (livingEntity2.m_9236_().m_5776_()) {
            return;
        }
        int enchantmentLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)AEEnchantments.HUNTER.get()), (LivingEntity)livingEntity2);
        if (livingEntity2 instanceof Mob && (livingEntity = (mob = (Mob)livingEntity2).m_5448_()) instanceof Player) {
            Player player = (Player)livingEntity;
            PlayerDataProvider.getCapability((Entity)player).ifPresent(data -> {
                if (data.hasMaxHunterStacks(enchantmentLevel)) {
                    mob.m_6598_(null);
                    mob.m_6710_(null);
                }
            });
        }
        if (livingEntity2 instanceof LivingEntityAccess) {
            LivingEntityAccess access = (LivingEntityAccess)livingEntity2;
            AtomicBoolean invisibilityValid = new AtomicBoolean(false);
            if (enchantmentLevel > 0) {
                if (HunterEnchantment.isBlockHunterRelevant(livingEntity2.m_146900_()) || HunterEnchantment.isBlockHunterRelevant(livingEntity2.m_20075_())) {
                    if (livingEntity2 instanceof Player) {
                        Player player = (Player)livingEntity2;
                        PlayerDataProvider.getCapability((Entity)livingEntity2).ifPresent(data -> {
                            data.increaseHunterStacks(player, enchantmentLevel);
                            data.isOnHunterBlock = true;
                        });
                    }
                    invisibilityValid.set(true);
                    if (!livingEntity2.m_20145_()) {
                        livingEntity2.m_6842_(true);
                        access.additional_enchantments$setWasInvisibilityModified(true);
                    }
                } else if (livingEntity2 instanceof Player) {
                    Player player = (Player)livingEntity2;
                    PlayerDataProvider.getCapability((Entity)player).ifPresent(data -> {
                        data.reduceHunterStacks(player, enchantmentLevel);
                        if (data.hasHunterStacks()) {
                            invisibilityValid.set(true);
                        }
                        data.isOnHunterBlock = false;
                    });
                }
            } else if (livingEntity2 instanceof Player) {
                Player player = (Player)livingEntity2;
                PlayerDataProvider.getCapability((Entity)player).ifPresent(data -> data.clearHunterStacks(player));
            }
            if (!invisibilityValid.get() && access.additional_enchantments$wasInvisibilityModified() && !livingEntity2.m_21023_(MobEffects.f_19609_)) {
                livingEntity2.m_6842_(false);
                access.additional_enchantments$setWasInvisibilityModified(false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void avoidTarget(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getNewTarget();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int enchantmentLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)AEEnchantments.HUNTER.get()), (LivingEntity)player);
            if (enchantmentLevel > 0) {
                PlayerDataProvider.getCapability((Entity)player).ifPresent(data -> {
                    if (data.hasMaxHunterStacks(enchantmentLevel)) {
                        event.setNewTarget(null);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void causeCrit(CriticalHitEvent event) {
        Player player = event.getEntity();
        int enchantmentLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)AEEnchantments.HUNTER.get()), (LivingEntity)player);
        if (enchantmentLevel > 0) {
            PlayerDataProvider.getCapability((Entity)player).ifPresent(data -> {
                if (data.hasMaxHunterStacks(enchantmentLevel)) {
                    event.setDamageModifier(event.getDamageModifier() + (float)enchantmentLevel / 2.0f);
                    event.setResult(Event.Result.ALLOW);
                    data.clearHunterStacks(player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void modifyVisibility(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_9236_().m_5776_()) {
                return;
            }
            if (!player.m_20145_()) {
                return;
            }
            PlayerDataProvider.getCapability((Entity)player).ifPresent(data -> {
                int enchantmentLevel;
                if (!data.isOnHunterBlock && !player.m_21023_(MobEffects.f_19609_) && (enchantmentLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)AEEnchantments.HUNTER.get()), (LivingEntity)player)) > 0) {
                    event.modifyVisibility(event.getVisibilityModifier() + 1.0 - (double)data.getHunterStacks() / (double)HunterEnchantment.getMaxStacks(enchantmentLevel));
                }
            });
        }
    }

    @SubscribeEvent
    public static void removeCacheEntry(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            if (!entity.m_9236_().m_5776_()) {
                return;
            }
            CLIENT_CACHE.remove(entity.m_20149_());
        }
    }

    public static int getClientEnchantmentLevel() {
        return HunterEnchantment.getClientEnchantmentLevel(ClientProxy.getLocalPlayer());
    }

    public static int getClientEnchantmentLevel(Player player) {
        if (player == null) {
            return 0;
        }
        Pair data = CLIENT_CACHE.get(player.m_20149_());
        if (data == null || Mth.m_14040_((int)(player.f_19797_ - (Integer)data.getFirst())) > 20) {
            data = Pair.of((Object)player.f_19797_, (Object)EnchantmentHelper.m_44836_((Enchantment)((Enchantment)AEEnchantments.HUNTER.get()), (LivingEntity)player));
            CLIENT_CACHE.put(player.m_20149_(), (Pair<Integer, Integer>)data);
        }
        return (Integer)data.getSecond();
    }

    public static int getMaxStacks(int enchantmentLevel) {
        return 20 * (3 + Math.max(0, ((HunterEnchantment)((Object)AEEnchantments.HUNTER.get())).m_6586_() - enchantmentLevel));
    }

    public static boolean isBlockHunterRelevant(BlockState state) {
        Material material = state.m_60767_();
        if (material == Material.f_76300_ || material == Material.f_76302_ || material == Material.f_76301_ || material == Material.f_76304_) {
            return true;
        }
        return state.m_204336_(AEBlockTags.HUNTER_RELEVANT);
    }
}

