/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.enchantments;

import com.google.common.collect.Sets;
import de.cadentem.additional_enchantments.capability.EntityDataProvider;
import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.capability.ProjectileData;
import de.cadentem.additional_enchantments.capability.ProjectileDataProvider;
import de.cadentem.additional_enchantments.config.ServerConfig;
import de.cadentem.additional_enchantments.data.AEEffectTags;
import de.cadentem.additional_enchantments.enchantments.base.AEEnchantmentCategory;
import de.cadentem.additional_enchantments.enchantments.base.ConfigurableEnchantment;
import de.cadentem.additional_enchantments.registry.AEEnchantments;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class TippedEnchantment
extends ConfigurableEnchantment {
    public TippedEnchantment() {
        super(Enchantment.Rarity.RARE, AEEnchantmentCategory.RANGED_AND_TRIDENT, EquipmentSlot.MAINHAND, "tipped");
    }

    protected boolean m_5975_(@NotNull Enchantment other) {
        return other != Enchantments.f_44957_ && super.m_5975_(other);
    }

    @SubscribeEvent
    public static void applyEffectsToTarget(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            ProjectileDataProvider.getCapability((Entity)projectile).ifPresent(projectileData -> {
                if (projectileData.hasAddedEffects()) {
                    if (!TippedEnchantment.canApplyEffects(projectileData, event.getEntity())) {
                        return;
                    }
                    for (MobEffectInstance effect : projectileData.addedEffects) {
                        event.getEntity().m_7292_(new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_()));
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void tickCooldown(LivingEvent.LivingTickEvent event) {
        EntityDataProvider.getCapability((Entity)event.getEntity()).ifPresent(entityData -> {
            if (entityData.tippedCooldown > 0) {
                --entityData.tippedCooldown;
            }
        });
    }

    private static boolean canApplyEffects(ProjectileData projectileData, LivingEntity target) {
        if ((Integer)ServerConfig.TIPPED_COOLDOWN.get() == 0) {
            return true;
        }
        return EntityDataProvider.getCapability((Entity)target).map(entityData -> {
            int tippedCooldown = (Integer)ServerConfig.TIPPED_COOLDOWN.get();
            if (((Boolean)ServerConfig.TIPPED_SCALE_COOLDOWN_WITH_LEVEL.get()).booleanValue()) {
                tippedCooldown *= projectileData.tippedEnchantmentLevel;
            }
            if (entityData.tippedCooldown < tippedCooldown) {
                return false;
            }
            entityData.tippedCooldown = tippedCooldown;
            return true;
        }).orElse(true);
    }

    public static void applyEffects(Projectile projectile) {
        LivingEntity livingOwner;
        int level;
        Entity entity = projectile.m_37282_();
        if (entity instanceof LivingEntity && (level = (livingOwner = (LivingEntity)entity).m_21205_().getEnchantmentLevel((Enchantment)AEEnchantments.TIPPED.get())) > 0) {
            ProjectileDataProvider.getCapability((Entity)projectile).ifPresent(projectileData -> {
                if (projectileData.hasAddedEffects()) {
                    return;
                }
                projectileData.addedEffects = Sets.newHashSet();
                projectileData.tippedEnchantmentLevel = level;
                PlayerDataProvider.getCapability((Entity)livingOwner).ifPresent(playerData -> {
                    ITagManager tags = ForgeRegistries.MOB_EFFECTS.tags();
                    if (tags != null) {
                        ArrayList<Object> appliedEffects;
                        ITag blacklist = tags.getTag(AEEffectTags.TIPPED_BLACKLIST);
                        List effects = ForgeRegistries.MOB_EFFECTS.getValues().stream().filter(effect -> !blacklist.contains(effect) && TippedEnchantment.isValidEffect(playerData.effectFilter, effect)).collect(Collectors.toList());
                        if (effects.size() <= level) {
                            appliedEffects = new ArrayList(effects);
                        } else {
                            appliedEffects = new ArrayList();
                            for (int count = 0; count < level; ++count) {
                                MobEffect mobEffect = (MobEffect)effects.get(livingOwner.m_217043_().m_188503_(effects.size()));
                                effects.remove(mobEffect);
                                appliedEffects.add(mobEffect);
                            }
                        }
                        for (MobEffect mobEffect : appliedEffects) {
                            projectileData.addedEffects.add(new MobEffectInstance(mobEffect, mobEffect.m_8093_() ? 1 : (int)(20.0 * ((Double)ServerConfig.TIPPED_DURATION_BASE.get() + (double)level * (Double)ServerConfig.TIPPED_DURATION_MULTIPLIER.get())), level - 1));
                        }
                    }
                });
            });
        }
    }

    private static boolean isValidEffect(MobEffectCategory category, MobEffect effect) {
        if (category == effect.m_19483_()) {
            return true;
        }
        return category == MobEffectCategory.NEUTRAL;
    }
}

