/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.mixin.skinlayers3d;

import com.bawnorton.mixinsquared.TargetHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.client.HunterLayer;
import de.cadentem.additional_enchantments.enchantments.HunterEnchantment;
import dev.tr7zw.skinlayers.api.Mesh;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PlayerRenderer.class}, priority=1500, remap=false)
public abstract class PlayerRenderMixin {
    @TargetHandler(mixin="dev.tr7zw.skinlayers.mixin.PlayerRendererMixin", name="renderHand")
    @Redirect(method={"@MixinSquared:Handler"}, at=@At(value="INVOKE", target="Ldev/tr7zw/skinlayers/api/Mesh;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"))
    private void handleTransparecny(Mesh instance, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, PoseStack methodPoseStack, MultiBufferSource bufferSource, int methodPackedLight, AbstractClientPlayer player) {
        int enchantmentLevel = HunterEnchantment.getClientEnchantmentLevel();
        AtomicBoolean wasRendered = new AtomicBoolean(false);
        if (enchantmentLevel > 0) {
            PlayerDataProvider.getCapability((Entity)player).ifPresent(data -> {
                if (data.hasHunterStacks()) {
                    instance.setVisible(true);
                    int alpha = (int)(HunterLayer.getAlpha(data.getHunterStacks(), enchantmentLevel) * 255.0f) << 24;
                    int color = alpha | 0xFFFFFF;
                    instance.render(null, poseStack, vertexConsumer, packedLight, packedOverlay, color);
                    wasRendered.set(true);
                }
            });
        }
        if (!wasRendered.get()) {
            instance.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        }
    }
}

