/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.network;

import de.cadentem.additional_enchantments.client.ClientProxy;
import de.cadentem.additional_enchantments.client.VisionHandler;
import de.cadentem.additional_enchantments.mixin.client.RandomizableContainerBlockEntityAccess;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record SyncLootTable(ResourceLocation loot, long seed, BlockPos worldPosition) {
    public static final ResourceLocation EMPTY = new ResourceLocation("empty");

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.loot);
        buffer.writeLong(this.seed);
        buffer.m_130064_(this.worldPosition);
    }

    public static SyncLootTable decode(FriendlyByteBuf buffer) {
        return new SyncLootTable(buffer.m_130281_(), buffer.readLong(), buffer.m_130135_());
    }

    public static void handle(SyncLootTable packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> {
                Player player = ClientProxy.getLocalPlayer();
                if (player == null) {
                    return;
                }
                BlockEntity blockEntity = player.f_19853_.m_7702_(packet.worldPosition());
                if (blockEntity instanceof RandomizableContainerBlockEntityAccess) {
                    RandomizableContainerBlockEntityAccess access = (RandomizableContainerBlockEntityAccess)blockEntity;
                    if (packet.loot().equals((Object)EMPTY)) {
                        access.additional_enchantments$setLootTable(null, 0L);
                        VisionHandler.removeTreasure(packet.worldPosition());
                    } else {
                        access.additional_enchantments$setLootTable(packet.loot(), packet.seed());
                        VisionHandler.addTreasure(packet.worldPosition(), blockEntity.m_58900_());
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }
}

