/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.network;

import de.cadentem.additional_enchantments.capability.PlayerDataProvider;
import de.cadentem.additional_enchantments.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record SyncPlayerData(CompoundTag tag) {
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.tag);
    }

    public static SyncPlayerData decode(FriendlyByteBuf buffer) {
        return new SyncPlayerData(buffer.m_130260_());
    }

    public static void handle(SyncPlayerData packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            context.enqueueWork(() -> PlayerDataProvider.getCapability((Entity)context.getSender()).ifPresent(data -> data.deserializeNBT(packet.tag)));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncPlayerData(packet.tag));
        }
        context.setPacketHandled(true);
    }
}

