/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_enchantments.util;

import de.cadentem.additional_enchantments.AE;
import java.util.List;
import net.minecraft.util.FastColor;

public class ColorUtils {
    public static int withAlpha(int rgb, float alpha) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return FastColor.ARGB32.m_13660_((int)((int)(255.0f * Math.max(0.0f, Math.min(1.0f, alpha)))), (int)red, (int)green, (int)blue);
    }

    public static int lerpColor(List<Integer> colorsARGB, double speed, double offset) {
        if (colorsARGB.isEmpty()) {
            return -1;
        }
        if (colorsARGB.size() == 1) {
            return colorsARGB.get(0);
        }
        double timer = ((double)AE.PROXY.getTimer() * speed + offset) % 1.0;
        if (timer < 0.0) {
            timer = 0.0;
        }
        float sizeIndex = (float)(timer * (double)colorsARGB.size());
        int currentIndex = (int)(Math.floor(sizeIndex) % (double)colorsARGB.size());
        int nextIndex = (currentIndex + 1) % colorsARGB.size();
        return ColorUtils.lerp(sizeIndex - (float)currentIndex, colorsARGB.get(currentIndex), colorsARGB.get(nextIndex));
    }

    public static int lerp(float delta, int min, int max) {
        int alpha = ColorUtils.lerpInt(delta, ColorUtils.alpha(min), ColorUtils.alpha(max));
        int red = ColorUtils.lerpInt(delta, ColorUtils.red(min), ColorUtils.red(max));
        int green = ColorUtils.lerpInt(delta, ColorUtils.green(min), ColorUtils.green(max));
        int blue = ColorUtils.lerpInt(delta, ColorUtils.blue(min), ColorUtils.blue(max));
        return ColorUtils.color(alpha, red, green, blue);
    }

    public static int lerpInt(float delta, int start, int end) {
        return start + ColorUtils.floor(delta * (float)(end - start));
    }

    public static int floor(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static int alpha(int argb) {
        return argb >>> 24;
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }

    public static int color(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

