/*
 * Decompiled with CFR 0.152.
 */
package com.slackow.joinautosprintmod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;

public class SprintOptions {
    public boolean autoSprintOnWorldJoin = true;
    public boolean autoSprintOnRespawn = true;
    public boolean changeDefaultToToggleSprint = true;
    private static final String CONFIG = "joinautosprint.json";
    private static SprintOptions options;

    private SprintOptions() {
    }

    public static SprintOptions load(Path configDir) {
        if (configDir == null) {
            configDir = class_310.method_1551().field_1697.toPath().resolve("config");
        }
        if (options != null) {
            return options;
        }
        if (Files.notExists(configDir.resolve(CONFIG), new LinkOption[0])) {
            options = new SprintOptions();
            options.save(configDir);
            SprintOptions.setSprinting();
            return options;
        }
        try {
            options = (SprintOptions)new Gson().fromJson((Reader)Files.newBufferedReader(configDir.resolve(CONFIG)), SprintOptions.class);
        }
        catch (IOException e) {
            System.err.println("Failed to load config file: joinautosprint.json");
            e.printStackTrace(System.err);
            options = new SprintOptions();
        }
        return options;
    }

    public void save(Path configDir) {
        if (configDir == null) {
            configDir = class_310.method_1551().field_1697.toPath().resolve("config");
        }
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.writeString(configDir.resolve(CONFIG), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((Object)options, SprintOptions.class), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save options to " + String.valueOf(configDir.resolve(CONFIG)));
            e.printStackTrace(System.err);
        }
    }

    public boolean anyOn() {
        return this.autoSprintOnWorldJoin || this.autoSprintOnRespawn;
    }

    public static void setSprinting() {
        class_310 instance = class_310.method_1551();
        class_315 options = instance.field_1690;
        if (options == null) {
            return;
        }
        class_304 sprintKey = options.field_1867;
        if (!((Boolean)options.method_42450().method_41753()).booleanValue()) {
            options.method_42450().method_41748((Object)true);
        }
        if (!sprintKey.method_1434()) {
            sprintKey.method_23481(true);
        }
        System.out.println("Set to be sprinting");
    }
}

