/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.custom.clocks;

import net.luckystudio.cozyhome.block.ModBlocks;
import net.luckystudio.cozyhome.block.util.interfaces.ClockBlock;
import net.luckystudio.cozyhome.util.ModSoundEvents;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class ClockFunctionalityHandler {
    public static void handleHandRotations(class_1937 world, class_2338 pos, class_2680 state, ClockBlock blockEntity) {
        boolean isNether;
        boolean bl = isNether = world.method_27983() == class_1937.field_25180;
        if (isNether && !ClockFunctionalityHandler.isNetherClock(state)) {
            class_5819 random = world.method_8409();
            if (blockEntity.getTicks() % 20 == 0) {
                blockEntity.setCurrentHourHandAngle(random.method_43057() * 10.0f - 5.0f);
            }
            blockEntity.setLastHourHandAngle(blockEntity.getCurrentHourHandAngle());
            blockEntity.setCurrentHourHandAngle(ClockFunctionalityHandler.wrapAngle(blockEntity.getCurrentHourHandAngle() + blockEntity.getCurrentHourHandAngle()));
            blockEntity.setLastMinuteHandAngle(blockEntity.getCurrentMinuteHandAngle());
            float targetMinuteHandAngle = ClockFunctionalityHandler.wrapAngle(blockEntity.getCurrentHourHandAngle() * 12.0f);
            blockEntity.setCurrentMinuteHandAngle(ClockFunctionalityHandler.lerpWrappedAngle(blockEntity.getCurrentMinuteHandAngle(), targetMinuteHandAngle));
        } else {
            long worldTime = blockEntity.method_10997().method_8532() % 24000L;
            float hour = (float)worldTime / 1000.0f % 12.0f;
            float minute = (float)(worldTime % 1000L) / 16.6667f;
            blockEntity.setLastHourHandAngle(blockEntity.getCurrentHourHandAngle());
            blockEntity.setCurrentHourHandAngle(ClockFunctionalityHandler.wrapAngle(hour * 30.0f + 180.0f));
            blockEntity.setLastMinuteHandAngle(blockEntity.getCurrentMinuteHandAngle());
            blockEntity.setCurrentMinuteHandAngle(ClockFunctionalityHandler.wrapAngle(minute * 6.0f));
        }
    }

    private static boolean isNetherClock(class_2680 state) {
        return state.method_27852(ModBlocks.CRIMSON_GRANDFATHER_CLOCK) || state.method_27852(ModBlocks.WARPED_GRANDFATHER_CLOCK) || state.method_27852(ModBlocks.CRIMSON_WALL_CLOCK) || state.method_27852(ModBlocks.WARPED_WALL_CLOCK);
    }

    private static float wrapAngle(float angle) {
        return (angle % 360.0f + 360.0f) % 360.0f;
    }

    private static float lerpWrappedAngle(float from, float to) {
        float diff = ClockFunctionalityHandler.wrapAngle(to - from);
        if (diff > 180.0f) {
            diff -= 360.0f;
        }
        if (diff < -180.0f) {
            diff += 360.0f;
        }
        float interpolated = from + diff * 0.2f;
        return ClockFunctionalityHandler.wrapAngle(interpolated);
    }

    public static void handleGrandfatherClock(class_1937 world, class_2338 pos, class_2680 state, ClockBlock blockEntity, float pendulumAmplitude) {
        long worldTime = blockEntity.method_10997().method_8532() % 24000L;
        if (worldTime == 18000L && world.method_8450().method_8355(class_1928.field_19396)) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12522, (Comparable)Boolean.valueOf(true)));
            if (state.method_26204() == ModBlocks.OMINOUS_GRANDFATHER_CLOCK) {
                world.method_8396(null, pos, class_3417.field_48796, class_3419.field_15245, 0.25f, 1.0f);
            }
            world.method_8396(null, pos, ModSoundEvents.GRANDFATHER_CLOCK_MIDNIGHT, class_3419.field_15245, 1.0f, 1.0f);
        }
        if (worldTime == 18360L) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12522, (Comparable)Boolean.valueOf(false)));
            if (state.method_26204() == ModBlocks.OMINOUS_GRANDFATHER_CLOCK) {
                world.method_8396(null, pos, class_3417.field_48800, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        float pendulumCycleDuration = 40.0f;
        blockEntity.setLastPendulumAngle(blockEntity.getCurrentPendulumAngle());
        float pendulumAngle = (float)(Math.sin((double)((float)blockEntity.getTicks() % pendulumCycleDuration / pendulumCycleDuration) * Math.PI * 2.0) * (double)pendulumAmplitude);
        blockEntity.setCurrentPendulumAngle(pendulumAngle);
        if (blockEntity.getLastPendulumAngle() > 0.0f && blockEntity.getCurrentPendulumAngle() <= 0.0f || blockEntity.getLastPendulumAngle() < 0.0f && blockEntity.getCurrentPendulumAngle() >= 0.0f) {
            world.method_8396(null, pos, ModSoundEvents.GRANDFATHER_CLOCK_TICK, class_3419.field_15245, 0.25f, 1.0f);
        }
    }
}

