/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.custom.clocks.wall_clock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import net.luckystudio.cozyhome.block.custom.clocks.wall_clock.WallClockBlockEntity;
import net.luckystudio.cozyhome.block.util.ModBlockEntityTypes;
import net.luckystudio.cozyhome.util.ModScreenTexts;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class WallClockBlock
extends class_2237
implements class_3737 {
    public static final MapCodec<WallClockBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ClockType.CODEC.fieldOf("kind").forGetter(WallClockBlock::getClockType), (App)WallClockBlock.method_54096()).apply((Applicative)instance, WallClockBlock::new));
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 NORTH_SHAPE = WallClockBlock.method_9541((double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0, (double)16.0);
    private static final class_265 EAST_SHAPE = WallClockBlock.method_9541((double)0.0, (double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)14.0);
    private static final class_265 SOUTH_SHAPE = WallClockBlock.method_9541((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)1.0);
    private static final class_265 WEST_SHAPE = WallClockBlock.method_9541((double)15.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private final ClockType type;

    protected MapCodec<? extends WallClockBlock> method_53969() {
        return CODEC;
    }

    public WallClockBlock(ClockType grandfatherClockType, class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.type = grandfatherClockType;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED});
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11043 -> NORTH_SHAPE;
            case class_2350.field_11035 -> SOUTH_SHAPE;
            case class_2350.field_11034 -> EAST_SHAPE;
            case class_2350.field_11039 -> WEST_SHAPE;
            default -> null;
        };
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WallClockBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return WallClockBlock.method_31618(type, ModBlockEntityTypes.WALL_CLOCK_BLOCK_ENTITY, WallClockBlockEntity::tick);
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10093(((class_2350)state.method_11654((class_2769)FACING)).method_10153())).method_51367();
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350[] directions;
        class_2680 blockState = this.method_9564();
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        class_1937 worldView = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        for (class_2350 direction : directions = ctx.method_7718()) {
            class_2350 direction2;
            if (!direction.method_10166().method_10179() || !(blockState = (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)(direction2 = direction.method_10153()))).method_26184((class_4538)worldView, blockPos)) continue;
            return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return null;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10153() == state.method_11654((class_2769)FACING) && !state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236 && player instanceof class_3222) {
            long time = world.method_8532() % 24000L;
            String formattedTime = this.formatInGameTime(time);
            String symbol = time >= 0L && time < 12300L || time > 23850L ? "\u00a76\u2600\u00a7f " : "\u00a79\u263d\u00a7f ";
            player.method_7353((class_2561)class_2561.method_43470((String)(symbol + formattedTime)), true);
        }
        return class_1269.field_5812;
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    private String formatInGameTime(long time) {
        String period;
        int hours = (int)(time / 1000L + 6L) % 24;
        int minutes = (int)(time % 1000L * 60L / 1000L);
        String string = period = hours >= 12 ? "PM" : "AM";
        if ((hours %= 12) == 0) {
            hours = 12;
        }
        return String.format("%02d:%02d %s", hours, minutes, period);
    }

    public ClockType getClockType() {
        return this.type;
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_9568(stack, context, tooltip, type);
        tooltip.add(class_5244.field_39003);
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.interact_with_hand").method_27692(class_124.field_1080));
        tooltip.add((class_2561)ModScreenTexts.entry().method_10852((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.tells_time")));
    }

    public static interface ClockType
    extends class_3542 {
        public static final Map<String, ClockType> TYPES = new Object2ObjectArrayMap();
        public static final Codec<ClockType> CODEC = Codec.stringResolver(class_3542::method_15434, TYPES::get);
    }

    public static enum Type implements ClockType
    {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak"),
        MANGROVE("mangrove"),
        CHERRY("cherry"),
        BAMBOO("bamboo"),
        CRIMSON("crimson"),
        WARPED("warped"),
        PRINCESS("princess"),
        IRON("iron"),
        GLASS("iron"),
        UNDEAD("undead"),
        OMINOUS("ominous");

        private final String id;

        private Type(String id) {
            this.id = id;
            TYPES.put(id, this);
        }

        public String method_15434() {
            return this.id;
        }
    }
}

