/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.custom.fountains;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.luckystudio.cozyhome.block.ModBlocks;
import net.luckystudio.cozyhome.block.custom.fountains.FountainBlock;
import net.luckystudio.cozyhome.block.util.ModBlockUtilities;
import net.luckystudio.cozyhome.block.util.ModProperties;
import net.luckystudio.cozyhome.block.util.enums.ContainsBlock;
import net.luckystudio.cozyhome.util.ModSoundEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class FountainSpoutBlock
extends class_2341 {
    public static final MapCodec<FountainSpoutBlock> CODEC = FountainSpoutBlock.method_54094(FountainSpoutBlock::new);
    public static final class_2754<ContainsBlock> CONTAINS = ModProperties.CONTAINS;
    public static final class_2746 HAS_UNDER = ModProperties.HAS_UNDER;
    protected static final class_265 NORTH_WALL_SHAPE = class_2248.method_9541((double)5.0, (double)10.0, (double)10.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final class_265 SOUTH_WALL_SHAPE = class_2248.method_9541((double)5.0, (double)10.0, (double)0.0, (double)11.0, (double)16.0, (double)6.0);
    protected static final class_265 WEST_WALL_SHAPE = class_2248.method_9541((double)10.0, (double)10.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    protected static final class_265 EAST_WALL_SHAPE = class_2248.method_9541((double)0.0, (double)10.0, (double)5.0, (double)6.0, (double)16.0, (double)11.0);
    protected static final class_265 FLOOR_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    protected static final class_265 CEILING_SHAPE = class_2248.method_9541((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public FountainSpoutBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)HAS_UNDER, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657(CONTAINS, (Comparable)((Object)ContainsBlock.NONE))).method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{CONTAINS, field_11007, field_11177, HAS_UNDER});
        super.method_9515(builder);
    }

    protected MapCodec<? extends class_2341> method_53969() {
        return CODEC;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2738)state.method_11654((class_2769)field_11007)) {
            case class_2738.field_12471 -> {
                switch ((class_2350)state.method_11654((class_2769)field_11177)) {
                    case field_11034: {
                        yield EAST_WALL_SHAPE;
                    }
                    case field_11039: {
                        yield WEST_WALL_SHAPE;
                    }
                    case field_11035: {
                        yield SOUTH_WALL_SHAPE;
                    }
                }
                yield NORTH_WALL_SHAPE;
            }
            case class_2738.field_12473 -> CEILING_SHAPE;
            default -> FLOOR_SHAPE;
        };
    }

    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        world.method_8501(pos, (class_2680)((class_2680)state.method_11657(CONTAINS, (Comparable)((Object)this.determineContains(state, (class_1936)world, pos)))).method_11657((class_2769)HAS_UNDER, (Comparable)Boolean.valueOf(this.hasUnder(state, (class_1936)world, pos))));
        world.method_39279(pos, (class_2248)this, 10);
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return FountainSpoutBlock.canStay(world, pos, FountainSpoutBlock.method_10119((class_2680)state).method_10153());
    }

    public static boolean canStay(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction);
        return world.method_8320(blockPos).method_26204() == class_2246.field_27097 || world.method_8320(blockPos).method_26204() == class_2246.field_27098 || world.method_8320(blockPos).method_26204() == class_2246.field_10593 || world.method_8320(blockPos).method_26206((class_1922)world, blockPos, direction.method_10153()) || world.method_8320(blockPos).method_26204() instanceof FountainBlock;
    }

    private void elongate(class_1937 world, class_2338 pos) {
        if (world.method_8320(pos.method_10074()).method_26204() == class_2246.field_10124) {
            world.method_8501(pos.method_10074(), ModBlocks.FALLING_LIQUID.method_9564());
        }
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        world.method_39279(pos, (class_2248)this, 20);
        if (FountainSpoutBlock.method_10119((class_2680)state).method_10153() == direction && !state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return (class_2680)((class_2680)state.method_11657(CONTAINS, (Comparable)((Object)this.determineContains(state, world, pos)))).method_11657((class_2769)HAS_UNDER, (Comparable)Boolean.valueOf(this.hasUnder(state, world, pos)));
    }

    private ContainsBlock determineContains(class_2680 state, class_1936 world, class_2338 pos) {
        class_2338 targetPos = pos.method_10093(FountainSpoutBlock.method_10119((class_2680)state).method_10153());
        class_2680 targetState = world.method_8320(targetPos);
        class_2746 property = class_2741.field_12508;
        if (this.isFountainBlock(targetState)) {
            if (targetState.method_11654(CONTAINS) == ContainsBlock.WATER) {
                return ContainsBlock.WATER;
            }
            if (targetState.method_11654(CONTAINS) == ContainsBlock.LAVA) {
                return ContainsBlock.LAVA;
            }
        } else if (targetState.method_28498((class_2769)property)) {
            if (((Boolean)targetState.method_11654((class_2769)property)).booleanValue()) {
                return ContainsBlock.WATER;
            }
        } else {
            if (targetState.method_26204() == class_2246.field_27097) {
                return ContainsBlock.WATER;
            }
            if (targetState.method_26204() == class_2246.field_27098) {
                return ContainsBlock.LAVA;
            }
        }
        return ContainsBlock.NONE;
    }

    private boolean isFountainBlock(class_2680 targetState) {
        return targetState.method_26204() instanceof FountainBlock;
    }

    private boolean hasUnder(class_2680 state, class_1936 world, class_2338 pos) {
        class_2338 posBelow = pos.method_10074();
        class_2680 blockStateBelow = world.method_8320(posBelow);
        return state.method_11654((class_2769)field_11007) != class_2738.field_12475 && (blockStateBelow.method_26206((class_1922)world, pos, class_2350.field_11036) || blockStateBelow.method_26204() instanceof FountainBlock);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        ContainsBlock contents = (ContainsBlock)((Object)state.method_11654(CONTAINS));
        boolean isFloor = state.method_11654((class_2769)field_11007) == class_2738.field_12475;
        boolean hasUnder = (Boolean)state.method_11654((class_2769)HAS_UNDER);
        double x = (double)pos.method_10263() + 0.5;
        double y = (double)pos.method_10264() + 0.1;
        double z = (double)pos.method_10260() + 0.5;
        if (isFloor) {
            switch (contents) {
                case LAVA: {
                    world.method_8466((class_2394)class_2398.field_11239, false, x, y, z, 0.0, 0.0, 0.0);
                    break;
                }
                case WATER: {
                    world.method_8466((class_2394)class_2398.field_11204, false, x, y, z, 0.0, 0.1, 0.0);
                    world.method_8466((class_2394)class_2398.field_11202, false, x, (double)pos.method_10264() + 2.1, z, 0.0, 0.1, 0.0);
                }
            }
        } else if (hasUnder) {
            switch (contents) {
                case LAVA: {
                    world.method_8466((class_2394)class_2398.field_11251, false, x, y, z, 0.0, 0.0, 0.0);
                    break;
                }
                case WATER: {
                    world.method_8396(null, pos, ModSoundEvents.LIGHT_WATER_FLOW, class_3419.field_15256, 0.1f, 1.0f);
                    world.method_8466((class_2394)class_2398.field_11204, false, x, y, z, 0.0, 0.0, 0.0);
                    world.method_8466((class_2394)class_2398.field_11202, false, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2338 posBehind = pos.method_10093(FountainSpoutBlock.method_10119((class_2680)state).method_10153());
        class_2680 stateBehind = world.method_8320(posBehind);
        class_2338 posBelow = pos.method_10074();
        class_2680 stateBelow = world.method_8320(posBelow);
        ContainsBlock contains = (ContainsBlock)((Object)state.method_11654(CONTAINS));
        if (contains != ContainsBlock.NONE && this.canPullLiquid(stateBehind) && this.canPourLiquidBelow(stateBelow)) {
            if (stateBelow.method_26204() instanceof FountainBlock) {
                world.method_8652(posBelow, (class_2680)stateBelow.method_11657(CONTAINS, (Comparable)((Object)contains)), 3);
            } else if (stateBelow.method_27852(class_2246.field_10593)) {
                class_2680 filledCauldron = contains == ContainsBlock.WATER ? (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_2741.field_12513, (Comparable)Integer.valueOf(3)) : class_2246.field_27098.method_9564();
                world.method_8652(posBelow, filledCauldron, 3);
            }
            if (stateBehind.method_26204() instanceof FountainBlock) {
                world.method_8652(posBehind, (class_2680)stateBehind.method_11657(CONTAINS, (Comparable)((Object)ContainsBlock.NONE)), 3);
            } else if (stateBehind.method_27852(class_2246.field_27097) || stateBehind.method_27852(class_2246.field_27098)) {
                world.method_8652(posBehind, class_2246.field_10593.method_9564(), 3);
            }
        } else if (!ModBlockUtilities.isEntityObstructing((class_1937)world, pos) && ModBlockUtilities.canPlaceBelow((class_1937)world, pos) && contains != ContainsBlock.NONE) {
            this.elongate((class_1937)world, pos);
        }
    }

    private boolean canPullLiquid(class_2680 state) {
        class_2248 block = state.method_26204();
        return block instanceof FountainBlock || block == class_2246.field_27097 && (Integer)state.method_11654((class_2769)class_2741.field_12513) == 3 || block == class_2246.field_27098;
    }

    private boolean canPourLiquidBelow(class_2680 state) {
        class_2248 block = state.method_26204();
        return block instanceof FountainBlock && state.method_11654(CONTAINS) == ContainsBlock.NONE || block == class_2246.field_10593;
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!(entity instanceof class_1309) || entity.method_55667().method_27852((class_2248)this)) {
            if (state.method_11654(CONTAINS) == ContainsBlock.WATER && entity.method_5809()) {
                entity.method_46395();
            }
            if (state.method_11654(CONTAINS) == ContainsBlock.LAVA) {
                entity.method_5643(world.method_48963().method_48817(), 4.0f);
                entity.method_5639(3.0f);
            }
        }
        super.method_9548(state, world, pos, entity);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.pours_liquid_from_liquid_holding_blocks_into_others").method_27692(class_124.field_1080));
    }
}

