/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.custom.seatable.chairs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.luckystudio.cozyhome.block.custom.AbstractSeatBlock;
import net.luckystudio.cozyhome.block.custom.seatable.chairs.ChairBlockEntity;
import net.luckystudio.cozyhome.block.util.ModProperties;
import net.luckystudio.cozyhome.block.util.interfaces.TuckableBlock;
import net.luckystudio.cozyhome.item.ModItems;
import net.luckystudio.cozyhome.item.custom.CushionItem;
import net.luckystudio.cozyhome.util.ModScreenTexts;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7718;
import net.minecraft.class_9062;

public class ChairBlock
extends AbstractSeatBlock
implements TuckableBlock,
class_3737 {
    public static final MapCodec<ChairBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChairType.CODEC.fieldOf("kind").forGetter(ChairBlock::getChairType), (App)ChairBlock.method_54096()).apply((Applicative)instance, ChairBlock::new));
    public static final class_2746 TUCKED = ModProperties.TUCKED;
    public static final class_2758 ROTATION = class_2741.field_12532;
    private static final class_265 BASE_SHAPE = ChairBlock.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    public static final class_265 TUCKED_SOUTH = class_259.method_1084((class_265)class_2248.method_9541((double)2.0, (double)0.0, (double)-8.0, (double)14.0, (double)10.0, (double)4.0), (class_265)class_2248.method_9541((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)24.0, (double)4.0));
    public static final class_265 TUCKED_WEST = class_259.method_1084((class_265)class_2248.method_9541((double)12.0, (double)0.0, (double)2.0, (double)24.0, (double)10.0, (double)14.0), (class_265)class_2248.method_9541((double)12.0, (double)10.0, (double)2.0, (double)14.0, (double)24.0, (double)14.0));
    public static final class_265 TUCKED_NORTH = class_259.method_1084((class_265)class_2248.method_9541((double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)10.0, (double)24.0), (class_265)class_2248.method_9541((double)2.0, (double)10.0, (double)12.0, (double)14.0, (double)24.0, (double)14.0));
    public static final class_265 TUCKED_EAST = class_259.method_1084((class_265)class_2248.method_9541((double)-8.0, (double)0.0, (double)2.0, (double)4.0, (double)10.0, (double)14.0), (class_265)class_2248.method_9541((double)2.0, (double)10.0, (double)2.0, (double)4.0, (double)24.0, (double)14.0));
    private final ChairType type;

    public ChairBlock(ChairType chairType, class_4970.class_2251 settings) {
        super(settings);
        ((class_2680)this.method_9564().method_11657((class_2769)TUCKED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(0));
        this.type = chairType;
    }

    protected MapCodec<? extends AbstractSeatBlock> method_53969() {
        return CODEC;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{TUCKED, ROTATION});
    }

    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        Integer n = (Integer)state.method_11654((class_2769)ROTATION);
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{0, 4, 8, 12}, (Object)n, n2)) {
            case 0: {
                if (((Boolean)state.method_11654((class_2769)TUCKED)).booleanValue()) {
                    return TUCKED_SOUTH;
                }
            }
            case 1: {
                if (((Boolean)state.method_11654((class_2769)TUCKED)).booleanValue()) {
                    return TUCKED_WEST;
                }
            }
            case 2: {
                if (((Boolean)state.method_11654((class_2769)TUCKED)).booleanValue()) {
                    return TUCKED_NORTH;
                }
            }
            case 3: {
                if (!((Boolean)state.method_11654((class_2769)TUCKED)).booleanValue()) break;
                return TUCKED_EAST;
            }
        }
        return BASE_SHAPE;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        boolean isSneaking = Objects.requireNonNull(ctx.method_8036()).method_5715();
        int rotationOffset = isSneaking ? 180 : 0;
        return (class_2680)((class_2680)Objects.requireNonNull(super.method_9605(ctx)).method_11657((class_2769)TUCKED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(class_7718.method_45479((float)(ctx.method_8044() + (float)rotationOffset))));
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_9062.field_47728;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ChairBlockEntity) {
            ChairBlockEntity chairBlockEntity = (ChairBlockEntity)class_25862;
            class_1799 storedItem = chairBlockEntity.method_54079();
            if (stack.method_7909() instanceof CushionItem && !stack.method_7960() && storedItem.method_7960()) {
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                class_1799 itemStack2 = stack.method_60504(1, (class_1309)player);
                if (chairBlockEntity.method_5442()) {
                    chairBlockEntity.method_54077(itemStack2);
                }
                if (chairBlockEntity.method_54079() == ModItems.HAY_CUSHION.method_7854()) {
                    world.method_8396(player, pos, class_3417.field_14653, class_3419.field_15245, 1.0f, 1.0f);
                } else {
                    world.method_8396(player, pos, class_3417.field_15226, class_3419.field_15245, 1.0f, 1.0f);
                }
                chairBlockEntity.method_5431();
                world.method_8413(pos, state, state, 3);
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                return class_9062.field_47728;
            }
            if (!chairBlockEntity.method_5442() && stack.method_7909() == class_1802.field_8868) {
                class_1799 storedStack = chairBlockEntity.method_54079();
                class_1799 itemToGive = storedStack.method_7972();
                if (player.method_31548().method_7394(itemToGive)) {
                    storedStack.method_7934(1);
                    if (storedStack.method_7960()) {
                        chairBlockEntity.method_54077(class_1799.field_8037);
                    }
                    world.method_8396(player, pos, class_3417.field_14975, class_3419.field_15245, 1.0f, 1.0f);
                    chairBlockEntity.method_5431();
                    world.method_8413(pos, state, state, 3);
                    world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                    return class_9062.field_47728;
                }
            } else {
                if (player.method_5715()) {
                    TuckableBlock.toggleTuck(state, world, pos, player);
                    return class_9062.field_47728;
                }
                return super.method_55765(stack, state, world, pos, player, hand, hit);
            }
        }
        return class_9062.field_47731;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        if (player.method_5715() || ((Boolean)state.method_11654((class_2769)TUCKED)).booleanValue()) {
            TuckableBlock.toggleTuck(state, world, pos, player);
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    public ChairType getChairType() {
        return this.type;
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_9568(stack, context, tooltip, type);
        tooltip.add(class_5244.field_39003);
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.interact_with_hand_while_sneaking").method_27692(class_124.field_1080));
        tooltip.add((class_2561)ModScreenTexts.entry().method_10852((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.can_tuck_into_certain_blocks")));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.interact_with_cushion").method_27692(class_124.field_1080));
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public float getSeatHeight(class_2680 state) {
        return 0.65f;
    }

    @Override
    public float getSeatRotation(class_2680 state, class_1937 world, class_2338 pos) {
        return ModProperties.setSeatRotationFromRotation(state);
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation.method_10502(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(mirror.method_10344(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), MAX_ROTATIONS)));
    }

    public static interface ChairType
    extends class_3542 {
        public static final Map<String, ChairType> TYPES = new Object2ObjectArrayMap();
        public static final Codec<ChairType> CODEC = Codec.stringResolver(class_3542::method_15434, TYPES::get);
    }

    public static enum Type implements ChairType
    {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak"),
        MANGROVE("mangrove"),
        CHERRY("cherry"),
        BAMBOO("bamboo"),
        CRIMSON("crimson"),
        WARPED("warped"),
        PRINCESS("princess"),
        IRON("iron"),
        GLASS("iron"),
        UNDEAD("undead"),
        OMINOUS("ominous");

        private final String id;

        private Type(String id) {
            this.id = id;
            TYPES.put(id, this);
        }

        public String method_15434() {
            return this.id;
        }
    }
}

