/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.custom.seatable.chairs;

import com.google.common.collect.Maps;
import java.util.Map;
import net.luckystudio.cozyhome.block.custom.seatable.chairs.ChairBlock;
import net.luckystudio.cozyhome.block.custom.seatable.chairs.ChairBlockEntity;
import net.luckystudio.cozyhome.block.util.ModProperties;
import net.luckystudio.cozyhome.client.ModEntityModelLayers;
import net.luckystudio.cozyhome.item.ModItems;
import net.luckystudio.cozyhome.item.custom.CushionItem;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_9282;

public class ChairBlockEntityRenderer
implements class_827<ChairBlockEntity> {
    private final class_630 chair;
    private final class_630 cushion;
    private static final Map<ChairBlock.ChairType, class_2960> CHAIR_TEXTURES = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(ChairBlock.Type.OAK, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/oak_chair.png"));
        map.put(ChairBlock.Type.SPRUCE, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/spruce_chair.png"));
        map.put(ChairBlock.Type.BIRCH, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/birch_chair.png"));
        map.put(ChairBlock.Type.JUNGLE, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/jungle_chair.png"));
        map.put(ChairBlock.Type.ACACIA, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/acacia_chair.png"));
        map.put(ChairBlock.Type.DARK_OAK, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/dark_oak_chair.png"));
        map.put(ChairBlock.Type.MANGROVE, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/mangrove_chair.png"));
        map.put(ChairBlock.Type.CHERRY, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/cherry_chair.png"));
        map.put(ChairBlock.Type.BAMBOO, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/bamboo_chair.png"));
        map.put(ChairBlock.Type.CRIMSON, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/crimson_chair.png"));
        map.put(ChairBlock.Type.WARPED, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/warped_chair.png"));
        map.put(ChairBlock.Type.PRINCESS, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/princess_chair.png"));
        map.put(ChairBlock.Type.IRON, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/iron_chair.png"));
        map.put(ChairBlock.Type.GLASS, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/glass_chair.png"));
        map.put(ChairBlock.Type.UNDEAD, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/undead_chair.png"));
        map.put(ChairBlock.Type.OMINOUS, class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/ominous_chair_inactive.png"));
    });
    private static final Map<class_1792, class_2960> CUSHION_TEXTURES = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(ModItems.CUSHION, class_2960.method_60655((String)"cozyhome", (String)"textures/block/cushion/cushion.png"));
        map.put(ModItems.HAY_CUSHION, class_2960.method_60655((String)"cozyhome", (String)"textures/block/cushion/hay_cushion.png"));
        map.put(ModItems.TRADER_CUSHION, class_2960.method_60655((String)"cozyhome", (String)"textures/block/cushion/trader_cushion.png"));
    });

    public int method_33893() {
        return 64;
    }

    public ChairBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.chair = ctx.method_32140(ModEntityModelLayers.CHAIR);
        this.cushion = ctx.method_32140(ModEntityModelLayers.CUSHION);
    }

    public void render(ChairBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        this.handleSlide(entity, tickDelta);
        if (this.canTuck(entity)) {
            this.getLocationForTuck(entity, matrices);
        } else {
            matrices.method_22904(0.5, 1.5, 0.5);
        }
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(ModProperties.setSeatRotationFromRotation(entity.method_11010())));
        class_2680 blockState = entity.method_11010();
        ChairBlock.ChairType chairType = ((ChairBlock)blockState.method_26204()).getChairType();
        class_1921 chairRenderLayer = ChairBlockEntityRenderer.getChairRenderLayer(chairType, blockState);
        class_4588 chairVertexConsumer = vertexConsumers.getBuffer(chairRenderLayer);
        this.chair.method_22698(matrices, chairVertexConsumer, light, overlay);
        if (!entity.method_5442() && entity.method_54079().method_7909() instanceof CushionItem) {
            class_1792 item = entity.method_54079().method_7909();
            int color = class_9282.method_57470((class_1799)entity.method_54079(), (int)-17170434);
            class_1921 cushionRenderLayer = ChairBlockEntityRenderer.getCushionRenderLayer(item);
            class_4588 cushionVertexConsumer = vertexConsumers.getBuffer(cushionRenderLayer);
            this.cushion.method_22699(matrices, cushionVertexConsumer, light, overlay, color);
        }
        matrices.method_22909();
    }

    private boolean canTuck(ChairBlockEntity entity) {
        int rot = (Integer)entity.method_11010().method_11654((class_2769)ChairBlock.ROTATION);
        return rot == 0 || rot == 4 || rot == 8 || rot == 12;
    }

    private void handleSlide(ChairBlockEntity entity, float tickDelta) {
        entity.currentOffset = (Boolean)entity.method_11010().method_11654((class_2769)ChairBlock.TUCKED) != false ? Math.min(entity.currentOffset + 0.1f * tickDelta, 0.625f) : Math.max(entity.currentOffset - 0.1f * tickDelta, 0.0f);
    }

    private void getLocationForTuck(ChairBlockEntity entity, class_4587 matrices) {
        if ((Integer)entity.method_11010().method_11654((class_2769)ChairBlock.ROTATION) == 0) {
            matrices.method_22904(0.5, 1.5, 0.5 - (double)entity.currentOffset);
        }
        if ((Integer)entity.method_11010().method_11654((class_2769)ChairBlock.ROTATION) == 4) {
            matrices.method_22904(0.5 + (double)entity.currentOffset, 1.5, 0.5);
        }
        if ((Integer)entity.method_11010().method_11654((class_2769)ChairBlock.ROTATION) == 8) {
            matrices.method_22904(0.5, 1.5, 0.5 + (double)entity.currentOffset);
        }
        if ((Integer)entity.method_11010().method_11654((class_2769)ChairBlock.ROTATION) == 12) {
            matrices.method_22904(0.5 - (double)entity.currentOffset, 1.5, 0.5);
        }
    }

    public static class_1921 getChairRenderLayer(ChairBlock.ChairType type, class_2680 blockState) {
        class_2960 identifier = type == ChairBlock.Type.OMINOUS ? (((Boolean)blockState.method_11654((class_2769)class_2741.field_12522)).booleanValue() ? class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/ominous_chair_active.png") : class_2960.method_60655((String)"cozyhome", (String)"textures/block/chair/ominous_chair_inactive.png")) : CHAIR_TEXTURES.get(type);
        return class_1921.method_28116((class_2960)identifier);
    }

    public static class_1921 getCushionRenderLayer(class_1792 item) {
        class_2960 identifier = CUSHION_TEXTURES.get(item);
        return class_1921.method_28116((class_2960)identifier);
    }
}

