/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.custom.water_holding_blocks.bathtub;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.luckystudio.cozyhome.block.custom.water_holding_blocks.AbstractWaterHoldingBlockEntity;
import net.luckystudio.cozyhome.block.custom.water_holding_blocks.bathtub.BathTubBlockEntity;
import net.luckystudio.cozyhome.block.util.ModBlockEntityTypes;
import net.luckystudio.cozyhome.block.util.ModProperties;
import net.luckystudio.cozyhome.block.util.enums.ContainsBlock;
import net.luckystudio.cozyhome.block.util.enums.DoubleLongPart;
import net.luckystudio.cozyhome.block.util.interfaces.SeatBlock;
import net.luckystudio.cozyhome.block.util.interfaces.WaterHoldingBlock;
import net.luckystudio.cozyhome.util.ModScreenTexts;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5328;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class BathTubBlock
extends class_2237
implements class_3737,
SeatBlock,
WaterHoldingBlock {
    public static final MapCodec<BathTubBlock> CODEC = BathTubBlock.method_54094(BathTubBlock::new);
    public static final class_2746 TRIGGERED = class_2741.field_12522;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<ContainsBlock> CONTAINS = ModProperties.CONTAINS;
    public static final class_2754<DoubleLongPart> PART = ModProperties.DOUBLE_LONG_PART;
    public static final class_2758 LEVEL = ModProperties.FILLED_LEVEL_0_2;
    private static final class_265[] SHAPES = new class_265[8];

    public BathTubBlock(class_4970.class_2251 settings) {
        super(settings);
        this.generateShapes();
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)super.method_9564().method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(CONTAINS, (Comparable)((Object)ContainsBlock.NONE))).method_11657(PART, (Comparable)((Object)DoubleLongPart.FRONT))).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BathTubBlockEntity(pos, state);
    }

    protected MapCodec<BathTubBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(new class_2769[]{TRIGGERED, WATERLOGGED, FACING, CONTAINS, PART, LEVEL}));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPES[BathTubBlock.getShapeIndex((class_2350)state.method_11654((class_2769)FACING), (DoubleLongPart)((Object)state.method_11654(PART)))];
    }

    private static int getShapeIndex(class_2350 facing, DoubleLongPart part) {
        return facing.method_10161() + (part == DoubleLongPart.BACK ? 4 : 0);
    }

    private void generateShapes() {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            for (DoubleLongPart part : DoubleLongPart.values()) {
                BathTubBlock.SHAPES[BathTubBlock.getShapeIndex((class_2350)direction, (DoubleLongPart)part)] = this.createShape(direction, part);
            }
        }
    }

    private class_265 createShape(class_2350 facing, DoubleLongPart part) {
        boolean front = part == DoubleLongPart.FRONT;
        class_265 topShape = class_2248.method_9541((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        boolean minX = true;
        int maxX = 15;
        boolean minZ = true;
        int maxZ = 15;
        switch (facing) {
            case field_11039: {
                if (front) {
                    minX = false;
                    break;
                }
                maxX = 16;
                break;
            }
            case field_11034: {
                if (front) {
                    maxX = 16;
                    break;
                }
                minX = false;
                break;
            }
            case field_11043: {
                if (front) {
                    minZ = false;
                    break;
                }
                maxZ = 16;
                break;
            }
            case field_11035: {
                if (front) {
                    maxZ = 16;
                    break;
                }
                minZ = false;
            }
        }
        class_265 baseShape = class_259.method_1084((class_265)topShape, (class_265)class_2248.method_9541((double)((double)minX), (double)1.0, (double)((double)minZ), (double)maxX, (double)10.0, (double)maxZ));
        int holeMinX = 2;
        int holeMaxX = 14;
        int holeMinZ = 2;
        int holeMaxZ = 14;
        switch (facing) {
            case field_11039: {
                if (front) {
                    holeMinX = 0;
                    break;
                }
                holeMaxX = 16;
                break;
            }
            case field_11034: {
                if (front) {
                    holeMaxX = 16;
                    break;
                }
                holeMinX = 0;
                break;
            }
            case field_11043: {
                if (front) {
                    holeMinZ = 0;
                    break;
                }
                holeMaxZ = 16;
                break;
            }
            case field_11035: {
                if (front) {
                    holeMaxZ = 16;
                    break;
                }
                holeMinZ = 0;
            }
        }
        class_265 holeShape = class_2248.method_9541((double)holeMinX, (double)2.0, (double)holeMinZ, (double)holeMaxX, (double)12.0, (double)holeMaxZ);
        return class_259.method_1082((class_265)baseShape, (class_265)holeShape, (class_247)class_247.field_16886);
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == BathTubBlock.getDirectionTowardsOtherPart((DoubleLongPart)((Object)state.method_11654(PART)), (class_2350)state.method_11654((class_2769)FACING))) {
            return neighborState.method_27852((class_2248)this) && neighborState.method_11654(PART) != state.method_11654(PART) ? state : class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    private static class_2350 getDirectionTowardsOtherPart(DoubleLongPart part, class_2350 direction) {
        return part == DoubleLongPart.FRONT ? direction : direction.method_10153();
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1792 item = stack.method_7909();
        ContainsBlock contents = (ContainsBlock)((Object)state.method_11654(CONTAINS));
        int level = (Integer)state.method_11654((class_2769)LEVEL);
        if (player.method_21823()) {
            class_2680 stateToRun = state.method_11654(PART) == DoubleLongPart.BACK ? state : BathTubBlock.getOtherPartState(state, world, pos);
            class_2338 posToRun = state.method_11654(PART) == DoubleLongPart.BACK ? pos : BathTubBlock.getOtherPartPos(state, pos);
            return WaterHoldingBlock.toggleSwitch(stateToRun, world, posToRun, player);
        }
        if (WaterHoldingBlock.trySoup(item, world, pos, player, hand, contents)) {
            return class_9062.field_47728;
        }
        if (item == class_1802.field_8550 && level >= 1) {
            class_1799 filledBucket = contents == ContainsBlock.WATER ? new class_1799((class_1935)class_1802.field_8705) : new class_1799((class_1935)class_1802.field_8187);
            class_3414 soundEvent = contents == ContainsBlock.WATER ? class_3417.field_15126 : class_3417.field_15202;
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)filledBucket));
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            if (level - 1 == 0) {
                world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0))).method_11657(CONTAINS, (Comparable)((Object)ContainsBlock.NONE)), 3);
                world.method_8652(BathTubBlock.getOtherPartPos(state, pos), (class_2680)((class_2680)BathTubBlock.getOtherPartState(state, world, pos).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0))).method_11657(CONTAINS, (Comparable)((Object)ContainsBlock.NONE)), 3);
            } else {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(level - 1)), 3);
                world.method_8652(BathTubBlock.getOtherPartPos(state, pos), (class_2680)BathTubBlock.getOtherPartState(state, world, pos).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(level - 1)), 3);
            }
            world.method_33596(null, (class_6880)class_5712.field_28167, pos);
            return class_9062.field_47728;
        }
        if ((item == class_1802.field_8705 || item == class_1802.field_8187) && level < 2) {
            ContainsBlock newContents;
            ContainsBlock containsBlock = newContents = item == class_1802.field_8705 ? ContainsBlock.WATER : ContainsBlock.LAVA;
            if (contents != ContainsBlock.NONE && contents != newContents) {
                return SeatBlock.sitDown(state, world, pos, player);
            }
            class_3414 soundEvent = newContents == ContainsBlock.WATER ? class_3417.field_14834 : class_3417.field_15010;
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8550)));
            player.method_7281(class_3468.field_15430);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(level + 1))).method_11657(CONTAINS, (Comparable)((Object)newContents)), 3);
            world.method_8652(BathTubBlock.getOtherPartPos(state, pos), (class_2680)((class_2680)BathTubBlock.getOtherPartState(state, world, pos).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(level + 1))).method_11657(CONTAINS, (Comparable)((Object)newContents)), 3);
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, (class_6880)class_5712.field_28166, pos);
            return class_9062.field_47728;
        }
        return SeatBlock.sitDown(state, world, pos, player);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return state.method_11654(PART) == DoubleLongPart.BACK && (Boolean)state.method_11654((class_2769)TRIGGERED) != false ? BathTubBlock.method_31618(type, ModBlockEntityTypes.BATHTUB_BLOCK_ENTITY, AbstractWaterHoldingBlockEntity::tick) : null;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        if (state.method_11654(CONTAINS) == ContainsBlock.WATER && (Integer)state.method_11654((class_2769)LEVEL) > 0 && world.method_8320(pos.method_10074()).method_26204() == class_2246.field_10092) {
            float randomOffset = (float)(Math.random() * 0.5 - 0.25);
            world.method_8406((class_2394)class_2398.field_17430, (double)pos.method_10263() + 0.5 + (double)randomOffset, (double)((float)pos.method_10264() + this.getLiquidLevelHeight(state)), (double)pos.method_10260() + 0.5 + (double)randomOffset, 0.0, 0.0, 0.0);
            world.method_8406((class_2394)class_2398.field_11238, (double)pos.method_10263() + 0.5 + (double)randomOffset, (double)((float)pos.method_10264() + this.getLiquidLevelHeight(state)), (double)pos.method_10260() + 0.5 + (double)randomOffset, 0.0, 0.0, 0.0);
        }
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        DoubleLongPart tubPart;
        if (!world.field_9236 && player.method_7337() && (tubPart = (DoubleLongPart)((Object)state.method_11654(PART))) == DoubleLongPart.FRONT && (blockState = world.method_8320(blockPos = pos.method_10093(BathTubBlock.getDirectionTowardsOtherPart(tubPart, (class_2350)state.method_11654((class_2769)FACING))))).method_27852((class_2248)this) && blockState.method_11654(PART) == DoubleLongPart.BACK) {
            world.method_8652(blockPos, class_2246.field_10124.method_9564(), 35);
            world.method_8444(player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
        return super.method_9576(world, pos, state, player);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8042();
        class_2338 blockPos = ctx.method_8037();
        class_2338 blockPos2 = blockPos.method_10093(direction);
        class_1937 world = ctx.method_8045();
        return world.method_8320(blockPos2).method_26166(ctx) && world.method_8621().method_11952(blockPos2) ? (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction) : null;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236) {
            class_2338 backPos = pos.method_10093((class_2350)state.method_11654((class_2769)FACING));
            boolean isWater = world.method_8316(backPos).method_33659((class_3611)class_3612.field_15910);
            class_2680 backState = (class_2680)((class_2680)state.method_11657(PART, (Comparable)((Object)DoubleLongPart.BACK))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
            world.method_8652(backPos, backState, 3);
            world.method_8408(pos, class_2246.field_10124);
            state.method_30101((class_1936)world, pos, 3);
        }
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public float getSeatRotation(class_2680 state, class_1937 world, class_2338 pos) {
        return ModProperties.setSeatRotationFromFacing(state) + (float)(state.method_11654(PART) == DoubleLongPart.FRONT ? 0 : 180);
    }

    @Override
    public float getSeatHeight(class_2680 state) {
        return 0.2f;
    }

    public static class_2338 getOtherPartPos(class_2680 state, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        return state.method_11654(PART) == DoubleLongPart.FRONT ? pos.method_10093(facing) : pos.method_10093(facing.method_10153());
    }

    public static class_2680 getOtherPartState(class_2680 state, class_1937 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 otherPartPos = state.method_11654(PART) == DoubleLongPart.FRONT ? pos.method_10093(facing) : pos.method_10093(facing.method_10153());
        return world.method_8320(otherPartPos);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_9568(stack, context, tooltip, type);
        tooltip.add(class_5244.field_39003);
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.interact_with_hand_while_sneaking").method_27692(class_124.field_1080));
        tooltip.add((class_2561)ModScreenTexts.entry().method_10852((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.toggle_switch")));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.pulls_water_from").method_27692(class_124.field_1080));
        tooltip.add((class_2561)ModScreenTexts.entry().method_10852((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.behind")));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Override
    public float getLiquidLevelHeight(class_2680 state) {
        int level = (Integer)state.method_11654((class_2769)LEVEL);
        return switch (level) {
            case 0 -> 0.125f;
            case 1 -> 0.5f;
            case 2 -> 0.6875f;
            default -> throw new IllegalStateException("Unexpected value: " + level);
        };
    }

    @Override
    public List<class_2350> getDirectionsToPull(class_2680 state) {
        class_2350 behind = (class_2350)state.method_11654((class_2769)FACING);
        return List.of(behind);
    }

    @Override
    public class_2350 pullingDirection(class_2680 state, class_1937 world, class_2338 pos) {
        for (class_2350 direction : this.getDirectionsToPull(state)) {
            class_2338 offsetPos = pos.method_10093(direction);
            class_2680 offsetState = world.method_8320(offsetPos);
            if (!offsetState.method_26227().method_15767(class_3486.field_15517) && !offsetState.method_26227().method_15767(class_3486.field_15518) && offsetState.method_26204() != class_2246.field_27097 && offsetState.method_26204() != class_2246.field_27098) continue;
            return direction;
        }
        return null;
    }

    @Override
    public boolean isFull(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL) == 2;
    }

    @Override
    public void addLiquid(class_2680 state, class_1937 world, class_2338 pos, class_2680 pullState, class_2350 pullDirection) {
        int level = (Integer)state.method_11654((class_2769)LEVEL);
        int newLevel = Math.min(2, level + 1);
        ContainsBlock contains = ContainsBlock.NONE;
        if (pullState.method_26227().method_15767(class_3486.field_15517) || pullState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)pullState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            contains = ContainsBlock.WATER;
        }
        if (pullState.method_26227().method_15767(class_3486.field_15518)) {
            world.method_8652(pos.method_10093(pullDirection), class_2246.field_10124.method_9564(), 3);
            contains = ContainsBlock.LAVA;
        }
        if (pullState.method_26204() == class_2246.field_27097) {
            world.method_8652(pos.method_10093(pullDirection), class_2246.field_10593.method_9564(), 3);
            contains = ContainsBlock.WATER;
        }
        if (pullState.method_26204() == class_2246.field_27098) {
            world.method_8652(pos.method_10093(pullDirection), class_2246.field_10593.method_9564(), 3);
            contains = ContainsBlock.LAVA;
        }
        world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(newLevel))).method_11657(CONTAINS, (Comparable)((Object)contains)), 3);
        world.method_8652(BathTubBlock.getOtherPartPos(state, pos), (class_2680)((class_2680)BathTubBlock.getOtherPartState(state, world, pos).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(newLevel))).method_11657(CONTAINS, (Comparable)((Object)contains)), 3);
    }

    @Override
    public void removeLiquid(class_2680 state, class_1937 world, class_2338 pos) {
        int level = (Integer)state.method_11654((class_2769)LEVEL);
        int newLevel = Math.max(0, level - 1);
        ContainsBlock contains = newLevel == 0 ? ContainsBlock.NONE : (ContainsBlock)((Object)state.method_11654(CONTAINS));
        world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(newLevel))).method_11657(CONTAINS, (Comparable)((Object)contains)), 3);
        world.method_8652(BathTubBlock.getOtherPartPos(state, pos), (class_2680)((class_2680)BathTubBlock.getOtherPartState(state, world, pos).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(newLevel))).method_11657(CONTAINS, (Comparable)((Object)contains)), 3);
        world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
        world.method_43276((class_6880)class_5712.field_28733, BathTubBlock.getOtherPartPos(state, pos), class_5712.class_7397.method_43287((class_2680)BathTubBlock.getOtherPartState(state, world, pos)));
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1309 && !world.field_9236 && (entity.field_6038 != entity.method_23317() || entity.field_5989 != entity.method_23321())) {
            if (state.method_11654(CONTAINS) == ContainsBlock.LAVA) {
                entity.method_5844(state, new class_243((double)0.8f, 0.75, (double)0.8f));
                entity.method_5643(world.method_48963().method_48817(), 3.0f);
                entity.method_5639(2.0f);
            } else if (state.method_11654(CONTAINS) == ContainsBlock.WATER && entity.method_5809()) {
                entity.method_5646();
                if (entity.method_36971(world, pos)) {
                    this.removeLiquid(state, world, pos);
                }
            }
        }
    }
}

