/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.custom.water_holding_blocks.sink;

import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.luckystudio.cozyhome.block.custom.water_holding_blocks.AbstractWaterHoldingBlockEntity;
import net.luckystudio.cozyhome.block.util.ModBlockEntityTypes;
import net.luckystudio.cozyhome.block.util.ModProperties;
import net.luckystudio.cozyhome.block.util.enums.ContainsBlock;
import net.luckystudio.cozyhome.block.util.interfaces.WaterHoldingBlock;
import net.luckystudio.cozyhome.util.ModScreenTexts;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_702;
import net.minecraft.class_7923;
import net.minecraft.class_9062;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSinkBlock
extends class_2237
implements WaterHoldingBlock {
    public static final class_2746 TRIGGERED = class_2741.field_12522;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<ContainsBlock> CONTAINS = ModProperties.CONTAINS;
    public static final class_2758 LEVEL = ModProperties.FILLED_LEVEL_0_3;

    public AbstractSinkBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(CONTAINS, (Comparable)((Object)ContainsBlock.NONE))).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(new class_2769[]{TRIGGERED, FACING, CONTAINS, LEVEL}));
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1792 item = stack.method_7909();
        ContainsBlock contents = (ContainsBlock)((Object)state.method_11654(CONTAINS));
        int level = (Integer)state.method_11654((class_2769)LEVEL);
        if (WaterHoldingBlock.trySoup(item, world, pos, player, hand, contents)) {
            return class_9062.field_47728;
        }
        if (item == class_1802.field_8550 && level == 3 && contents != ContainsBlock.NONE) {
            class_1799 filledBucket = contents == ContainsBlock.WATER ? new class_1799((class_1935)class_1802.field_8705) : new class_1799((class_1935)class_1802.field_8187);
            class_3414 soundEvent = contents == ContainsBlock.WATER ? class_3417.field_15126 : class_3417.field_15202;
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)filledBucket));
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0))).method_11657(CONTAINS, (Comparable)((Object)ContainsBlock.NONE)), 3);
            world.method_33596(null, (class_6880)class_5712.field_28167, pos);
            return class_9062.field_47728;
        }
        if ((item == class_1802.field_8705 || item == class_1802.field_8187) && level < 3) {
            ContainsBlock newContents = item == class_1802.field_8705 ? ContainsBlock.WATER : ContainsBlock.LAVA;
            class_3414 soundEvent = newContents == ContainsBlock.WATER ? class_3417.field_14834 : class_3417.field_15010;
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8550)));
            player.method_7281(class_3468.field_15430);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(3))).method_11657(CONTAINS, (Comparable)((Object)newContents)), 3);
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, (class_6880)class_5712.field_28166, pos);
            return class_9062.field_47728;
        }
        if (item == class_1802.field_8574 && (contents == ContainsBlock.WATER && level < 3 || contents == ContainsBlock.NONE)) {
            class_1844 potionContentsComponent = (class_1844)stack.method_57824(class_9334.field_49651);
            if (potionContentsComponent != null && potionContentsComponent.method_57401(class_1847.field_8991)) {
                player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469)));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(level + 1))).method_11657(CONTAINS, (Comparable)((Object)ContainsBlock.WATER)), 3);
                world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
                world.method_33596(null, (class_6880)class_5712.field_28166, pos);
                return class_9062.field_47728;
            }
            return WaterHoldingBlock.toggleSwitch(state, world, pos, player);
        }
        if (item == class_1802.field_8469 && contents == ContainsBlock.WATER && level > 0) {
            int newLevel = level - 1;
            ContainsBlock newContents = newLevel == 0 ? ContainsBlock.NONE : contents;
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8991)));
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(level - 1))).method_11657(CONTAINS, (Comparable)((Object)newContents)), 3);
            world.method_8396(null, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, (class_6880)class_5712.field_28167, pos);
            return class_9062.field_47728;
        }
        return WaterHoldingBlock.toggleSwitch(state, world, pos, player);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return AbstractSinkBlock.method_31618(type, ModBlockEntityTypes.SINK_BLOCK_ENTITY, AbstractWaterHoldingBlockEntity::tick);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657(CONTAINS, (Comparable)((Object)ContainsBlock.NONE))).method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657((class_2769)TRIGGERED, (Comparable)Boolean.valueOf(false));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Override
    public float getLiquidLevelHeight(class_2680 state) {
        int level = (Integer)state.method_11654((class_2769)LEVEL);
        return switch (level) {
            case 1 -> 0.438f;
            case 2 -> 0.688f;
            case 3 -> 0.938f;
            default -> 0.125f;
        };
    }

    @Override
    public boolean isFull(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL) == 3;
    }

    @Override
    public void addLiquid(class_2680 state, class_1937 world, class_2338 pos, class_2680 pullState, class_2350 pullDirection) {
        int level = (Integer)state.method_11654((class_2769)LEVEL);
        int newLevel = Math.min(3, level + 1);
        if (pullState.method_26227().method_15767(class_3486.field_15517) || pullState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)pullState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            ContainsBlock contains = ContainsBlock.WATER;
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(newLevel))).method_11657(CONTAINS, (Comparable)((Object)contains)), 3);
            return;
        }
        if (pullState.method_26227().method_15767(class_3486.field_15518)) {
            world.method_8652(pos.method_10093(pullDirection), class_2246.field_10124.method_9564(), 3);
            ContainsBlock contains = ContainsBlock.LAVA;
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(3))).method_11657(CONTAINS, (Comparable)((Object)contains)), 3);
            return;
        }
        if (pullState.method_26204() == class_2246.field_27097) {
            class_5556.method_31650((class_2680)pullState, (class_1937)world, (class_2338)pos.method_10093(pullDirection));
            ContainsBlock contains = ContainsBlock.WATER;
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(newLevel))).method_11657(CONTAINS, (Comparable)((Object)contains)), 3);
            return;
        }
        if (pullState.method_26204() == class_2246.field_27098) {
            world.method_8652(pos.method_10093(pullDirection), class_2246.field_10593.method_9564(), 3);
            ContainsBlock contains = ContainsBlock.LAVA;
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(3))).method_11657(CONTAINS, (Comparable)((Object)contains)), 3);
        }
    }

    @Override
    public void removeLiquid(class_2680 state, class_1937 world, class_2338 pos) {
        int level = (Integer)state.method_11654((class_2769)LEVEL);
        int newLevel = Math.max(0, level - 1);
        ContainsBlock contains = newLevel == 0 ? ContainsBlock.NONE : (ContainsBlock)((Object)state.method_11654(CONTAINS));
        world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(newLevel))).method_11657(CONTAINS, (Comparable)((Object)contains)), 3);
    }

    @Override
    public List<class_2350> getDirectionsToPull(class_2680 state) {
        class_2350 behind = (class_2350)state.method_11654((class_2769)FACING);
        return List.of(behind);
    }

    @Override
    public class_2350 pullingDirection(class_2680 state, class_1937 world, class_2338 pos) {
        for (class_2350 direction : this.getDirectionsToPull(state)) {
            class_2338 offsetPos = pos.method_10093(direction);
            class_2680 offsetState = world.method_8320(offsetPos);
            if (!offsetState.method_26227().method_15767(class_3486.field_15517) && !offsetState.method_26227().method_15767(class_3486.field_15518) && offsetState.method_26204() != class_2246.field_27097 && offsetState.method_26204() != class_2246.field_27098) continue;
            return direction;
        }
        return null;
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        ContainsBlock fillState = (ContainsBlock)((Object)state.method_11654(CONTAINS));
        if (fillState == ContainsBlock.LAVA && entity instanceof class_1309) {
            entity.method_5643(world.method_48963().method_48820(), 4.0f);
            entity.method_5639(3.0f);
        }
        super.method_9591(world, pos, state, entity);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof AbstractWaterHoldingBlockEntity) {
            AbstractWaterHoldingBlockEntity blockEntity = (AbstractWaterHoldingBlockEntity)class_25862;
            if (world.field_9236 && blockEntity.soupTime > 0) {
                class_310 client = class_310.method_1551();
                class_702 particleManager = client.field_1713;
                class_2960 id = class_2960.method_60655((String)"supplementaries", (String)"suds");
                class_2396 type = (class_2396)class_7923.field_41180.method_10223(id);
                if (type != null) {
                    double x = (double)pos.method_10263() + 0.5 + (random.method_43058() - 0.5) * 0.3;
                    double y = (float)pos.method_10264() + this.getLiquidLevelHeight(state);
                    double z = (double)pos.method_10260() + 0.5 + (random.method_43058() - 0.5) * 0.3;
                    particleManager.method_3056((class_2394)type, x, y, z, 0.0, 0.01, 0.0);
                }
            }
        }
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_9568(stack, context, tooltip, type);
        tooltip.add(class_5244.field_39003);
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.interact_with_hand_while_sneaking").method_27692(class_124.field_1080));
        tooltip.add((class_2561)ModScreenTexts.entry().method_10852((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.toggle_switch")));
        if (FabricLoader.getInstance().isModLoaded("supplementaries")) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.interact_with_soup").method_27692(class_124.field_1080));
            tooltip.add((class_2561)ModScreenTexts.entry().method_10852((class_2561)class_2561.method_43471((String)"tooltip.cozyhome.add_bubbles")));
        }
    }
}

