/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.cozyhome.block.util.enums;

import net.luckystudio.cozyhome.block.util.ModProperties;
import net.luckystudio.cozyhome.block.util.enums.HorizontalLinearConnectionBlock;
import net.luckystudio.cozyhome.block.util.interfaces.ConnectingBlock;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3542;

public enum AdvancedHorizontalLinearConnectionBlock implements class_3542
{
    SINGLE("single"),
    LEFT("left"),
    MIDDLE("middle"),
    RIGHT("right"),
    LEFT_DIFF("left_diff"),
    MIDDLE_DIFF("middle_diff"),
    RIGHT_DIFF("right_diff"),
    LEFT_DIFF_LEFT("left_diff_left"),
    RIGHT_DIFF_RIGHT("right_diff_right");

    private final String name;

    private AdvancedHorizontalLinearConnectionBlock(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String method_15434() {
        return this.name;
    }

    public static AdvancedHorizontalLinearConnectionBlock setAdvancedHorizontalConnections(class_2680 state, class_1936 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2383.field_11177);
        class_2350 left = facing.method_10170();
        class_2350 right = facing.method_10160();
        class_2680 stateLeft = world.method_8320(pos.method_10093(left));
        class_2680 stateRight = world.method_8320(pos.method_10093(right));
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ConnectingBlock) {
            ConnectingBlock connectingBlock = (ConnectingBlock)class_22482;
            if (AdvancedHorizontalLinearConnectionBlock.isLeft(state) ? connectingBlock.isMatchingBlock(stateLeft) && AdvancedHorizontalLinearConnectionBlock.isMiddle(stateLeft) : (AdvancedHorizontalLinearConnectionBlock.isMiddle(state) ? connectingBlock.isMatchingBlock(stateLeft) && connectingBlock.isMatchingBlock(stateRight) && AdvancedHorizontalLinearConnectionBlock.isLeft(stateLeft) && AdvancedHorizontalLinearConnectionBlock.isRight(stateRight) : AdvancedHorizontalLinearConnectionBlock.isRight(state) && connectingBlock.isMatchingBlock(stateRight) && AdvancedHorizontalLinearConnectionBlock.isMiddle(stateRight))) {
                return (AdvancedHorizontalLinearConnectionBlock)((Object)state.method_11654(ModProperties.ADVANCED_HORIZONTAL_CONNECTION));
            }
        }
        return AdvancedHorizontalLinearConnectionBlock.setConnections(state, world, pos, left, right);
    }

    private static AdvancedHorizontalLinearConnectionBlock setConnections(class_2680 state, class_1936 world, class_2338 pos, class_2350 left, class_2350 right) {
        boolean canConnectLeft = AdvancedHorizontalLinearConnectionBlock.canConnect(state, world, pos, left);
        boolean canConnectRight = AdvancedHorizontalLinearConnectionBlock.canConnect(state, world, pos, right);
        class_2680 stateLeft = world.method_8320(pos.method_10093(left));
        class_2680 stateRight = world.method_8320(pos.method_10093(right));
        if (canConnectLeft && canConnectRight) {
            if (AdvancedHorizontalLinearConnectionBlock.isMiddle(stateLeft)) {
                return stateLeft.method_27852(state.method_26204()) ? LEFT : LEFT_DIFF;
            }
            if (AdvancedHorizontalLinearConnectionBlock.isMiddle(stateRight)) {
                return stateRight.method_27852(state.method_26204()) ? RIGHT : RIGHT_DIFF;
            }
            if (stateLeft.method_27852(state.method_26204()) && stateRight.method_27852(state.method_26204())) {
                return MIDDLE;
            }
            if (stateLeft.method_27852(state.method_26204())) {
                return LEFT_DIFF_LEFT;
            }
            if (stateRight.method_27852(state.method_26204())) {
                return RIGHT_DIFF_RIGHT;
            }
            return MIDDLE_DIFF;
        }
        if (canConnectLeft) {
            return stateLeft.method_27852(state.method_26204()) ? LEFT : LEFT_DIFF;
        }
        if (canConnectRight) {
            return stateRight.method_27852(state.method_26204()) ? RIGHT : RIGHT_DIFF;
        }
        return SINGLE;
    }

    private static boolean canConnect(class_2680 state, class_1936 world, class_2338 pos, class_2350 direction) {
        class_2680 neighborState = world.method_8320(pos.method_10093(direction));
        class_2680 neighborState2 = world.method_8320(pos.method_10079(direction, 2));
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ConnectingBlock) {
            ConnectingBlock connectingBlock = (ConnectingBlock)class_22482;
            if (connectingBlock.isMatchingBlock(neighborState2) && neighborState2.method_11654((class_2769)class_2383.field_11177) == state.method_11654((class_2769)class_2383.field_11177) && AdvancedHorizontalLinearConnectionBlock.isMiddle(neighborState2)) {
                return false;
            }
            return connectingBlock.isMatchingBlock(neighborState) && neighborState.method_11654((class_2769)class_2383.field_11177) == state.method_11654((class_2769)class_2383.field_11177);
        }
        return false;
    }

    private static boolean isLeft(class_2680 targetState) {
        if (targetState.method_28498(ModProperties.ADVANCED_HORIZONTAL_CONNECTION)) {
            AdvancedHorizontalLinearConnectionBlock connectionBlock = (AdvancedHorizontalLinearConnectionBlock)((Object)targetState.method_11654(ModProperties.ADVANCED_HORIZONTAL_CONNECTION));
            return connectionBlock == LEFT || connectionBlock == LEFT_DIFF;
        }
        HorizontalLinearConnectionBlock connectionBlock = (HorizontalLinearConnectionBlock)((Object)targetState.method_11654(ModProperties.HORIZONTAL_CONNECTION));
        return connectionBlock == HorizontalLinearConnectionBlock.LEFT;
    }

    private static boolean isRight(class_2680 targetState) {
        if (targetState.method_28498(ModProperties.ADVANCED_HORIZONTAL_CONNECTION)) {
            AdvancedHorizontalLinearConnectionBlock connectionBlock = (AdvancedHorizontalLinearConnectionBlock)((Object)targetState.method_11654(ModProperties.ADVANCED_HORIZONTAL_CONNECTION));
            return connectionBlock == RIGHT || connectionBlock == RIGHT_DIFF;
        }
        HorizontalLinearConnectionBlock connectionBlock = (HorizontalLinearConnectionBlock)((Object)targetState.method_11654(ModProperties.HORIZONTAL_CONNECTION));
        return connectionBlock == HorizontalLinearConnectionBlock.RIGHT;
    }

    private static boolean isMiddle(class_2680 targetState) {
        if (targetState.method_28498(ModProperties.ADVANCED_HORIZONTAL_CONNECTION)) {
            AdvancedHorizontalLinearConnectionBlock connectionBlock = (AdvancedHorizontalLinearConnectionBlock)((Object)targetState.method_11654(ModProperties.ADVANCED_HORIZONTAL_CONNECTION));
            return connectionBlock == MIDDLE || connectionBlock == MIDDLE_DIFF || connectionBlock == LEFT_DIFF_LEFT || connectionBlock == RIGHT_DIFF_RIGHT;
        }
        HorizontalLinearConnectionBlock connectionBlock = (HorizontalLinearConnectionBlock)((Object)targetState.method_11654(ModProperties.HORIZONTAL_CONNECTION));
        return connectionBlock == HorizontalLinearConnectionBlock.MIDDLE;
    }
}

