/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaArcheology;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import me.TreeOfSelf.PandaArcheology.PandaArcheology;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_8824;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class DespawnedItemManager {
    private final List<class_1799> despawnedItems = new ArrayList<class_1799>();
    private final List<String> despawnedItemsOwners = new ArrayList<String>();
    private final List<Long> despawnedItemsTimes = new ArrayList<Long>();
    private final Path dataFile;
    private final class_5455 registryManager;

    public DespawnedItemManager(Path worldSavePath, class_5455 registryManager) {
        this.dataFile = worldSavePath.resolve("despawned_items.dat");
        this.registryManager = registryManager;
        this.load();
    }

    public void addItem(class_1799 item, String string) {
        int occurences = 0;
        for (class_1799 despawnedItem : this.despawnedItems) {
            if (despawnedItem.method_7909() != item.method_7909()) continue;
            ++occurences;
        }
        if (occurences < PandaArcheology.itemLimit || PandaArcheology.itemLimit == 0) {
            this.despawnedItems.add(item);
            this.despawnedItemsOwners.add(string);
            this.despawnedItemsTimes.add(System.currentTimeMillis());
        }
    }

    public itemData getItem(class_5819 random) {
        int index = random.method_43048(this.despawnedItems.size());
        return new itemData(this.despawnedItems.remove(index), this.despawnedItemsOwners.remove(index), this.despawnedItemsTimes.remove(index));
    }

    public int itemLength() {
        return this.despawnedItems.size();
    }

    public void save() {
        class_2487 compound = new class_2487();
        class_2499 nbtList = new class_2499();
        class_2499 nbtListOwners = new class_2499();
        class_2499 nbtListTimes = new class_2499();
        for (int x = 0; x < this.despawnedItems.size(); ++x) {
            try {
                nbtList.add((Object)((class_2520)class_1799.field_24671.encodeStart((DynamicOps)this.registryManager.method_57093((DynamicOps)class_2509.field_11560), (Object)this.despawnedItems.get(x)).getOrThrow()));
                nbtListOwners.add((Object)class_2519.method_23256((String)this.despawnedItemsOwners.get(x)));
                long[] tempArray = new long[]{this.despawnedItemsTimes.get(x)};
                nbtListTimes.add((Object)new class_2501(tempArray));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        compound.method_10566("DespawnedItems", (class_2520)nbtList);
        compound.method_10566("DespawnedOwners", (class_2520)nbtListOwners);
        compound.method_10566("DespawnedTimes", (class_2520)nbtListTimes);
        try {
            class_2507.method_30614((class_2487)compound, (Path)this.dataFile.toFile().toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void load() {
        if (!this.dataFile.toFile().exists()) {
            return;
        }
        try {
            class_2487 compound = class_2507.method_30613((Path)this.dataFile.toFile().toPath(), (class_2505)class_2505.method_53898());
            Optional nbtList = compound.method_10554("DespawnedItems");
            Optional nbtListOwners = compound.method_10554("DespawnedOwners");
            Optional nbtListTimes = compound.method_10554("DespawnedTimes");
            for (int i = 0; i < ((class_2499)nbtList.get()).size(); ++i) {
                class_9290 lore;
                class_2561 customName;
                DataResult result;
                JsonElement jsonElement2;
                class_2561 itemName;
                class_2487 thisItem = (class_2487)((class_2499)nbtList.get()).method_10602(i).get();
                DataResult item = class_1799.field_24671.decode((DynamicOps)this.registryManager.method_57093((DynamicOps)class_2509.field_11560), (Object)thisItem);
                class_1799 loadedStack = (class_1799)((Pair)item.getOrThrow()).getFirst();
                if (loadedStack.method_57826(class_9334.field_50239) && (itemName = (class_2561)loadedStack.method_58694(class_9334.field_50239)) != null && itemName.getString().startsWith("{")) {
                    try {
                        jsonElement2 = JsonParser.parseString((String)itemName.getString());
                        result = class_8824.field_46597.decode((DynamicOps)this.registryManager.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)jsonElement2);
                        loadedStack.method_57379(class_9334.field_50239, (Object)((class_2561)((Pair)result.getOrThrow()).getFirst()));
                    }
                    catch (Exception jsonElement2) {
                        // empty catch block
                    }
                }
                if (loadedStack.method_57826(class_9334.field_49631) && (customName = (class_2561)loadedStack.method_58694(class_9334.field_49631)) != null && customName.getString().startsWith("{")) {
                    try {
                        jsonElement2 = JsonParser.parseString((String)customName.getString());
                        result = class_8824.field_46597.decode((DynamicOps)this.registryManager.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)jsonElement2);
                        loadedStack.method_57379(class_9334.field_49631, (Object)((class_2561)((Pair)result.getOrThrow()).getFirst()));
                    }
                    catch (Exception jsonElement3) {
                        // empty catch block
                    }
                }
                if (loadedStack.method_57826(class_9334.field_49632) && (lore = (class_9290)loadedStack.method_58694(class_9334.field_49632)) != null && !lore.comp_2400().isEmpty()) {
                    ArrayList<class_2561> newLoreLines = new ArrayList<class_2561>();
                    Iterator iterator = lore.comp_2400().iterator();
                    while (iterator.hasNext()) {
                        class_2561 line;
                        class_2561 newLine = line = (class_2561)iterator.next();
                        if (line.getString().startsWith("{")) {
                            try {
                                JsonElement jsonElement4 = JsonParser.parseString((String)line.getString());
                                DataResult result2 = class_8824.field_46597.decode((DynamicOps)this.registryManager.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)jsonElement4);
                                newLine = (class_2561)((Pair)result2.getOrThrow()).getFirst();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        newLoreLines.add(newLine);
                    }
                    loadedStack.method_57379(class_9334.field_49632, (Object)new class_9290(newLoreLines));
                }
                this.despawnedItems.add(loadedStack);
                this.despawnedItemsOwners.add((String)((class_2520)((class_2499)nbtListOwners.get()).get(i)).method_68658().get());
                this.despawnedItemsTimes.add(((long[])((class_2499)nbtListTimes.get()).method_36112(i).get())[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class itemData {
        public class_1799 item;
        public String owner;
        public long time;

        itemData(class_1799 item, String owner, long time) {
            this.item = item;
            this.owner = owner;
            this.time = time;
        }
    }
}

