/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaArcheology;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import me.TreeOfSelf.PandaArcheology.DespawnedItemManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_5218;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PandaArcheology
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"pandaarcheology");
    public static DespawnedItemManager despawnedItemManager;
    private static final File CONFIG_FILE;
    private static final Gson GSON;
    public static boolean activeForFishing;
    public static boolean activeForBrushing;
    public static boolean onlyPlayerOwned;
    public static int itemLimit;
    public static int fishingChance;
    public static int brushChance;
    public static int luckMultiplier;

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStop);
        ServerLifecycleEvents.AFTER_SAVE.register(this::onServerSave);
        this.loadOrCreateConfig();
        LOGGER.info("PandaArcheology Started!");
    }

    private void onServerSave(MinecraftServer server, boolean b, boolean b1) {
        despawnedItemManager.save();
    }

    private void onServerStop(MinecraftServer server) {
        despawnedItemManager.save();
    }

    private void onServerStart(MinecraftServer server) {
        Path worldSavePath = server.method_27050(class_5218.field_24188);
        despawnedItemManager = new DespawnedItemManager(worldSavePath, (class_5455)server.method_30611());
    }

    private void loadOrCreateConfig() {
        boolean needsUpdate = false;
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (json.has("activeForFishing")) {
                    activeForFishing = json.get("activeForFishing").getAsBoolean();
                } else {
                    activeForFishing = true;
                    needsUpdate = true;
                }
                if (json.has("activeForBrushing")) {
                    activeForBrushing = json.get("activeForBrushing").getAsBoolean();
                } else {
                    activeForBrushing = true;
                    needsUpdate = true;
                }
                if (json.has("onlyPlayerOwned")) {
                    onlyPlayerOwned = json.get("onlyPlayerOwned").getAsBoolean();
                } else {
                    onlyPlayerOwned = false;
                    needsUpdate = true;
                }
                if (json.has("itemLimit")) {
                    itemLimit = json.get("itemLimit").getAsInt();
                } else {
                    itemLimit = 10;
                    needsUpdate = true;
                }
                if (json.has("fishingChance")) {
                    fishingChance = json.get("fishingChance").getAsInt();
                } else {
                    fishingChance = 100;
                    needsUpdate = true;
                }
                if (json.has("brushChance")) {
                    brushChance = json.get("brushChance").getAsInt();
                } else {
                    brushChance = 10;
                    needsUpdate = true;
                }
                if (json.has("luckMultiplier")) {
                    luckMultiplier = json.get("luckMultiplier").getAsInt();
                } else {
                    luckMultiplier = 3;
                    needsUpdate = true;
                }
                if (needsUpdate) {
                    this.saveConfig();
                    LOGGER.info("Updated configuration file with missing values.");
                } else {
                    LOGGER.info("Loaded configuration from file.");
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read the configuration file.", (Throwable)e);
                this.createDefaultConfig();
            }
        } else {
            this.createDefaultConfig();
        }
    }

    private void saveConfig() {
        JsonObject json = new JsonObject();
        json.addProperty("activeForFishing", Boolean.valueOf(activeForFishing));
        json.addProperty("activeForBrushing", Boolean.valueOf(activeForBrushing));
        json.addProperty("onlyPlayerOwned", Boolean.valueOf(onlyPlayerOwned));
        json.addProperty("itemLimit", (Number)itemLimit);
        json.addProperty("fishingChance", (Number)fishingChance);
        json.addProperty("brushChance", (Number)brushChance);
        json.addProperty("luckMultiplier", (Number)luckMultiplier);
        CONFIG_FILE.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write the configuration file.", (Throwable)e);
        }
    }

    private void createDefaultConfig() {
        activeForFishing = true;
        activeForBrushing = true;
        onlyPlayerOwned = false;
        itemLimit = 10;
        fishingChance = 100;
        brushChance = 10;
        luckMultiplier = 3;
        this.saveConfig();
        LOGGER.info("Created default configuration file.");
    }

    static {
        CONFIG_FILE = new File("./config/PandaArchaeology.json");
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

