/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaArcheology;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import me.TreeOfSelf.PandaArcheology.DespawnedItemManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_5218;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PandaArcheology
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"pandaarcheology");
    public static DespawnedItemManager despawnedItemManager;
    private static final File CONFIG_FILE;
    private static final Gson GSON;
    public static boolean activeForFishing;
    public static boolean activeForBrushing;
    public static boolean onlyPlayerOwned;
    public static int itemLimit;
    public static int fishingChance;
    public static int brushChance;

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStop);
        ServerLifecycleEvents.AFTER_SAVE.register(this::onServerSave);
        this.loadOrCreateConfig();
        LOGGER.info("PandaArcheology Started!");
    }

    private void onServerSave(MinecraftServer server, boolean b, boolean b1) {
        despawnedItemManager.save();
    }

    private void onServerStop(MinecraftServer server) {
        despawnedItemManager.save();
    }

    private void onServerStart(MinecraftServer server) {
        Path worldSavePath = server.method_27050(class_5218.field_24188);
        despawnedItemManager = new DespawnedItemManager(worldSavePath, (class_5455)server.method_30611());
    }

    private void loadOrCreateConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                activeForFishing = json.get("activeForFishing").getAsBoolean();
                activeForBrushing = json.get("activeForBrushing").getAsBoolean();
                onlyPlayerOwned = json.get("onlyPlayerOwned").getAsBoolean();
                itemLimit = json.get("itemLimit").getAsInt();
                fishingChance = json.get("fishingChance").getAsInt();
                brushChance = json.get("brushChance").getAsInt();
                LOGGER.info("Loaded configuration from file.");
            }
            catch (IOException e) {
                LOGGER.error("Failed to read the configuration file.", (Throwable)e);
                this.createDefaultConfig();
            }
        } else {
            this.createDefaultConfig();
        }
    }

    private void createDefaultConfig() {
        activeForFishing = true;
        activeForBrushing = true;
        onlyPlayerOwned = false;
        itemLimit = 10;
        fishingChance = 100;
        brushChance = 10;
        JsonObject json = new JsonObject();
        json.addProperty("activeForFishing", Boolean.valueOf(activeForFishing));
        json.addProperty("activeForBrushing", Boolean.valueOf(activeForBrushing));
        json.addProperty("onlyPlayerOwned", Boolean.valueOf(onlyPlayerOwned));
        json.addProperty("itemLimit", (Number)itemLimit);
        json.addProperty("fishingChance", (Number)fishingChance);
        json.addProperty("brushChance", (Number)brushChance);
        CONFIG_FILE.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
            LOGGER.info("Created default configuration file.");
        }
        catch (IOException e) {
            LOGGER.error("Failed to write the configuration file.", (Throwable)e);
        }
    }

    static {
        CONFIG_FILE = new File("./config/PandaArchaeology.json");
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

