/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.event;

import cn.handyplus.warp.lib.expand.adapter.HandySchedulerUtil;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class WarpLikeClickResultEvent
extends Event {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Player player;
    private final Integer warpId;
    private final LikeTypeEnum type;
    private final boolean result;

    public WarpLikeClickResultEvent(Player player, Integer warpId, LikeTypeEnum type, boolean result) {
        this.player = player;
        this.warpId = warpId;
        this.type = type;
        this.result = result;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public static void callBuffEvent(Player player, Integer warpId, String type, boolean result) {
        LikeTypeEnum likeTypeEnum = LikeTypeEnum.getByType(type);
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new WarpLikeClickResultEvent(player, warpId, likeTypeEnum, result)));
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public Integer getWarpId() {
        return this.warpId;
    }

    @Generated
    public LikeTypeEnum getType() {
        return this.type;
    }

    @Generated
    public boolean isResult() {
        return this.result;
    }

    public static enum LikeTypeEnum {
        COLLECTION("collection", "\u6536\u85cf"),
        TOP("top", "\u9876"),
        STEP_ON("stepOn", "\u8e29"),
        POINT_TOP("pointTop", "\u70b9\u5238\u9876"),
        POINT_STEP_ON("pointStepOn", "\u70b9\u5238\u8e29"),
        ONE("1", "\u8bc4\u52061"),
        TWO("2", "\u8bc4\u52062"),
        THREE("3", "\u8bc4\u52063"),
        FOUR("4", "\u8bc4\u52064"),
        FIVE("5", "\u8bc4\u52065");

        private final String type;
        private final String title;

        public static LikeTypeEnum getByType(String type) {
            for (LikeTypeEnum value : LikeTypeEnum.values()) {
                if (!value.getType().equals(type)) continue;
                return value;
            }
            return null;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        private LikeTypeEnum(String type, String title) {
            this.type = type;
            this.title = title;
        }
    }
}

