/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.util;

import cn.handyplus.warp.constants.WarpConstants;
import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.enter.WarpChannel;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.event.WarpCreateSuccessEvent;
import cn.handyplus.warp.event.WarpTpEvent;
import cn.handyplus.warp.hook.MultiverseCoreUtil;
import cn.handyplus.warp.hook.PlaceholderApiUtil;
import cn.handyplus.warp.lib.BaseConstants;
import cn.handyplus.warp.lib.BaseUtil;
import cn.handyplus.warp.lib.BcUtil;
import cn.handyplus.warp.lib.CollUtil;
import cn.handyplus.warp.lib.DateUtil;
import cn.handyplus.warp.lib.ItemStackUtil;
import cn.handyplus.warp.lib.JsonUtil;
import cn.handyplus.warp.lib.MapUtil;
import cn.handyplus.warp.lib.MessageUtil;
import cn.handyplus.warp.lib.NumberUtil;
import cn.handyplus.warp.lib.StrUtil;
import cn.handyplus.warp.lib.expand.adapter.HandyRunnable;
import cn.handyplus.warp.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.warp.lib.expand.adapter.PlayerSchedulerUtil;
import cn.handyplus.warp.param.CreateFlagParam;
import cn.handyplus.warp.param.WarpLocationSpawn;
import cn.handyplus.warp.runnable.WarpTaskRunnable;
import cn.handyplus.warp.service.WarpChannelService;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.service.WarpWhiteListService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpPermissionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class WarpUtil {
    public static List<String> getDescription(String a2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StrUtil.isEmpty(a2)) {
            ArrayList<String> arrayList2 = arrayList;
            arrayList2.add(BaseUtil.getLangMsg(ItemStackUtil.IiiIIi("\u0013\u0018\t")));
            return arrayList2;
        }
        ArrayList<String> arrayList3 = arrayList;
        arrayList3.addAll(StrUtil.strToStrList(a2));
        return arrayList3;
    }

    public static Map<String, List<String>> getDescriptionMap(String a2) {
        return MapUtil.of(StrUtil.IiiIIi("5+\"-#'!:8!?"), WarpUtil.getDescription(a2));
    }

    public static boolean check(Player a2, String a3) {
        List<WarpPlayer> list;
        int n = ConfigUtil.CREATE_CONFIG.getInt(ItemStackUtil.IiiIIi("\u0019\u001c\u001a\u0018;\u0018\u0019\u001a\u0003\u0015"));
        if (ChatColor.stripColor((String)a3).length() > n) {
            String string = ConfigUtil.CREATE_CONFIG.getString(StrUtil.IiiIIi("\"4 6:9\b0'=;#+\u001c=6"), "").replace(ItemStackUtil.IiiIIi("Y\f\u0011\u0012\u0013\u0010\t\u001f\u0000"), n + "");
            MessageUtil.sendMessage(a2, string);
            return false;
        }
        if ((a3.contains(StrUtil.IiiIIi("w")) || a3.contains(ItemStackUtil.IiiIIi("\u00da"))) && !a2.hasPermission(StrUtil.IiiIIi("!\"074<\u0006/#>\u007f-#+0:4`2!=!#"))) {
            String string = ConfigUtil.CREATE_CONFIG.getString(ItemStackUtil.IiiIIi("\u001e\u0018\u0011\u0018\u000f1\u001c\u001e\u0011\u0002\u000f\u00120\u0004\u001a"), StrUtil.IiiIIi("wz\u4f31\u6cef\u6758nw/q>=/(+#\u00190<!`2<4/%+\u007f->\"><qhe\u670d\u9601\u672b\u524a\u5eb4\u5f38\u823c\u545c\u79be\u76d5\u577e\u6856"));
            MessageUtil.sendMessage(a2, string);
            return false;
        }
        Object object = ConfigUtil.CREATE_CONFIG.getStringList(ItemStackUtil.IiiIIi("\u0013\u0016\u0010\u0012?\u001b\u001c\u0014\u0016;\u0014\u0004\t"));
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (!a3.contains((CharSequence)object)) continue;
            String string = ConfigUtil.CREATE_CONFIG.getString(StrUtil.IiiIIi("?/<+\u0013\"0-:\u00028=%\b0'=;#+\u001c=6"), "").replace(ItemStackUtil.IiiIIi("Y\f\u0013\u0016\u0010\u0012\u0000"), (CharSequence)object);
            MessageUtil.sendMessage(a2, string);
            return false;
        }
        object2 = BaseConstants.CONFIG.getStringList(StrUtil.IiiIIi(" >:\u0006!#\"5"));
        if (CollUtil.isNotEmpty(object2) && CollUtil.contains((List<String>)object2, a2.getWorld().getName())) {
            MessageUtil.sendMessage(a2, ConfigUtil.CREATE_CONFIG.getString(ItemStackUtil.IiiIIi("\u0013\u0018*\u0018\u000f\u001b\u00195\b\u0003\t\u0018\u0013")));
            return false;
        }
        boolean bl = BaseConstants.CONFIG.getBoolean(StrUtil.IiiIIi(" 0#4\u0001?\"("), true);
        if (bl && CollUtil.isNotEmpty(list = WarpPlayerService.getInstance().findByName(a3))) {
            a3 = ConfigUtil.CREATE_CONFIG.getString(ItemStackUtil.IiiIIi("\u0019\u001c\u001a\u00188\u0013\u001b\u00041\u001c\u001e\u0011\u0002\u000f\u00120\u0004\u001a"), "").replace(StrUtil.IiiIIi("u5?/<+,"), a3);
            MessageUtil.sendMessage(a2, a3);
            return false;
        }
        return true;
    }

    public static void runTaskTpWarpLocation(Player a2, WarpPlayer a3) {
        HandySchedulerUtil.runTask(() -> WarpUtil.tpWarpLocation(a2, a3));
    }

    public static void runTaskTpLocalWarpLocation(Player a2, String a3, String a4, String a5) {
        HandySchedulerUtil.runTask(() -> WarpUtil.j(a2, a3, a4, a5));
    }

    public static void executionCommand(Player a2, String a3, String a4) {
        if (CollUtil.isEmpty(a3 = BaseConstants.CONFIG.getStringList((String)((Object)a3)))) {
            return;
        }
        Iterator iterator = a3 = a3.iterator();
        while (iterator.hasNext()) {
            String string = (String)a3.next();
            if (StrUtil.isEmpty(string)) {
                iterator = a3;
                continue;
            }
            string = string.replace(StrUtil.IiiIIi("u5!\"074<,"), a2.getName());
            string = string.replace(ItemStackUtil.IiiIIi("Y\f\u0013\u0016\u0010\u0012\u0000"), a4);
            iterator = a3;
            PlayerSchedulerUtil.dispatchCommand(PlaceholderApiUtil.set(a2, string));
        }
    }

    public static void runTaskTp(Player a2, WarpPlayer a3) {
        HandySchedulerUtil.runTask(() -> WarpUtil.j(a2, a3));
    }

    public static boolean checkDescription(Player a2, String a3) {
        int n = ConfigUtil.ADMIN_CONFIG.getInt(ItemStackUtil.IiiIIi("\u0019\u0012\u000e\u0014\u000f\u001e\r\u0003\u0014\u0018\u0013;\u0018\u0019\u001a\u0003\u0015"), 16);
        if (ChatColor.stripColor((String)a3).length() > n) {
            String string = ConfigUtil.ADMIN_CONFIG.getString(StrUtil.IiiIIi("5+\"-#'!:8!?\u00024 6:9\b0'=;#+\u001c=6"), "").replace(ItemStackUtil.IiiIIi("Y\f\u0011\u0012\u0013\u0010\t\u001f\u0000"), n + "");
            MessageUtil.sendMessage(a2, string);
            return false;
        }
        Object object = ConfigUtil.CREATE_CONFIG.getStringList(StrUtil.IiiIIi("?/<+\u0013\"0-:\u00028=%"));
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!a3.contains((CharSequence)object)) continue;
            object = ConfigUtil.ADMIN_CONFIG.getString(ItemStackUtil.IiiIIi("\u0019\u0012\u000e\u0014\u000f\u001e\r\u0003\u0014\u0018\u00131\u001c\u001e\u0011\u0002\u000f\u00120\u0004\u001a"), "").replace(StrUtil.IiiIIi("u5?/<+,"), (CharSequence)object);
            MessageUtil.sendMessage(a2, (String)object);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void xXxXXX(Player a2, Integer a3) {
        if (a3 > 100) {
            MessageUtil.sendMessage(a2, BaseUtil.getMsgNotColor(ItemStackUtil.IiiIIi("\u0011\u001e\u0010\u001e\t")));
            MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(StrUtil.IiiIIi("='<'%")));
        }
    }

    public WarpUtil() {
        WarpUtil a2;
    }

    private static /* synthetic */ void j(Player a2, String a3, String a4, String a5) {
        if (!((Optional)(a4 = WarpUtil.XXXXxX((String)a4, a5))).isPresent()) {
            MessageUtil.sendMessage(a2, BaseUtil.getLangMsg(ItemStackUtil.IiiIIi("\u0000\u001c\u0005\r2\u000f\u0005\u0012\u00050\u0004\u001a")));
            return;
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new WarpTpEvent(a2, (Location)((Optional)a4).get(), a3));
    }

    public static String getLocationDesc(String a2) {
        WarpLocationSpawn warpLocationSpawn = JsonUtil.toBean(a2, WarpLocationSpawn.class);
        return new StringBuilder().insert(0, MultiverseCoreUtil.getAlias(warpLocationSpawn.getWorld())).append(ItemStackUtil.IiiIIi("Q")).append((int)warpLocationSpawn.getX()).append(StrUtil.IiiIIi("}")).append((int)warpLocationSpawn.getY()).append(ItemStackUtil.IiiIIi("Q")).append((int)warpLocationSpawn.getZ()).toString();
    }

    public static boolean editDescription(Player a2, String a3) {
        if (!WarpUtil.checkDescription(a2, a3)) {
            return false;
        }
        Optional<WarpPlayer> optional = WarpConstants.CHAT_CACHE_ID_MAP.get(a2.getUniqueId());
        if (optional == null) {
            return true;
        }
        optional = WarpPlayerService.getInstance().findById((Integer)((Object)optional));
        if (!optional.isPresent()) {
            return true;
        }
        optional = (WarpPlayer)optional.get();
        ((WarpPlayer)((Object)optional)).setDescription(a3);
        WarpPlayerService.getInstance().update((WarpPlayer)((Object)optional));
        MessageUtil.sendMessage(a2, ConfigUtil.ADMIN_CONFIG.getString(StrUtil.IiiIIi(">%\u0015+\"-#'!:8!?\f$:%!?"), ""));
        return true;
    }

    public static boolean editPrice(Player a2, String a3) {
        Optional<WarpPlayer> optional = WarpConstants.CHAT_CACHE_ID_MAP.get(a2.getUniqueId());
        if (optional == null) {
            return true;
        }
        optional = WarpPlayerService.getInstance().findById((Integer)((Object)optional));
        if (!optional.isPresent()) {
            return true;
        }
        optional = (WarpPlayer)optional.get();
        if ((a3 = NumberUtil.isNumericToInt((String)a3)) == null || (Integer)a3 < 0) {
            MessageUtil.sendMessage(a2, BaseUtil.getLangMsg(ItemStackUtil.IiiIIi("\u0016\u0010\u0018\b\u0019\t1\u001c\u001e\u0011\u0002\u000f\u00120\u0004\u001a")));
            return false;
        }
        int n = BaseConstants.CONFIG.getInt(StrUtil.IiiIIi("#06\u0001<8-4"), 0);
        if (n > 0 && (Integer)a3 > n) {
            MessageUtil.sendMessage(a2, ConfigUtil.ADMIN_CONFIG.getString(ItemStackUtil.IiiIIi("\u001a\u001c\u000f-\u0005\u0014\u0014\u00181\u001c\u001e\u0011\u0002\u000f\u00120\u0004\u001a"), "").replace(StrUtil.IiiIIi("j*>#'2+,"), n + ""));
            return false;
        }
        ((WarpPlayer)((Object)optional)).setPrice((Integer)a3);
        WarpPlayerService.getInstance().update((WarpPlayer)((Object)optional));
        MessageUtil.sendMessage(a2, ConfigUtil.ADMIN_CONFIG.getString(ItemStackUtil.IiiIIi("\u0012\u001c-\u0005\u0014\u0014\u00185\b\u0003\t\u0018\u0013"), "").replace(StrUtil.IiiIIi("j*>#'2+,"), ((Integer)a3).toString()));
        return true;
    }

    public static boolean checkWarpNumber(Player a2) {
        List list = BaseConstants.CONFIG.getStringList(ItemStackUtil.IiiIIi("\u0019\u0012\u0003*\u0018\u000f\u001b\u0019"));
        if (CollUtil.isNotEmpty(list) && list.contains(a2.getWorld().getName())) {
            MessageUtil.sendMessage(a2, BaseUtil.getLangMsg(StrUtil.IiiIIi("?!\u0006!#\"5\r#+0:4")));
            return true;
        }
        int n = WarpPermissionUtil.getWarpNumber(a2);
        if (WarpPlayerService.getInstance().findCountByPlayerUuid(a2.getUniqueId()) >= n) {
            String string = ConfigUtil.CREATE_CONFIG.getString(ItemStackUtil.IiiIIi("\n\u0016\u000f\u00073\u0002\u0010\u0015\u0018\u00050\u0004\u001a"), "").replace(StrUtil.IiiIIi("u5?;<,4<,"), n + "");
            MessageUtil.sendMessage(a2, string);
            return true;
        }
        CreateFlagParam createFlagParam = WarpConstants.CREATE_FLAG.get(a2.getUniqueId());
        if (createFlagParam != null && !createFlagParam.isCreateFlag()) {
            MessageUtil.sendMessage(a2, createFlagParam.getTipMsg());
            return true;
        }
        return false;
    }

    public static boolean tpPriceCheck(Player a2, WarpPlayer a3) {
        if (a3.getPrice() < 1) {
            return true;
        }
        if (a2.getUniqueId().equals(a3.getPlayerUuid())) {
            return true;
        }
        return WarpWhiteListService.getInstance().findByWarpIdAndPlayerUuid(a3.getId(), a2.getUniqueId()).isPresent();
    }

    public static String getWarpLocationSpawn(Player a2) {
        WarpLocationSpawn warpLocationSpawn;
        Location location = a2.getLocation();
        WarpLocationSpawn warpLocationSpawn2 = warpLocationSpawn = new WarpLocationSpawn();
        Location location2 = location;
        WarpLocationSpawn warpLocationSpawn3 = warpLocationSpawn;
        Location location3 = location;
        warpLocationSpawn.setX(location3.getX());
        warpLocationSpawn3.setY(location3.getY());
        warpLocationSpawn3.setZ(location.getZ());
        warpLocationSpawn.setYaw(location2.getYaw());
        warpLocationSpawn2.setPitch(location2.getPitch());
        warpLocationSpawn2.setWorld(Objects.requireNonNull(location.getWorld()).getName());
        return JsonUtil.toJson(warpLocationSpawn);
    }

    public static boolean tpCheck(Player a2, WarpPlayer a3) {
        String string;
        long l2;
        if (a3.getExpirationTime() != null && a3.getExpirationTime().getTime() < System.currentTimeMillis()) {
            MessageUtil.sendMessage(a2, BaseUtil.getMsgNotColor(StrUtil.IiiIIi("?!\u0006/#>\u001c=6")));
            return false;
        }
        long l3 = WarpPermissionUtil.getWaitTime(a2);
        if (WarpConstants.WAIT_TIME.containsKey(a2.getUniqueId()) && (l2 = (System.currentTimeMillis() - WarpConstants.WAIT_TIME.get(a2.getUniqueId())) / 1000L) < l3) {
            String string2 = BaseUtil.getLangMsg(ItemStackUtil.IiiIIi("\u0000\u001c\u001e\t#\u0014\u001a\u0018")).replace(StrUtil.IiiIIi("u5&/8:\u0005'<+,"), String.valueOf(l3 - l2));
            MessageUtil.sendMessage(a2, string2);
            return false;
        }
        boolean bl = BaseConstants.CONFIG.getBoolean(new StringBuilder().insert(0, ItemStackUtil.IiiIIi("\r\u0012\u000f\u001a\u0014\u0004\u000e\u001e\u0012\u0019S")).append(a3.getId()).toString());
        if (bl && !a2.hasPermission(string = new StringBuilder().insert(0, StrUtil.IiiIIi(">=/(+#\u00190<!`%>\u007f")).append(a3.getId()).toString())) {
            String string3 = BaseUtil.getLangMsg(ItemStackUtil.IiiIIi("\u0019\u0012#\r'\u0018\u0005\u0010\u001e\u000e\u0004\u0014\u0018\u0013")).replace(StrUtil.IiiIIi("u5!+##8=\"'> ,"), string);
            MessageUtil.sendMessage(a2, string3);
            return false;
        }
        return true;
    }

    private static /* synthetic */ Optional<Location> XXXXxX(String a2, String a3) {
        WorldCreator worldCreator;
        WarpLocationSpawn warpLocationSpawn = JsonUtil.toBean(a2, WarpLocationSpawn.class);
        World world = Bukkit.getWorld((String)warpLocationSpawn.getWorld());
        if (world == null) {
            worldCreator = new WorldCreator(warpLocationSpawn.getWorld());
            world = Bukkit.getServer().createWorld(worldCreator);
        }
        if (world == null) {
            return Optional.empty();
        }
        worldCreator = new Location(world, warpLocationSpawn.getX(), warpLocationSpawn.getY(), warpLocationSpawn.getZ(), warpLocationSpawn.getYaw(), warpLocationSpawn.getPitch());
        return Optional.of(WarpUtil.iIiiiI((Location)worldCreator, a3));
    }

    public static boolean addWarp(Player a2, String a3, Integer a42) {
        WarpPlayer warpPlayer;
        if (!WarpUtil.check(a2, a3)) {
            return false;
        }
        String string = ItemStackUtil.itemStackSerialize(ItemStackUtil.getItemStack(BaseConstants.CONFIG.getString(StrUtil.IiiIIi("5+7/$\"%\u0002>)>"), ItemStackUtil.IiiIIi("<'-;8"))));
        WarpPlayer warpPlayer2 = warpPlayer = new WarpPlayer();
        WarpPlayer warpPlayer3 = warpPlayer;
        WarpPlayer warpPlayer4 = warpPlayer;
        WarpPlayer warpPlayer5 = warpPlayer;
        WarpPlayer warpPlayer6 = warpPlayer;
        Player player = a2;
        warpPlayer.setPlayerName(player.getName());
        warpPlayer6.setPlayerUuid(player.getUniqueId());
        warpPlayer6.setName(a3);
        warpPlayer6.setType(WarpTypeEnum.ARCHITECT.getType());
        warpPlayer5.setLogoId(-1);
        warpPlayer5.setLogoName(string);
        warpPlayer4.setPrice(0);
        warpPlayer4.setServerName(BaseConstants.CONFIG.getString(StrUtil.IiiIIi("=4<'+#\u00000#4")));
        warpPlayer4.setWorldName(a2.getWorld().getName());
        warpPlayer3.setTpNumber(0);
        warpPlayer3.setThermalValue(0);
        warpPlayer2.setDisplay(BaseConstants.CONFIG.getBoolean(ItemStackUtil.IiiIIi("\u0019\u001e\u000e\u0007\u0011\u0016\u0004"), true));
        warpPlayer2.setWarpLocation(WarpUtil.getWarpLocationSpawn(a2));
        WarpPlayer warpPlayer7 = warpPlayer;
        warpPlayer2.setCreateTime(new Date());
        if (a42 != null && a42 > 0) {
            WarpPlayer warpPlayer8 = warpPlayer;
            warpPlayer8.setExpirationTime(DateUtil.offset(warpPlayer8.getCreateTime(), 12, a42));
        } else {
            warpPlayer.setExpirationTime(DateUtil.getDate(36500));
        }
        int a42 = WarpPlayerService.getInstance().add(warpPlayer);
        MessageUtil.sendMessage(a2, ConfigUtil.CREATE_CONFIG.getString(StrUtil.IiiIIi("-#+0:4\u001d$-2+4*\u001c=6")));
        string = ConfigUtil.CREATE_CONFIG.getString(ItemStackUtil.IiiIIi("\u001e\u0005\u0018\u0016\t\u0012.\u0002\u001e\u0014\u0018\u0012\u00196\u0011\u001b0\u0004\u001a"));
        if (StrUtil.isNotEmpty(string)) {
            string = string.replace(StrUtil.IiiIIi("u5!\"074<,"), a2.getName()).replace(ItemStackUtil.IiiIIi("Y\f\u0013\u0016\u0010\u0012\u0000"), a3);
            MessageUtil.sendAllMessage(string);
        }
        Player player2 = a2;
        int n = a42;
        WarpCreateSuccessEvent.callBuffEvent(player2, n);
        WarpUtil.xXxXXX(player2, n);
        return true;
    }

    private static /* synthetic */ void j(Player a2, WarpPlayer a3) {
        Object object;
        Player player = a2;
        WarpUtil.executionCommand(player, ItemStackUtil.IiiIIi("\u001e\u0018\u0010\u001a\u001c\u0019\u0019"), a3.getName());
        long l2 = WarpPermissionUtil.getDelayTime(player);
        if (l2 > 0L) {
            object = BaseUtil.getLangMsg(StrUtil.IiiIIi("5+=/(\u001a8#4")).replace(ItemStackUtil.IiiIIi("S\u0006\u0013\u0018\u001b\u001c\u000e)\u001e\u0010\u0012\u0000"), String.valueOf(l2));
            MessageUtil.sendMessage(a2, (String)object);
        }
        WarpConstants.DELAY_TIME.put(a2.getUniqueId(), false);
        object = new WarpTaskRunnable(a2, a3);
        HandySchedulerUtil.runTaskLater((HandyRunnable)object, l2 * 20L);
    }

    public static boolean editName(Player a2, String a3) {
        if (!WarpUtil.check(a2, a3)) {
            return false;
        }
        Optional<WarpPlayer> optional = WarpConstants.CHAT_CACHE_ID_MAP.get(a2.getUniqueId());
        if (optional == null) {
            return true;
        }
        optional = WarpPlayerService.getInstance().findById((Integer)((Object)optional));
        if (!optional.isPresent()) {
            return true;
        }
        optional = (WarpPlayer)optional.get();
        ((WarpPlayer)((Object)optional)).setName(a3);
        WarpPlayerService.getInstance().update((WarpPlayer)((Object)optional));
        MessageUtil.sendMessage(a2, ConfigUtil.ADMIN_CONFIG.getString(StrUtil.IiiIIi("!:\u00000#4\f$:%!?"), "").replace(ItemStackUtil.IiiIIi("Y\f\u0013\u0016\u0010\u0012\u0000"), a3));
        return true;
    }

    public static void tpWarpLocation(Player a2, WarpPlayer a3) {
        Object object = BaseConstants.CONFIG.getString(StrUtil.IiiIIi("=4<'+#\u00000#4"));
        if (a3.getServerName().equalsIgnoreCase((String)object)) {
            WarpUtil.j(a2, a3.getName(), a3.getWarpLocation(), a3.getWarpOffset());
            return;
        }
        object = new WarpChannel();
        WarpPlayer warpPlayer = a3;
        Object object2 = object;
        WarpPlayer warpPlayer2 = a3;
        Object object3 = object;
        ((WarpChannel)object3).setPlayerName(a2.getName());
        ((WarpChannel)object3).setPlayerUuid(a2.getUniqueId());
        ((WarpChannel)object).setWarpName(warpPlayer2.getName());
        ((WarpChannel)object2).setServerName(warpPlayer2.getServerName());
        ((WarpChannel)object2).setWarpLocation(a3.getWarpLocation());
        ((WarpChannel)object).setWarpOffset(warpPlayer.getWarpOffset());
        WarpChannelService.getInstance().add((WarpChannel)object);
        BcUtil.tpConnect(a2, warpPlayer.getServerName());
    }

    private static /* synthetic */ Location iIiiiI(Location a2, String a32) {
        Material material;
        Material material2;
        Material material3;
        int n;
        if (StrUtil.isEmpty((CharSequence)a32)) {
            return a2;
        }
        if ((a32 = a32.split(StrUtil.IiiIIi("}"))).length != 2) {
            return a2;
        }
        int a32 = Integer.parseInt(a32[0]);
        int n2 = Integer.parseInt(a32[1]);
        Random random = new Random();
        a32 = random.nextInt(a32 * 2 + 1) - a32;
        n2 = random.nextInt(n2 * 2 + 1) - n2;
        Location location = a2;
        World world = location.getWorld();
        a32 = location.getBlockX() + a32;
        n2 = location.getBlockZ() + n2;
        int n3 = n = location.getBlockY();
        while (n3 < Objects.requireNonNull(world).getMaxHeight() - 1) {
            World world2 = world;
            material3 = world2.getBlockAt(a32, n, n2).getType();
            material2 = world2.getBlockAt(a32, n + 1, n2).getType();
            material = world2.getBlockAt(a32, n - 1, n2).getType();
            if (material3 == Material.AIR && material2 == Material.AIR && material != Material.AIR) {
                return new Location(world, (double)a32 + 0.5, (double)n, (double)n2 + 0.5);
            }
            n3 = ++n;
        }
        int n4 = n = world.getMaxHeight() - 2;
        while (n4 > 0) {
            World world3 = world;
            material3 = world3.getBlockAt(a32, n, n2).getType();
            material2 = world3.getBlockAt(a32, n + 1, n2).getType();
            material = world3.getBlockAt(a32, n - 1, n2).getType();
            if (material3 == Material.AIR && material2 == Material.AIR && material != Material.AIR) {
                return new Location(world, (double)a32 + 0.5, (double)n, (double)n2 + 0.5);
            }
            n4 = --n;
        }
        return a2;
    }
}

