/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib;

import cn.handyplus.warp.lib.AssertUtil;
import cn.handyplus.warp.lib.BaseConstants;
import cn.handyplus.warp.lib.BcUtil;
import cn.handyplus.warp.lib.CollUtil;
import cn.handyplus.warp.lib.FormulaUtil;
import cn.handyplus.warp.lib.HandyHttpUtil;
import cn.handyplus.warp.lib.HookPluginEnum;
import cn.handyplus.warp.lib.ItemStackUtil;
import cn.handyplus.warp.lib.JsonUtil;
import cn.handyplus.warp.lib.LegacyUtil;
import cn.handyplus.warp.lib.MessageUtil;
import cn.handyplus.warp.lib.NetUtil;
import cn.handyplus.warp.lib.PatternUtil;
import cn.handyplus.warp.lib.RgbTextUtil;
import cn.handyplus.warp.lib.StrUtil;
import cn.handyplus.warp.lib.TranslationUtil;
import cn.handyplus.warp.lib.VersionCheckEnum;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class BaseUtil {
    public static OfflinePlayer getOfflinePlayer(@NotNull UUID playerUuid) {
        return Bukkit.getOfflinePlayer((UUID)playerUuid);
    }

    public static Boolean isPlayer(@NotNull CommandSender sender) {
        return sender instanceof Player;
    }

    public static Optional<Biome> getBiome(@NotNull String biome) {
        try {
            return Optional.of(LegacyUtil.getBiome(biome));
        }
        catch (Exception exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, BcUtil.yvIhFi("Q\tB._\u0003[\t\u0016\u53bd\u7529\u5f6e\u5e0e"), exception);
            }
            return Optional.empty();
        }
    }

    public static boolean hook(@NotNull HookPluginEnum hookPluginEnum) {
        return BaseUtil.hook(hookPluginEnum.getName(), hookPluginEnum.getSuccessMsg(), hookPluginEnum.getFailMsg());
    }

    public static Boolean isNotPlayer(@NotNull CommandSender sender) {
        return BaseUtil.isPlayer(sender) == false;
    }

    public static int getFirstPluginVersion(@NotNull Plugin plugin) {
        return Integer.parseInt(plugin.getDescription().getVersion().split(BcUtil.yvIhFi("0\u0018"))[0]);
    }

    public static OfflinePlayer getOfflinePlayer(@NotNull String playerName) {
        return Bukkit.getOfflinePlayer((String)playerName);
    }

    public static void readJsonFileToJsonCacheMap(@NotNull File file) {
        try {
            Optional<String> optional = BaseUtil.readJsonFile(file);
            optional.ifPresent(a -> {
                BaseConstants.JSON_CACHE_MAP = JsonUtil.toMap(a);
            });
            return;
        }
        catch (Throwable throwable) {
            MessageUtil.sendConsoleDebugMessage(BcUtil.yvIhFi("\u8bcd\u53ba_\u0018S\u0001\u0018\u0006E\u0003X\u5f6e\u5e0e"));
            return;
        }
    }

    public static Integer convertVersion(@NotNull String version) {
        int n;
        String[] stringArray = version.replaceAll(BcUtil.yvIhFi("7h0RBk"), "");
        if (!stringArray.contains(".")) {
            return Integer.parseInt((String)stringArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringArray = stringArray.split(FormulaUtil.b("\u0010\u007f"));
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            String string = stringArray[n];
            if (string.length() == 1) {
                stringBuilder.append(BcUtil.yvIhFi("\u0006"));
            }
            stringBuilder.append(string);
            n3 = ++n;
        }
        return Integer.parseInt(stringBuilder.toString());
    }

    public static String getLangMsg(@NotNull String langMsg) {
        return BaseUtil.getLangMsg(langMsg, "");
    }

    public static Optional<EntityType> getEntityType(@NotNull String key) {
        try {
            return Optional.of(EntityType.valueOf((String)key.toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    public static Optional<Player> getOnlinePlayer(@NotNull UUID playerUuid) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null || !player.isOnline()) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public static String getMsgNotColor(@NotNull String langMsg, @NotNull Map<String, String> replaceMap) {
        String string = BaseUtil.getMsgNotColor(langMsg, "");
        if (replaceMap != null) {
            Iterator<String> iterator;
            Iterator<String> iterator2 = iterator = replaceMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2;
                String string3 = string2 = iterator.next();
                string = string.replace(string3, replaceMap.get(string3));
                iterator2 = iterator;
            }
        }
        return string;
    }

    public static Player getOnlinePlayer(@NotNull CommandSender sender, @NotNull String playerName, @NotNull String msg) {
        if (StrUtil.isEmpty(playerName)) {
            return AssertUtil.notPlayer(sender, msg);
        }
        return BaseUtil.getOnlinePlayer(playerName).orElseThrow(() -> new RuntimeException(msg));
    }

    public static boolean hook(@NotNull String pluginName, @NotNull String succeedMsgNode, @NotNull String failureMsgNode) {
        Optional<Plugin> optional = BaseUtil.hook(pluginName);
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(optional.isPresent() ? succeedMsgNode : failureMsgNode));
        return optional.isPresent();
    }

    private static /* synthetic */ String b(@NotNull String str) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = str.toCharArray();
        int n2 = cArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            char c2 = cArray[n];
            stringBuilder.append(c2);
            stringBuilder.append(c2);
            n3 = ++n;
        }
        return stringBuilder.toString();
    }

    public static Optional<Plugin> hookToPlugin(@NotNull HookPluginEnum hookPluginEnum) {
        Optional<Plugin> optional = BaseUtil.hook(hookPluginEnum.getName());
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(optional.isPresent() ? hookPluginEnum.getSuccessMsg() : hookPluginEnum.getFailMsg()));
        return optional;
    }

    public static String replaceChatColor(@NotNull String str) {
        if (StrUtil.isEmpty(str)) {
            return "";
        }
        String string = str.replace(FormulaUtil.b("w"), BcUtil.yvIhFi("\u0091"));
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_16.getVersionId()) {
            return string;
        }
        return BaseUtil.JfmsaS(string);
    }

    public static Optional<Player> getOnlinePlayer(@NotNull String playerName) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null || !player.isOnline()) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public static List<String> replaceChatColor(@NotNull List<String> strList) {
        Iterator<String> iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (CollUtil.isEmpty(strList)) {
            return arrayList;
        }
        Iterator<String> iterator2 = iterator = strList.iterator();
        while (iterator2.hasNext()) {
            String string = iterator.next();
            iterator2 = iterator;
            arrayList.add(BaseUtil.replaceChatColor(string));
        }
        return arrayList;
    }

    public static int getTwoPluginVersion(@NotNull Plugin plugin) {
        return Integer.parseInt(plugin.getDescription().getVersion().split(FormulaUtil.b("\u0010\u007f"))[1]);
    }

    public static void isPrimaryThread(@NotNull String name) {
        if (!BaseConstants.DEBUG) {
            return;
        }
        MessageUtil.sendConsoleMessage(new StringBuilder().insert(0, name).append(FormulaUtil.b("vq")).append(Bukkit.isPrimaryThread()).toString());
    }

    public static boolean hook(@NotNull String pluginName, @NotNull String succeedMsgNode, @NotNull String failureMsgNode, @NotNull Integer version) {
        Optional<Object> optional = BaseUtil.hook(pluginName);
        if (optional.isPresent() && BaseUtil.getFirstPluginVersion(optional.get()) < version) {
            optional = Optional.empty();
        }
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(optional.isPresent() ? succeedMsgNode : failureMsgNode));
        return optional.isPresent();
    }

    @NotNull
    public static String getDisplayName(ItemStack a) {
        if (a == null) {
            a = new ItemStack(Material.AIR);
        }
        ItemStack itemStack = a;
        Object object = ItemStackUtil.getItemMeta(itemStack);
        String string = itemStack.getType().name();
        if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_20_5.getVersionId() && object.hasItemName()) {
            return object.getItemName();
        }
        if (object.hasDisplayName()) {
            return object.getDisplayName();
        }
        object = TranslationUtil.getMaterialTranslation(string);
        if (StrUtil.isNotEmpty((CharSequence)object)) {
            return object;
        }
        if (!BaseConstants.ITEM_JSON_CACHE_MAP.isEmpty() && (object = BaseConstants.ITEM_JSON_CACHE_MAP.get(string)) != null) {
            return object;
        }
        if (!BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.isEmpty()) {
            if (a.getDurability() > 0 && StrUtil.isNotEmpty((CharSequence)(object = BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.get(new StringBuilder().insert(0, string).append(FormulaUtil.b("\u000e")).append(a.getDurability()).toString())))) {
                return object;
            }
            object = BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.get(string);
            if (object != null) {
                return object;
            }
        }
        return string;
    }

    public static Optional<Plugin> hook(@NotNull String pluginName) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        if (plugin != null && plugin.isEnabled()) {
            return Optional.of(plugin);
        }
        return Optional.empty();
    }

    public static UUID getUuid(@NotNull String playerName) {
        return Bukkit.getOfflinePlayer((String)playerName).getUniqueId();
    }

    private static /* synthetic */ String JfmsaS(@NotNull String str) {
        Matcher matcher = PatternUtil.RPG_PATTERN.matcher(str);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher2 = matcher;
        while (matcher2.find()) {
            String string = matcher.group();
            if (string.length() == 5) {
                string = new StringBuilder().insert(0, string.substring(0, 2)).append(BaseUtil.b(string.substring(2))).toString();
            }
            Matcher matcher3 = matcher;
            matcher2 = matcher3;
            matcher3.appendReplacement(stringBuffer, ChatColor.of((String)string.substring(1)).toString());
        }
        matcher.appendTail(stringBuffer);
        return ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)stringBuffer.toString());
    }

    public static Optional<Sound> getSound(@NotNull String sound) {
        try {
            return Optional.of(LegacyUtil.getSound(sound));
        }
        catch (Exception exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, FormulaUtil.b("6)%\u001f>9?(q\u539d\u754e\u5f4e\u5e69"), exception);
            }
            return Optional.empty();
        }
    }

    public static String getMsgNotColor(@NotNull String langMsg) {
        return BaseUtil.getMsgNotColor(langMsg, "");
    }

    public static void sendTip(@NotNull CommandSender sender) {
        String string = BaseConstants.CONFIG.getString("signType", "mac");
        String string2 = string = "mac".equalsIgnoreCase(string) ? NetUtil.getLocalMacAddress() : HandyHttpUtil.getIp();
        if (BaseUtil.isPlayer(sender).booleanValue() && BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_15.getVersionId()) {
            RgbTextUtil rgbTextUtil = RgbTextUtil.getInstance().init(string);
            String string3 = BaseUtil.getMsgNotColor(FormulaUtil.b("/><("), BcUtil.yvIhFi("\u0010\u001e\u0016L\u0016J\u000e7\u0010\r\u708f\u5197\u593b\u525a\u0010Tk"));
            rgbTextUtil.addExtra(RgbTextUtil.getInstance().init(string3).addClickCopyToClipboard(string).build());
            rgbTextUtil.send(sender);
            return;
        }
        MessageUtil.sendMessage(sender, string);
    }

    private /* synthetic */ BaseUtil() {
        BaseUtil a;
    }

    public static boolean hook(@NotNull HookPluginEnum hookPluginEnum, @NotNull Integer version) {
        return BaseUtil.hook(hookPluginEnum.getName(), hookPluginEnum.getSuccessMsg(), hookPluginEnum.getFailMsg(), version);
    }

    public static String getLangMsg(@NotNull String langMsg, @NotNull String defaultMsg, boolean isColor) {
        if (StrUtil.isEmpty(langMsg)) {
            return defaultMsg;
        }
        FileConfiguration fileConfiguration = BaseConstants.LANG_CONFIG;
        if (fileConfiguration == null) {
            return defaultMsg;
        }
        defaultMsg = fileConfiguration.getString(langMsg, defaultMsg);
        if (isColor) {
            return BaseUtil.replaceChatColor(defaultMsg);
        }
        return defaultMsg;
    }

    public static String getMsgNotColor(@NotNull String langMsg, @NotNull String defaultMsg) {
        return BaseUtil.getLangMsg(langMsg, defaultMsg, false);
    }

    public static void readJsonFileToItemJsonCacheMap(@NotNull File file) {
        Optional<String> optional = BaseUtil.readJsonFile(file);
        if (optional.isPresent() && optional.get().length() > 1) {
            try {
                BaseConstants.ITEM_JSON_CACHE_MAP = JsonUtil.toMap(optional.get());
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Optional<String> readJsonFile(@NotNull File fileName) {
        StringBuilder stringBuilder;
        InputStreamReader inputStreamReader;
        FileReader fileReader;
        try {
            int n;
            fileReader = new FileReader(fileName);
            inputStreamReader = new InputStreamReader(Files.newInputStream(fileName.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            stringBuilder = new StringBuilder();
            InputStreamReader inputStreamReader2 = inputStreamReader;
            while ((n = ((Reader)inputStreamReader2).read()) != -1) {
                inputStreamReader2 = inputStreamReader;
                stringBuilder.append((char)n);
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, FormulaUtil.b("#)0(\u001b?>\"\u0017%=)q\u539d\u754e\u5f4e\u5e69"), exception);
            return Optional.empty();
        }
        fileReader.close();
        ((Reader)inputStreamReader).close();
        return Optional.of(stringBuilder.toString());
    }

    public static String stripColor(@NotNull String str) {
        if (StrUtil.isEmpty(str)) {
            return "";
        }
        return ChatColor.stripColor((String)BaseUtil.replaceChatColor(str));
    }

    public static String getLangMsg(@NotNull String langMsg, @NotNull String defaultMsg) {
        return BaseUtil.getLangMsg(langMsg, defaultMsg, true);
    }
}

