/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib;

import cn.handyplus.warp.service.WarpChannelService;
import cn.handyplus.warp.util.WarpTaskUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class DateUtil {
    public static final String ZERO = "00:00";
    public static final String YYYY = "yyyy-MM-dd";
    public static final String HH_MM = "HH:mm";
    public static final String YYYY_HH = "yyyy-MM-dd HH:mm:ss";

    public static long between(@NotNull Date dateOne, @NotNull Date dateTwo, @NotNull ChronoUnit unit) {
        return unit.between(DateUtil.toLocalDateTime(dateOne), DateUtil.toLocalDateTime(dateTwo));
    }

    public static Date getFirstDayOfMonth() {
        return DateUtil.toDate(LocalDateTime.now().withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS));
    }

    public static Date endOfDay(@NotNull Date date) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        Calendar calendar3 = calendar;
        calendar.setTime(date);
        calendar3.set(11, 23);
        calendar3.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        return calendar2.getTime();
    }

    public static Date addDate(@NotNull Date date, @NotNull Integer day) {
        return DateUtil.offset(date, 5, day);
    }

    public static Date getMonday() {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setFirstDayOfWeek(2);
        calendar2.setTimeInMillis(DateUtil.getToday().getTime());
        calendar2.set(7, 2);
        return calendar2.getTime();
    }

    private /* synthetic */ DateUtil() {
        DateUtil a;
    }

    public static Date getMonth(@NotNull Date date, int month) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setFirstDayOfWeek(2);
        calendar2.setTimeInMillis(date.getTime());
        calendar2.set(5, month);
        return calendar2.getTime();
    }

    public static Date getWeek(@NotNull Date date, int week) {
        Calendar calendar;
        if (++week > 7) {
            week = 1;
        }
        Calendar calendar2 = calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setFirstDayOfWeek(2);
        calendar2.setTimeInMillis(date.getTime());
        calendar2.set(7, week);
        return calendar2.getTime();
    }

    public static Date getFirstDayOfMonth(@NotNull Date date) {
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS));
    }

    public static Date getToday() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YYYY);
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            date = simpleDateFormat2.parse(simpleDateFormat2.format(date));
            return date;
        }
        catch (ParseException parseException) {
            Bukkit.getLogger().log(Level.SEVERE, WarpChannelService.yvIhFi("\tJ\u001a{\u0001K\u000fVN\u53fe\u7571\u5f2d\u5e56"), parseException);
            return date;
        }
    }

    public static boolean isPerpetual(@NotNull Date date) {
        return date.getTime() > 4733481600000L;
    }

    public static String format(@NotNull Date date, @NotNull String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static Date beginOfDay(@NotNull Date date) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        Calendar calendar3 = calendar;
        calendar.setTime(date);
        calendar3.set(11, 0);
        calendar3.set(12, 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        return calendar2.getTime();
    }

    public static long between(@NotNull Date dateOne, @NotNull Date dateTwo) {
        return DateUtil.between(dateOne, dateTwo, ChronoUnit.HOURS);
    }

    public static Date getLastDayOfMonth() {
        return DateUtil.toDate(LocalDateTime.now().plusMonths(1L).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS).plus(-1L, ChronoUnit.MILLIS));
    }

    public static Date toDate(@NotNull LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getLastDayOfMonth(@NotNull Date date) {
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusMonths(1L).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS).plus(-1L, ChronoUnit.MILLIS));
    }

    public static long toEpochSecond(@NotNull LocalDateTime localDateTime) {
        return localDateTime.toInstant(ZoneOffset.of(WarpChannelService.yvIhFi("\u0004V"))).toEpochMilli();
    }

    public static Date getDate(@NotNull Integer day) {
        GregorianCalendar gregorianCalendar;
        Date date = new Date();
        GregorianCalendar gregorianCalendar2 = gregorianCalendar = new GregorianCalendar();
        gregorianCalendar2.setTime(date);
        ((Calendar)gregorianCalendar2).add(5, day);
        return gregorianCalendar2.getTime();
    }

    public static Date offset(@NotNull Date date, int field, int offset) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        calendar2.setTime(date);
        calendar2.add(field, offset);
        return calendar2.getTime();
    }

    public static Date getTodayEnd() {
        return DateUtil.endOfDay(DateUtil.getToday());
    }

    public static Date getSunday() {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance(Locale.CHINA);
        calendar2.setFirstDayOfWeek(2);
        calendar2.setTimeInMillis(DateUtil.getToday().getTime());
        calendar2.set(7, 1);
        return DateUtil.parse(new StringBuilder().insert(0, DateUtil.format(calendar.getTime(), YYYY)).append(WarpTaskUtil.yvIhFi("envfpe\u007fi|")).toString(), YYYY_HH);
    }

    public static LocalDateTime toLocalDateTime(@NotNull Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static int getDifferDay(@NotNull Long dateTime) {
        return (int)((System.currentTimeMillis() - dateTime) / 86400000L);
    }

    public static Integer dayOfWeekEnum(@NotNull Date date) {
        Calendar calendar;
        Integer[] integerArray = new Integer[7];
        integerArray[0] = 7;
        integerArray[1] = 1;
        integerArray[2] = 2;
        integerArray[3] = 3;
        integerArray[4] = 4;
        integerArray[5] = 5;
        integerArray[6] = 6;
        Integer[] integerArray2 = integerArray;
        Calendar calendar2 = calendar = Calendar.getInstance();
        calendar2.setTime(date);
        return integerArray2[calendar2.get(7) - 1];
    }

    public static Date parse(@NotNull String str, @NotNull String format2) {
        format2 = new SimpleDateFormat((String)format2);
        try {
            return ((DateFormat)format2).parse(str);
        }
        catch (ParseException format2) {
            Bukkit.getLogger().log(Level.SEVERE, WarpTaskUtil.yvIhFi(",$.69e\u538d\u755a\u5f5e\u5e7d"), format2);
            return null;
        }
    }
}

