/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib;

import cn.handyplus.warp.lib.BaseConstants;
import cn.handyplus.warp.lib.BaseUtil;
import cn.handyplus.warp.lib.CollUtil;
import cn.handyplus.warp.lib.ItemMetaUtil;
import cn.handyplus.warp.lib.MessageUtil;
import cn.handyplus.warp.lib.SqlService;
import cn.handyplus.warp.lib.StrUtil;
import cn.handyplus.warp.lib.VersionCheckEnum;
import cn.handyplus.warp.lib.expand.XMaterial;
import cn.handyplus.warp.lib.expand.adapter.PlayerSchedulerUtil;
import cn.handyplus.warp.service.WarpChannelService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;

public final class ItemStackUtil {
    public static boolean isSimilar(ItemStack a, ItemStack a2) {
        MaterialData materialData;
        MaterialData materialData2;
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (!a.getType().equals((Object)a2.getType())) {
            return false;
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_13.getVersionId()) {
            materialData2 = a.getData();
            materialData = a2.getData();
            if (materialData2 != null && materialData != null && materialData2.getData() != materialData.getData()) {
                return false;
            }
        }
        if ((materialData2 = a.getItemMeta()) == (materialData = a2.getItemMeta())) {
            return true;
        }
        if (materialData2 == null || materialData == null) {
            return false;
        }
        if (!StrUtil.equals(materialData2.getDisplayName(), materialData.getDisplayName())) {
            return false;
        }
        if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_20_5.getVersionId() && materialData2.hasItemName() && materialData.hasItemName() && !StrUtil.equals(materialData2.getItemName(), materialData.getItemName())) {
            return false;
        }
        return CollUtil.equals(materialData2.getLore(), materialData.getLore());
    }

    public static void setPersistentData(ItemStack a, String a2, String a3) {
        ItemStack itemStack = a;
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemMetaUtil.setPersistentData(itemMeta, a2, a3);
        itemStack.setItemMeta(itemMeta);
    }

    private static /* synthetic */ ItemStack PAQzxl(String a, Material a2) {
        if (a.contains(":")) {
            String[] stringArray = a.split(":");
            Material material = Material.getMaterial((String)stringArray[0]);
            if (stringArray.length == 2 && material != null) {
                short s = (short)Integer.parseInt(stringArray[1]);
                return new ItemStack(material, 1, s);
            }
        }
        return new ItemStack(a2);
    }

    public static Boolean removeItem(Player a, ItemStack a2, Integer a3) {
        return ItemStackUtil.removeItem(a, a2, a3, true);
    }

    public static ItemStack getItemStack(String a, String a2, List<String> a3, Boolean a4, int a5, boolean a6, Map<String, String> a7) {
        return ItemStackUtil.getItemStack(a, a2, a3, a4, a5, a6, a7, false);
    }

    public static ItemStack getItemStack(String a, String a2, List<String> a3, boolean a4, int a5, boolean a6, Map<String, String> a7, boolean a8, String a9) {
        return ItemStackUtil.getItemStack(a, a2, a3, a4, a5, a6, a7, a8, a9, null);
    }

    public static void setOwner(ItemStack a, String a2) {
        if (a == null || StrUtil.isEmpty(a2)) {
            return;
        }
        ItemMeta itemMeta = a.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return;
        }
        ItemMeta itemMeta2 = itemMeta = (SkullMeta)itemMeta;
        ItemMetaUtil.setOwner((SkullMeta)itemMeta2, a2);
        a.setItemMeta(itemMeta2);
    }

    public static Optional<String> getPersistentData(ItemStack a, String a2) {
        return ItemMetaUtil.getPersistentData(a.getItemMeta(), a2);
    }

    public static ItemStack getItemStack(String a, String a2, List<String> a3) {
        return ItemStackUtil.getItemStack(a, a2, a3, false);
    }

    public static boolean addItem(Player a, ItemStack a2) {
        return ItemStackUtil.addItem(a, a2, BaseUtil.getMsgNotColor(WarpChannelService.yvIhFi("N\nK'[\u000bB#\\\t")));
    }

    public static ItemStack getItemStack(String a, String a2, List<String> a3, Boolean a4) {
        return ItemStackUtil.getItemStack(a, a2, a3, a4, 0);
    }

    public static ItemMeta getItemMeta(ItemStack a) {
        ItemMeta itemMeta;
        if (a == null) {
            a = new ItemStack(Material.STONE);
        }
        if ((itemMeta = a.getItemMeta()) == null) {
            return new ItemStack(Material.STONE).getItemMeta();
        }
        return itemMeta;
    }

    public static String itemStackSerialize(ItemStack a) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.set(WarpChannelService.yvIhFi("F\u001aJ\u0003"), (Object)a);
        return yamlConfiguration.saveToString();
    }

    public static ItemStack getItemStack(String a, String a2, List<String> a3, Boolean a4, int a5, boolean a6) {
        return ItemStackUtil.getItemStack(a, a2, a3, a4, a5, a6, null);
    }

    public static Boolean containsItem(PlayerInventory a, ItemStack a2, Integer a3, boolean a4) {
        int n;
        block2: {
            int n2;
            ItemStack[] itemStackArray = BaseConstants.VERSION_ID <= VersionCheckEnum.V_1_8_8.getVersionId() ? a.getContents() : a.getStorageContents();
            int n3 = 0;
            int n4 = itemStackArray.length;
            int n5 = n2 = 0;
            while (n5 < n4) {
                ItemStack itemStack = itemStackArray[n2];
                if (itemStack != null && !Material.AIR.equals((Object)itemStack.getType()) && !(!a4 ? !ItemStackUtil.isSimilar(itemStack, a2) : !itemStack.isSimilar(a2)) && (n3 += itemStack.getAmount()) >= a3) {
                    n = n3;
                    break block2;
                }
                n5 = ++n2;
            }
            n = n3;
        }
        return n >= a3;
    }

    public static ItemStack getItemByMaterial(String a) {
        return ItemStackUtil.getItemByMaterial(a, Material.STONE);
    }

    public static boolean addItem(Player a, String a2, int a3) {
        return ItemStackUtil.addItem(a, ItemStackUtil.itemStackDeserialize(a2), a3, BaseUtil.getMsgNotColor(SqlService.yvIhFi("d!a\fq h\bv\"")));
    }

    public static ItemStack itemStackDeserialize(String a, Material a2) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try {
            yamlConfiguration.loadFromString(a);
            yamlConfiguration = yamlConfiguration.getItemStack(SqlService.yvIhFi("l1`("), new ItemStack(a2));
            return yamlConfiguration;
        }
        catch (Exception exception) {
            yamlConfiguration = new ItemStack(a2);
            return yamlConfiguration;
        }
    }

    public static ItemStack itemStackDeserialize(String a) {
        return ItemStackUtil.itemStackDeserialize(a, Material.AIR);
    }

    public static void setSkull(ItemStack a, String a2) {
        if (a == null || StrUtil.isEmpty(a2)) {
            return;
        }
        ItemMeta itemMeta = a.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return;
        }
        ItemMeta itemMeta2 = itemMeta = (SkullMeta)itemMeta;
        ItemMetaUtil.setSkull((SkullMeta)itemMeta2, a2);
        a.setItemMeta(itemMeta2);
    }

    public static void setItemInMainHand(PlayerInventory a, ItemStack a2) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            a.setItemInHand(a2);
            return;
        }
        a.setItemInMainHand(a2);
    }

    public static ItemStack getItemStack(String a, String a2, List<String> a3, Boolean a4, int a5) {
        return ItemStackUtil.getItemStack(a, a2, a3, a4, a5, false);
    }

    public static int getItemAmount(Player a, ItemStack a2, boolean a3) {
        int n;
        if (a == null || !a.isOnline()) {
            return 0;
        }
        PlayerInventory playerInventory = a.getInventory();
        ItemStack[] itemStackArray = BaseConstants.VERSION_ID <= VersionCheckEnum.V_1_8_8.getVersionId() ? playerInventory.getContents() : playerInventory.getStorageContents();
        int n2 = 0;
        int n3 = itemStackArray.length;
        int n4 = n = 0;
        while (n4 < n3) {
            ItemStack itemStack = itemStackArray[n];
            if (itemStack != null && !Material.AIR.equals((Object)itemStack.getType()) && !(a3 ? !itemStack.isSimilar(a2) : !ItemStackUtil.isSimilar(itemStack, a2))) {
                n2 += itemStack.getAmount();
            }
            n4 = ++n;
        }
        return n2;
    }

    public static List<String> loreReplaceMap(List<String> a, Map<String, String> a2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (a2 != null && !a2.isEmpty() && CollUtil.isNotEmpty(a)) {
            Iterator<String> iterator;
            Iterator<String> iterator2 = iterator = a.iterator();
            while (iterator2.hasNext()) {
                String string = iterator.next();
                for (String string2 : a2.keySet()) {
                    if (!string.contains(WarpChannelService.yvIhFi("\u000b\u0015") + string2 + SqlService.yvIhFi("8")) || a2.get(string2) == null) continue;
                    String string3 = string2;
                    string = StrUtil.replace(string, string3, a2.get(string3));
                }
                arrayList.add(string);
                iterator2 = iterator;
            }
        } else {
            arrayList.addAll(a);
        }
        return arrayList;
    }

    public static String yvIhFi(String a) {
        int n = a.length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = (3 ^ 5) << 3 ^ (3 ^ 5);
        int cfr_ignored_0 = 4 << 4 ^ 3;
        int n4 = n2;
        int n5 = (3 ^ 5) << 3;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(a.charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(a.charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    public static List<String> loreBatchReplaceMap(String a, Map<String, List<String>> a2, String a3) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        block7: {
            arrayList2 = new ArrayList<String>();
            if (StrUtil.isEmpty(a)) {
                ArrayList<String> arrayList3 = arrayList2;
                arrayList3.add(a);
                return arrayList3;
            }
            if (a2 == null || a2.isEmpty()) {
                ArrayList<String> arrayList4 = arrayList2;
                arrayList4.add(a);
                return arrayList4;
            }
            if (StrUtil.isEmpty(a3)) {
                a3 = "";
            }
            for (String string : a2.keySet()) {
                if (!a.contains(WarpChannelService.yvIhFi("\u000b\u0015") + string + SqlService.yvIhFi("8"))) continue;
                List<String> list = a2.get(string);
                if (CollUtil.isEmpty(list)) {
                    ArrayList<String> arrayList5 = arrayList2;
                    arrayList = arrayList5;
                    arrayList5.add(StrUtil.replace(a, string, a3));
                    break block7;
                }
                Object object = list = list.iterator();
                while (object.hasNext()) {
                    String string2 = (String)list.next();
                    object = list;
                    arrayList2.add(StrUtil.replace(a, string, string2));
                }
                break block0;
            }
            arrayList = arrayList2;
        }
        if (CollUtil.isEmpty(arrayList)) {
            arrayList2.add(a);
        }
        return arrayList2;
    }

    public static ItemStack getItemByMaterial(String a, Material a2) {
        if (StrUtil.isEmpty(a)) {
            return new ItemStack(a2);
        }
        Material material = Material.getMaterial((String)(a = a.toUpperCase(Locale.ROOT)));
        if (material != null) {
            return new ItemStack(material);
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId() && (material = Material.getMaterial((String)new StringBuilder().insert(0, SqlService.yvIhFi("\t@\u0002D\u0006\\\u001a")).append(a).toString(), (boolean)true)) != null) {
            return new ItemStack(material);
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId()) {
            return ItemStackUtil.PAQzxl(a, a2);
        }
        return XMaterial.matchXMaterial(a).orElse(XMaterial.matchXMaterial(a2)).parseItem();
    }

    public static boolean addItem(Player a, ItemStack a2, String a3) {
        ItemStack[] itemStackArray = new ItemStack[1];
        itemStackArray[0] = a2;
        a2 = a.getInventory().addItem(itemStackArray);
        if (((HashMap)a2).isEmpty()) {
            return false;
        }
        PlayerSchedulerUtil.dropItem(a, new ArrayList<ItemStack>(((HashMap)a2).values()));
        MessageUtil.sendMessage(a, a3);
        return true;
    }

    public static Material getMaterial(String a) {
        return ItemStackUtil.getMaterial(a, Material.STONE);
    }

    public static boolean addItem(Player a, ItemStack a2, int a3) {
        return ItemStackUtil.addItem(a, a2, a3, BaseUtil.getMsgNotColor(WarpChannelService.yvIhFi("N\nK'[\u000bB#\\\t")));
    }

    public static Boolean removeItem(Player a, ItemStack a2, Integer a3, boolean a4) {
        int n;
        ArrayList<ItemStack> arrayList;
        int n2;
        Object object;
        PlayerInventory playerInventory;
        block11: {
            int n3;
            if (a == null || !a.isOnline()) {
                return false;
            }
            if (a3 < 1) {
                throw new RuntimeException(new StringBuilder().insert(0, SqlService.yvIhFi("\u6535\u91ca\u4e48\u80f8\u4e7f\u8d1a\u6535?e")).append(a3).toString());
            }
            playerInventory = a.getInventory();
            object = BaseConstants.VERSION_ID <= VersionCheckEnum.V_1_8_8.getVersionId() ? playerInventory.getContents() : playerInventory.getStorageContents();
            n2 = 0;
            arrayList = new ArrayList<ItemStack>();
            int n4 = ((ItemStack[])object).length;
            int n5 = n3 = 0;
            while (n5 < n4) {
                ItemStack itemStack = object[n3];
                if (itemStack != null && !Material.AIR.equals((Object)itemStack.getType()) && !(a4 ? !itemStack.isSimilar(a2) : !ItemStackUtil.isSimilar(itemStack, a2))) {
                    arrayList.add(itemStack);
                    if ((n2 += itemStack.getAmount()) >= a3) {
                        n = n2;
                        break block11;
                    }
                }
                n5 = ++n3;
            }
            n = n2;
        }
        if (n == a3) {
            Object object2 = object = arrayList.iterator();
            while (object2.hasNext()) {
                ItemStack itemStack = (ItemStack)object.next();
                ItemStack[] itemStackArray = new ItemStack[1];
                itemStackArray[0] = itemStack;
                playerInventory.removeItem(itemStackArray);
                object2 = object;
            }
            return true;
        }
        if (n2 > a3) {
            for (ItemStack itemStack : arrayList) {
                if (a3 == 0) {
                    return true;
                }
                if (a3 >= itemStack.getAmount()) {
                    a3 = a3 - itemStack.getAmount();
                    ItemStack[] itemStackArray = new ItemStack[1];
                    itemStackArray[0] = itemStack;
                    playerInventory.removeItem(itemStackArray);
                    continue;
                }
                ItemStack itemStack2 = itemStack;
                itemStack2.setAmount(itemStack2.getAmount() - a3);
                a3 = 0;
            }
            return true;
        }
        return false;
    }

    public static ItemStack getItemStack(String a, String a2) {
        return ItemStackUtil.getItemStack(a, a2, null);
    }

    public static ItemStack getItemStack(String a, String a2, List<String> a3, boolean a4, int a5, boolean a6, Map<String, String> a7, boolean a8, String a9, String a10, String a11) {
        ItemStack itemStack = ItemStackUtil.getItemByMaterial(a);
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        if (StrUtil.isNotEmpty(a2)) {
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(a2));
            if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_20_5.getVersionId()) {
                ItemMeta itemMeta2 = itemMeta;
                itemMeta2.setItemName(itemMeta2.getDisplayName());
            }
        }
        if (CollUtil.isNotEmpty(a3)) {
            itemMeta.setLore(BaseUtil.replaceChatColor(ItemStackUtil.loreReplaceMap(a3, a7)));
        }
        if (a4) {
            ItemMetaUtil.setEnchant(itemMeta);
        }
        if (a8) {
            ItemMetaUtil.hideEnchant(itemMeta);
        }
        if (a6) {
            ItemMetaUtil.hideAttributes(itemMeta);
        }
        ItemMeta itemMeta3 = itemMeta;
        ItemMetaUtil.setPersistentData(itemMeta, a9, WarpChannelService.yvIhFi("\\\u0017\\\u001aJ\u0003"));
        ItemMetaUtil.setCustomModelData(itemMeta3, a5);
        ItemMetaUtil.setTooltipStyle(itemMeta3, a10);
        ItemMetaUtil.setItemModel(itemMeta, a11);
        ItemStack itemStack2 = itemStack;
        itemStack2.setItemMeta(itemMeta);
        return itemStack2;
    }

    private /* synthetic */ ItemStackUtil() {
        ItemStackUtil a;
    }

    public static int getItemAmount(Player a, ItemStack a2) {
        return ItemStackUtil.getItemAmount(a, a2, true);
    }

    public static ItemStack getItemStack(String a) {
        return ItemStackUtil.getItemStack(a, null, null);
    }

    public static boolean addItem(Player a, ItemStack a2, int a3, String a4) {
        if (Material.AIR.equals((Object)a2.getType())) {
            return false;
        }
        if (CollUtil.isEmpty(a2 = ItemStackUtil.idulgM(a, a2, a3))) {
            return false;
        }
        PlayerSchedulerUtil.dropItem(a, (List<ItemStack>)a2);
        MessageUtil.sendMessage(a, a4);
        return true;
    }

    public static ItemStack getItemStack(String a, String a2, List<String> a3, boolean a4, int a5, boolean a6, Map<String, String> a7, boolean a8) {
        return ItemStackUtil.getItemStack(a, a2, a3, a4, a5, a6, a7, a8, null);
    }

    public static ItemStack getItemInMainHand(PlayerInventory a) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            return a.getItemInHand();
        }
        return a.getItemInMainHand();
    }

    public static boolean addItem(Player a, String a2) {
        return ItemStackUtil.addItem(a, ItemStackUtil.itemStackDeserialize(a2), BaseUtil.getMsgNotColor(SqlService.yvIhFi("d!a\fq h\bv\"")));
    }

    public static Material getMaterial(String a, Material a2) {
        if (StrUtil.isEmpty(a)) {
            return a2;
        }
        Material material = Material.getMaterial((String)(a = a.toUpperCase(Locale.ROOT)));
        if (material != null) {
            return material;
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId() && (material = Material.getMaterial((String)new StringBuilder().insert(0, WarpChannelService.yvIhFi("\"j)n-v1")).append(a).toString(), (boolean)true)) != null) {
            return material;
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId()) {
            return a2;
        }
        return XMaterial.matchXMaterial(a).orElse(XMaterial.matchXMaterial(a2)).parseMaterial();
    }

    public static List<String> loreBatchReplaceMap(List<String> a, Map<String, List<String>> a2, String a3) {
        Iterator<String> iterator;
        if (CollUtil.isEmpty(a) || a2 == null || a2.isEmpty()) {
            return a;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator2 = iterator = a.iterator();
        while (iterator2.hasNext()) {
            String string = iterator.next();
            iterator2 = iterator;
            arrayList.addAll(ItemStackUtil.loreBatchReplaceMap(string, a2, a3));
        }
        return arrayList;
    }

    private static /* synthetic */ List<ItemStack> idulgM(Player a, ItemStack a2, int a3) {
        PlayerInventory playerInventory = a.getInventory();
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        int n = a2.getMaxStackSize();
        if (a3 > n) {
            a2.setAmount(n);
            ItemStack[] itemStackArray = new ItemStack[1];
            itemStackArray[0] = a2;
            arrayList.addAll(playerInventory.addItem(itemStackArray).values());
            arrayList.addAll(ItemStackUtil.idulgM(a, a2, a3 - n));
            return arrayList;
        }
        a2.setAmount(a3);
        ItemStack[] itemStackArray = new ItemStack[1];
        itemStackArray[0] = a2;
        arrayList.addAll(playerInventory.addItem(itemStackArray).values());
        return arrayList;
    }

    public static ItemStack getItemStack(String a, String a2, List<String> a3, boolean a4, int a5, boolean a6, Map<String, String> a7, boolean a8, String a9, String a10) {
        return ItemStackUtil.getItemStack(a, a2, a3, a4, a5, a6, a7, a8, a9, null, null);
    }
}

