/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib;

import cn.handyplus.warp.lib.BaseConstants;
import cn.handyplus.warp.lib.MessageUtil;
import cn.handyplus.warp.lib.VersionCheckEnum;
import cn.handyplus.warp.service.WarpCollectionService;
import cn.handyplus.warp.util.WarpTaskUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public final class LegacyUtil {
    private static Class<?> J;
    private static Class<?> G;
    private static Class<?> XXxXxx;

    public static Attribute getAttribute(@NotNull String name) {
        if (G == null) {
            return null;
        }
        if (G.isEnum()) {
            try {
                Enum enum_ = Enum.valueOf(G.asSubclass(Enum.class), name);
                return (Attribute)enum_;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(new StringBuilder().insert(0, WarpTaskUtil.yvIhFi("\u6ce4\u6755\u623b\u526c\u76c1\u5c02\u6062fe")).append(name).toString(), illegalArgumentException);
            }
        }
        try {
            Class[] classArray = new Class[1];
            classArray[0] = String.class;
            Method method = G.getMethod(WarpCollectionService.yvIhFi("\u001fG\u0005S\fi\u000f"), classArray);
            Object[] objectArray = new Object[1];
            objectArray[0] = name;
            return (Attribute)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringBuilder().insert(0, WarpTaskUtil.yvIhFi("\u6cfd\u674c\u6222\u5275\u5c02\u6062fe")).append(name).toString(), exception);
        }
    }

    public static Particle getDripLava() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.DRIPPING_LAVA;
        }
        return Particle.valueOf((String)WarpTaskUtil.yvIhFi("\u0001\u000e\f\f\u001a\u0010\u0004\n\u0004"));
    }

    public static List<String> getEntityTypeAliveList() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId();
        EntityType[] entityTypeArray = EntityType.values();
        int n2 = entityTypeArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            EntityType entityType = entityTypeArray[n];
            if (entityType.isAlive() && entityType.isSpawnable()) {
                if (bl) {
                    arrayList.add(entityType.getKey().getKey());
                } else {
                    arrayList.add(entityType.getName());
                }
            }
            n3 = ++n;
        }
        return arrayList;
    }

    public static Sound getSound(@NotNull String sound) throws Exception {
        if (J.isEnum()) {
            Enum enum_ = Enum.valueOf(J.asSubclass(Enum.class), sound.toUpperCase());
            return (Sound)enum_;
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Method method = J.getMethod(WarpTaskUtil.yvIhFi("3=)) \u0013#"), classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = sound.toUpperCase();
        return (Sound)method.invoke(null, objectArray);
    }

    public static PotionEffectType getIncreaseDamage() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return PotionEffectType.getByName((String)WarpTaskUtil.yvIhFi("/1. 2\"(-"));
        }
        return PotionEffectType.getByName((String)WarpCollectionService.yvIhFi("\u0000H\nT\fG\u001aC6B\bK\bA\f"));
    }

    public static AttributeModifier getAttributeModifier(@NotNull String name, double amount, @NotNull AttributeModifier.Operation operation, @NotNull EquipmentSlot a) {
        UUID uUID = UUID.randomUUID();
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_21.getVersionId()) {
            return new AttributeModifier(uUID, name, amount, operation, a);
        }
        return new AttributeModifier(NamespacedKey.fromString((String)uUID.toString()), amount, operation, a.getGroup());
    }

    public static Particle getRedStone() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.DUST;
        }
        return Particle.valueOf((String)WarpCollectionService.yvIhFi("t,b:r&h,"));
    }

    public static String getEnchantmentKey(@NotNull Enchantment enchantment) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId()) {
            return enchantment.getKey().getKey();
        }
        return null;
    }

    public static String getEntityTypeName(@NotNull EntityType entityType) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId()) {
            return entityType.getKey().getKey();
        }
        return entityType.getName();
    }

    public static Enchantment getDurability() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Enchantment.UNBREAKING;
        }
        return LegacyUtil.getEnchantmentByName(WarpCollectionService.yvIhFi("b<t(d j r0"));
    }

    public static EntityType getEntityTypeByName(@NotNull String name) {
        return EntityType.fromName((String)name);
    }

    public static Enchantment getEnchantmentByName(@NotNull String name) {
        return Enchantment.getByName((String)name);
    }

    public static List<String> getEntityTypeList() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId()) {
            return Arrays.stream(EntityType.values()).filter(a -> a != EntityType.UNKNOWN).map(a -> a.getKey().getKey()).collect(Collectors.toList());
        }
        return Arrays.stream(EntityType.values()).map(EntityType::getName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Particle getFirework() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.FIREWORK;
        }
        return Particle.valueOf((String)WarpCollectionService.yvIhFi("/o;c>i;m:y:v(t\""));
    }

    public static List<String> getPotionEffectTypeList() {
        return Arrays.stream(PotionEffectType.values()).map(PotionEffectType::getName).collect(Collectors.toList());
    }

    public static Biome getBiome(@NotNull String name) throws Exception {
        if (XXxXxx.isEnum()) {
            Enum enum_ = Enum.valueOf(XXxXxx.asSubclass(Enum.class), name);
            return (Biome)enum_;
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Method method = XXxXxx.getMethod(WarpCollectionService.yvIhFi("\u001fG\u0005S\fi\u000f"), classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = name;
        return (Biome)method.invoke(null, objectArray);
    }

    public static void setMaxHealth(@NotNull Player player, double maxHealth) {
        player.setMaxHealth(maxHealth);
    }

    private /* synthetic */ LegacyUtil() {
        LegacyUtil a;
    }

    public static Enchantment getArrowDamage() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Enchantment.POWER;
        }
        return LegacyUtil.getEnchantmentByName(WarpTaskUtil.yvIhFi("\u001d\u0017\u000e\n\u000b\u001a\u0018\u0004\u0011\u0004\u001b\u0000"));
    }

    public static double getMaxHealth(@NotNull Player player) {
        return player.getMaxHealth();
    }

    public static String getEnchantmentName(@NotNull Enchantment enchantment) {
        return enchantment.getName();
    }

    public static void setGameRuleValue(@NotNull World world, @NotNull String ruleName, @NotNull Object value) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId()) {
            GameRule gameRule = GameRule.getByName((String)ruleName);
            if (gameRule == null) {
                MessageUtil.sendConsoleMessage(new StringBuilder().insert(0, WarpCollectionService.yvIhFi("\u4e30\u7525\u89e2\u5270\u001cI")).append(ruleName).append(WarpTaskUtil.yvIhFi("e\u4e51\u5b1d\u5774k")).toString());
                return;
            }
            if (value instanceof Boolean) {
                world.setGameRule(gameRule, (Object)((Boolean)value));
                return;
            }
            if (value instanceof Integer) {
                world.setGameRule(gameRule, (Object)((Integer)value));
                return;
            }
        }
        world.setGameRuleValue(ruleName, String.valueOf(value));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initClasses() {
        try {
            J = Class.forName(WarpTaskUtil.yvIhFi("37;k>07.51r\u0016302!"));
            G = BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_9.getVersionId() ? Class.forName(WarpCollectionService.yvIhFi("I\u001bAGD\u001cM\u0002O\u001d\b\bR\u001dT\u0000D\u001cR\f\b(R\u001dT\u0000D\u001cR\f")) : null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(WarpCollectionService.yvIhFi("\u6589\u6cf3\u6217\u5216\u7c12"), classNotFoundException);
        }
        {
            XXxXxx = Class.forName(WarpTaskUtil.yvIhFi("37;k>07.51r'0*?.r\u00075*1 "));
            return;
        }
    }

    public static PotionEffectType getPotionEffectTypeByName(@NotNull String name) {
        return PotionEffectType.getByName((String)name);
    }

    public static List<String> getEnchantmentList() {
        return Arrays.stream(Enchantment.values()).map(Enchantment::getName).collect(Collectors.toList());
    }
}

