/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib;

import cn.handyplus.warp.lib.BaseConstants;
import cn.handyplus.warp.lib.FormulaUtil;
import cn.handyplus.warp.lib.LegacyUtil;
import cn.handyplus.warp.lib.MapUtil;
import cn.handyplus.warp.lib.StrUtil;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class TranslationUtil {
    @NotNull
    public static String getEnchantmentTranslation(@NotNull String enchantment) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return enchantment;
        }
        String string = LegacyUtil.getEnchantmentKey(LegacyUtil.getEnchantmentByName(enchantment));
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, TranslationUtil.yvIhFi("\u001eJ\u0018L\u001aJ\u000fI\u001eJ\u000f\n\u0016M\u0015A\u0018V\u001aB\u000f\n")).append(string).toString(), enchantment);
    }

    @Nullable
    public static String getBlockTranslation(@NotNull String block) {
        if (MapUtil.isEmpty(BaseConstants.JSON_CACHE_MAP)) {
            return null;
        }
        return BaseConstants.JSON_CACHE_MAP.get(new StringBuilder().insert(0, TranslationUtil.yvIhFi("\u0019H\u0014G\u0010\n\u0016M\u0015A\u0018V\u001aB\u000f\n")).append(block.toLowerCase()).toString());
    }

    @Nullable
    public static String getItemTranslation(@NotNull String item) {
        if (MapUtil.isEmpty(BaseConstants.JSON_CACHE_MAP)) {
            return null;
        }
        return BaseConstants.JSON_CACHE_MAP.get(new StringBuilder().insert(0, FormulaUtil.b("884!\u007f!8\"4/#-78\u007f")).append(item.toLowerCase()).toString());
    }

    @NotNull
    public static String getEnchantmentLevelTranslation(@NotNull String enchantmentLevel) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return enchantmentLevel;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, FormulaUtil.b(")?/9-?8<)?8\u007f 4:4 \u007f")).append(enchantmentLevel).toString(), enchantmentLevel);
    }

    @NotNull
    public static String getEntityTranslation(@NotNull String entity) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return entity;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, FormulaUtil.b("4\"%%%5\u007f!8\"4/#-78\u007f")).append(entity.toLowerCase()).toString(), entity);
    }

    @Nullable
    public static String getMaterialTranslation(@NotNull String materialName) {
        String string = TranslationUtil.getItemTranslation(materialName);
        if (StrUtil.isNotEmpty(string)) {
            return string;
        }
        return TranslationUtil.getBlockTranslation(materialName);
    }

    @NotNull
    public static String getEffectTranslation(@NotNull String effect) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return effect;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, TranslationUtil.yvIhFi("A\u001dB\u001eG\u000f\n\u0016M\u0015A\u0018V\u001aB\u000f\n")).append(effect.toLowerCase()).toString(), effect);
    }

    public static String yvIhFi(String a) {
        int n = a.length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = (2 ^ 5) << 4 ^ (2 << 2 ^ 3);
        int cfr_ignored_0 = (2 ^ 5) << 4;
        int n4 = n2;
        int n5 = 4 << 3 ^ 4;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(a.charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(a.charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @NotNull
    public static String getColorTranslation(@NotNull String color) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return color;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault(new StringBuilder().insert(0, TranslationUtil.yvIhFi("\u0018K\u0017K\t\n\u0016M\u0015A\u0018V\u001aB\u000f\n")).append(color.toLowerCase()).toString(), color);
    }

    public TranslationUtil() {
        TranslationUtil a;
    }
}

