/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.expand.zaxxer.hikari;

import cn.handyplus.warp.lib.expand.slf4j.LoggerFactory;
import cn.handyplus.warp.lib.expand.zaxxer.hikari.HikariConfig;
import cn.handyplus.warp.lib.expand.zaxxer.hikari.HikariConfigMXBean;
import cn.handyplus.warp.lib.expand.zaxxer.hikari.HikariPoolMXBean;
import cn.handyplus.warp.lib.expand.zaxxer.hikari.metrics.MetricsTrackerFactory;
import cn.handyplus.warp.lib.expand.zaxxer.hikari.pool.HikariPool;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class HikariDataSource
extends HikariConfig
implements DataSource,
Closeable {
    private static final cn.handyplus.warp.lib.expand.slf4j.Logger LOGGER = LoggerFactory.getLogger(HikariDataSource.class);
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final HikariPool fastPathPool;
    private volatile HikariPool pool;

    public HikariDataSource() {
        this.fastPathPool = null;
    }

    public HikariDataSource(HikariConfig configuration) {
        configuration.validate();
        configuration.copyStateTo(this);
        LOGGER.info("{} - Starting...", (Object)configuration.getPoolName());
        this.pool = this.fastPathPool = new HikariPool(this);
        LOGGER.info("{} - Start completed.", (Object)configuration.getPoolName());
        this.seal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("HikariDataSource " + this + " has been closed.");
        }
        if (this.fastPathPool != null) {
            return this.fastPathPool.getConnection();
        }
        HikariPool result = this.pool;
        if (result == null) {
            HikariDataSource hikariDataSource = this;
            synchronized (hikariDataSource) {
                result = this.pool;
                if (result == null) {
                    this.validate();
                    LOGGER.info("{} - Starting...", (Object)this.getPoolName());
                    try {
                        this.pool = result = new HikariPool(this);
                        this.seal();
                    }
                    catch (HikariPool.PoolInitializationException pie) {
                        if (pie.getCause() instanceof SQLException) {
                            throw (SQLException)pie.getCause();
                        }
                        throw pie;
                    }
                    LOGGER.info("{} - Start completed.", (Object)this.getPoolName());
                }
            }
        }
        return result.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        HikariPool p2 = this.pool;
        return p2 != null ? p2.getUnwrappedDataSource().getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        HikariPool p2 = this.pool;
        if (p2 != null) {
            p2.getUnwrappedDataSource().setLogWriter(out);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        HikariPool p2 = this.pool;
        if (p2 != null) {
            p2.getUnwrappedDataSource().setLoginTimeout(seconds);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        HikariPool p2 = this.pool;
        return p2 != null ? p2.getUnwrappedDataSource().getLoginTimeout() : 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        HikariPool p2 = this.pool;
        if (p2 != null) {
            DataSource unwrappedDataSource = p2.getUnwrappedDataSource();
            if (iface.isInstance(unwrappedDataSource)) {
                return (T)unwrappedDataSource;
            }
            if (unwrappedDataSource != null) {
                return unwrappedDataSource.unwrap(iface);
            }
        }
        throw new SQLException("Wrapped DataSource is not an instance of " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return true;
        }
        HikariPool p2 = this.pool;
        if (p2 != null) {
            DataSource unwrappedDataSource = p2.getUnwrappedDataSource();
            if (iface.isInstance(unwrappedDataSource)) {
                return true;
            }
            if (unwrappedDataSource != null) {
                return unwrappedDataSource.isWrapperFor(iface);
            }
        }
        return false;
    }

    @Override
    public void setMetricRegistry(Object metricRegistry) {
        boolean isAlreadySet = this.getMetricRegistry() != null;
        super.setMetricRegistry(metricRegistry);
        HikariPool p2 = this.pool;
        if (p2 != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("MetricRegistry can only be set one time");
            }
            p2.setMetricRegistry(super.getMetricRegistry());
        }
    }

    @Override
    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        boolean isAlreadySet = this.getMetricsTrackerFactory() != null;
        super.setMetricsTrackerFactory(metricsTrackerFactory);
        HikariPool p2 = this.pool;
        if (p2 != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("MetricsTrackerFactory can only be set one time");
            }
            p2.setMetricsTrackerFactory(super.getMetricsTrackerFactory());
        }
    }

    @Override
    public void setHealthCheckRegistry(Object healthCheckRegistry) {
        boolean isAlreadySet = this.getHealthCheckRegistry() != null;
        super.setHealthCheckRegistry(healthCheckRegistry);
        HikariPool p2 = this.pool;
        if (p2 != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("HealthCheckRegistry can only be set one time");
            }
            p2.setHealthCheckRegistry(super.getHealthCheckRegistry());
        }
    }

    public boolean isRunning() {
        return this.pool != null && this.pool.poolState == 0;
    }

    public HikariPoolMXBean getHikariPoolMXBean() {
        return this.pool;
    }

    public HikariConfigMXBean getHikariConfigMXBean() {
        return this;
    }

    public void evictConnection(Connection connection) {
        HikariPool p2;
        if (!this.isClosed() && (p2 = this.pool) != null && connection.getClass().getName().startsWith("cn.handyplus.warp.lib.expand.zaxxer.hikari")) {
            p2.evictConnection(connection);
        }
    }

    @Override
    public void close() {
        if (this.isShutdown.getAndSet(true)) {
            return;
        }
        HikariPool p2 = this.pool;
        if (p2 != null) {
            try {
                LOGGER.info("{} - Shutdown initiated...", (Object)this.getPoolName());
                p2.shutdown();
                LOGGER.info("{} - Shutdown completed.", (Object)this.getPoolName());
            }
            catch (InterruptedException e2) {
                LOGGER.warn("{} - Interrupted during closing", (Object)this.getPoolName(), (Object)e2);
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isClosed() {
        return this.isShutdown.get();
    }

    public String toString() {
        return "HikariDataSource (" + this.pool + ")";
    }
}

